/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import io.netty.channel.Channel;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class TextComponentHelper {
    private TextComponentHelper() {
    }

    public static TextComponentBase createComponentTranslation(ICommandSender sender, String translation, Object ... args) {
        if (TextComponentHelper.isVanillaClient(sender)) {
            return new TextComponentString(I18n.translateToLocalFormatted(translation, args));
        }
        return new TextComponentTranslation(translation, args);
    }

    private static boolean isVanillaClient(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)sender;
            NetHandlerPlayServer connection = playerMP.connection;
            if (connection != null) {
                NetworkManager netManager = connection.netManager;
                Channel channel = netManager.channel();
                return (Boolean)channel.attr(NetworkRegistry.FML_MARKER).get() == false;
            }
        }
        return false;
    }
}

