/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.console;

import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraftforge.server.console.ConsoleCommandCompleter;
import net.minecraftforge.server.terminalconsole.TerminalConsoleAppender;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;

public final class TerminalHandler {
    private TerminalHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleCommands(DedicatedServer server) {
        Terminal terminal = TerminalConsoleAppender.getTerminal();
        if (terminal == null) {
            return false;
        }
        LineReader reader = LineReaderBuilder.builder().appName("Cleanroom").terminal(terminal).completer((Completer)new ConsoleCommandCompleter(server)).build();
        reader.setOpt(LineReader.Option.DISABLE_EVENT_EXPANSION);
        reader.unsetOpt(LineReader.Option.INSERT_TAB);
        TerminalConsoleAppender.setReader(reader);
        try {
            while (!server.isServerStopped() && server.isServerRunning()) {
                String line;
                try {
                    line = reader.readLine("> ");
                }
                catch (EndOfFileException ignored) {
                    continue;
                }
                if (line == null) {
                    break;
                }
                if ((line = line.trim()).isEmpty()) continue;
                server.addPendingCommand(line, server);
            }
        }
        catch (UserInterruptException e) {
            server.initiateShutdown();
        }
        finally {
            TerminalConsoleAppender.setReader(null);
        }
        return true;
    }
}

