export class GamePromises {
    /**
     * @overload
     * @param { string } title
     * @returns { Promise<string | false> }
     */
    prompt(title: string): Promise<string | false>;
    /**
     * @overload
     * @param { string } title
     * @param { boolean } [forced]
     * @returns { Promise<string> }
     *
     */
    prompt(title: string, forced?: boolean | undefined): Promise<string>;
    /**
     * 模仿h5的alert，用于显示信息的对话框
     *
     * @param { string } title
     * @example
     * ```js
     * await game.promises.alert('弹窗内容');
     * ```
     * @returns { Promise<true> }
     */
    alert(title: string): Promise<true>;
    download(url: any, folder: any, dev: any, onprogress: any): Promise<any>;
    /**
     * @param {string} filename
     * @returns {Promise<ArrayBuffer | Buffer>}
     */
    readFile(filename: string): Promise<ArrayBuffer | Buffer>;
    readFileAsText(filename: any): Promise<any>;
    writeFile(data: any, path: any, name: any): Promise<any>;
    ensureDirectory(list: any, callback: any, file: any): Promise<any>;
    createDir(directory: any): Promise<any>;
    removeFile(filename: any): Promise<void>;
    removeDir(directory: any): Promise<void>;
}
