export class Get {
    is: Is;
    promises: Promises;
    /**
     * 获取当前内核版本信息
     *
     * 目前仅考虑`chrome`, `firefox`和`safari`三种浏览器的信息，其余均归于其他范畴
     *
     * > 其他后续或许会增加，但`IE`永无可能
     *
     * @returns {["firefox" | "chrome" | "safari" | "other", number, number, number]}
     */
    coreInfo(): ["firefox" | "chrome" | "safari" | "other", number, number, number];
    /**
     * 返回 VCard[] 形式的所有牌，用于印卡将遍历
     * @param {Function} filter
     * @returns {string[][]}
     */
    inpileVCardList(filter: Function): string[][];
    /**
     * 根据(Player的)座次数n（从1开始）获取对应的“n号位”翻译
     * @param {number | Player} seat
     */
    seatTranslation(seat: number | Player): string;
    /**
     * @param {number} numberOfPlayers
     * @returns {string[]}
     */
    identityList(numberOfPlayers: number): string[];
    /**
     * Generate an object URL from the Base64-encoded octet stream
     *
     * 从Base64编码的八位字节流生成对象URL
     */
    objectURL(octetStream: any): any;
    /**
     * Get the card name length
     *
     * 获取此牌的字数
     */
    cardNameLength(card: any, player: any): number;
    /**
     * Get the Yingbian conditions (of the card)
     *
     * 获取（此牌的）应变条件
     */
    yingbianConditions(card: any): string[];
    complexYingbianConditions(card: any): string[];
    simpleYingbianConditions(card: any): string[];
    /**
     * Get the Yingbian effects (of the card)
     *
     * 获取（此牌的）应变效果
     */
    yingbianEffects(card: any): string[];
    /**
     * Get the default Yingbian effect of the card
     *
     * 获取此牌的默认应变效果
     */
    defaultYingbianEffect(card: any): any;
    /**
     * 优先度判断
     */
    priority(skill: any): any;
    /**
     * 新装备栏相关
     *
     * 获取一张装备牌实际占用的装备栏(君曹操六龙)
     *
     * 用法同{@link subtype}，返回数组
     *
     * @param { string | Card | VCard | CardBaseUIData } obj
     * @param { false | Player } [player]
     * @returns { string[] }
     */
    subtypes(obj: string | Card | VCard | CardBaseUIData, player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): string[];
    /**
     * @returns { string[] }
     */
    pinyin(chinese: any, withTone: any): string[];
    yunmu(str: any): any;
    /**
     * 用于将参数转换为字符串，作为缓存的key。
     */
    paramToCacheKey(...args: any[]): string;
    yunjiao(str: any): string | null;
    /**
     * @param { string } skill
     * @param { Player } player
     * @returns { string[] }
     */
    skillCategoriesOf(skill: string, player: Player): string[];
    numOf(obj: any, item: any): any;
    connectNickname(): any;
    zhinangs(filter: any): any;
    sourceCharacter(str: any): any;
    isLuckyStar(player: any): any;
    infoHp(hp: any): number;
    infoMaxHp(hp: any): number;
    infoHujia(hp: any): number;
    bottomCards(num: any, putBack: any): Node | Node[];
    discarded(): any;
    cardOffset(): number;
    colorspan(str: any): any;
    evtprompt(next: any, str: any): void;
    autoViewAs(card: any, cards: any): import("../library/element/vcard.js").VCard;
    /**
     * @deprecated
     */
    _autoViewAs(card: any, cards: any): any;
    max(list: any, func: any, type: any): any;
    min(list: any, func: any, type: any): any;
    /**
     * @overload
     * @param { string } name
     * @returns { Character }
     */
    character(name: string): Character;
    /**
     * @template { 0 | 1 | 2 | 3 | 4 } T
     * @overload
     * @param { string } name
     * @param { T } num
     * @returns { Character[T] }
     */
    character<T extends 0 | 1 | 2 | 3 | 4>(name: string, num: T): Character[T];
    characterInitFilter(name: any): string[];
    characterIntro(name: any): any;
    bordergroup(info: any, raw: any): any;
    groupnature(group: any, method: any): any;
    sgn(num: any): 0 | 1 | -1;
    rand(num: any, num2: any): any;
    sort(arr: any, method: any, arg: any): any;
    sortSeat(arr: any, target: any): any;
    /**
     * @param { (zip: JSZip) => any } callback
     */
    zip(callback: (zip: JSZip) => any): void;
    delayx(num: any, max: any): number;
    prompt(skill: any, target: any, player: any): string;
    prompt2(skill: any, target: any, player: any, ...args: any[]): string;
    url(master: any): string;
    round(num: any, f: any): number;
    playerNumber(): number;
    benchmark(func1: any, func2: any, iteration: any, arg: any): number | undefined;
    /**
     * @param {any} obj
     */
    stringify(obj: any, level?: number): any;
    /**
     * 深拷贝函数（虽然只处理了部分情况）
     *
     * 除了普通的Object和NullObject，均不考虑自行赋值的数据，但会原样将Symbol复制过去
     *
     * @template T
     * @param {T} obj - 要复制的对象，若不是对象则直接返回原值
     * @param {boolean} [copyKeyDeep = false] - 是否深复制`Map`的`key`
     * @param {WeakMap<object, unknown>} [map] - 拷贝用的临时存储，用于处理循环引用（请勿自行赋值）
     * @returns {T} - 深拷贝后的对象，若传入值不是对象则为传入值
     */
    copy<T_1>(obj: T_1, copyKeyDeep?: boolean | undefined, map?: WeakMap<any, unknown> | undefined): T_1;
    inpilefull(type: any): {
        name: any;
        suit: any;
        number: any;
        nature: any;
    }[];
    inpile(type: any, filter: any): any[];
    inpile2(type: any): any[];
    typeCard(type: any, filter: any): string[];
    libCard(filter: any): string[];
    ip(): any;
    modetrans(config: any, server: any): string;
    charactersOL(func: any): number[];
    trimip(str: any): any;
    mode(): any;
    idDialog(id: any): import("noname-typings/nonameModules/noname/library/element/dialog.js").Dialog | null;
    arenaState(): {
        number: string | undefined;
        players: {};
        mode: any;
        dying: any[];
        servermode: any;
        roomId: any;
        over: boolean;
        inpile: any[];
        inpile_nature: any[];
        renku: any[];
    };
    skillState(player: any): {
        global: string[];
    };
    id(): string;
    zhu(player: any, skill: any, group: any): any;
    config(item: any, mode: any): any;
    coinCoeff(list: any): number;
    rank(name: any, num: any): number | "x" | "s" | "c" | "d" | "b" | "a" | "ap" | "am" | "bp" | "bm" | "sp";
    skillRank(skill: any, type: any, grouped: any): number;
    targetsInfo(targets: any): any[];
    infoTargets(infos: any): import("noname-typings/nonameModules/noname/library/element/player.js").Player[];
    cardInfo(card: any): any[];
    cardsInfo(cards?: any[]): any[][];
    infoCard(info: any): import("../library/element/card.js").Card;
    infoCards(infos: any): import("../library/element/card.js").Card[];
    cardInfoOL(card: any): string;
    infoCardOL(info: any): any;
    cardsInfoOL(cards: any): string[];
    infoCardsOL(infos: any): any[];
    playerInfoOL(player: any): string;
    infoPlayerOL(info: any): any;
    playersInfoOL(players: any): string[];
    infoPlayersOL(infos: any): any[];
    funcInfoOL(func: any): any;
    infoFuncOL(info: any): any;
    eventInfoOL(item: any, level: any, noMore: any): string;
    /**
     * @param {string} item
     */
    infoEventOL(item: string): import("../library/element/gameEvent.js").GameEvent;
    stringifiedResult(item: any, level: any, nomore: any): any;
    parsedResult(item: any): any;
    verticalStr(str: any, sp: any): string;
    numStr(num: any, method: any): any;
    rawName(str: any): any;
    /**
     * 作用修改：只读前缀 不读_ab
     */
    rawName2(str: any): any;
    slimNameHorizontal(str: any): any;
    /**
     * @param {string} prefix
     * @param {string} name
     * @returns {string}
     */
    prefixSpan(prefix: string, name: string): string;
    slimName(str: any): string;
    time(): number;
    utc(): number;
    evtDistance(e1: any, e2: any): number;
    xyDistance(from: any, to: any): number;
    /**
     * @overload
     * @returns { void }
     */
    itemtype(): void;
    /**
     * @overload
     * @param { string } obj
     * @returns { 'position' | 'natures' | 'nature' }
     */
    itemtype(obj: string): 'position' | 'natures' | 'nature';
    /**
     * @overload
     * @param { Player[] } obj
     * @returns { 'players' }
     */
    itemtype(obj: Player[]): 'players';
    /**
     * @overload
     * @param { Card[] } obj
     * @returns { 'cards' }
     */
    itemtype(obj: Card[]): 'cards';
    /**
     * @overload
     * @param { [number, number] } obj
     * @returns { 'select' }
     */
    itemtype(obj: [number, number]): 'select';
    /**
     * @overload
     * @param { [number, number, number, number] } obj
     * @returns { 'divposition' }
     */
    itemtype(obj: [number, number, number, number]): 'divposition';
    /**
     * @overload
     * @param { Button } obj
     * @returns { 'button' }
     */
    itemtype(obj: Button): 'button';
    /**
     * @overload
     * @param { Card } obj
     * @returns { 'card' }
     */
    itemtype(obj: Card): 'card';
    /**
     * @overload
     * @param { Player } obj
     * @returns { 'player' }
     */
    itemtype(obj: Player): 'player';
    /**
     * @overload
     * @param { Dialog } obj
     * @returns { 'dialog' }
     */
    itemtype(obj: Dialog): 'dialog';
    /**
     * @overload
     * @param { GameEvent | GameEventPromise } obj
     * @returns { 'event' }
     */
    itemtype(obj: GameEvent | GameEventPromise): 'event';
    equipNum(card: any): number;
    objtype(obj: any): "div" | "object" | "array" | "table" | "tr" | "td" | "fragment" | undefined;
    type(obj: any, method: any, player: any): any;
    type2(card: any, player: any): any;
    /**
     *
     * @param { string | Card | VCard | CardBaseUIData } obj
     * @param { false | Player } [player]
     * @returns { string }
     */
    subtype(obj: string | Card | VCard | CardBaseUIData, player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): string;
    equiptype(card: any, player: any): number;
    /**
     *
     * @param { Card | VCard | CardBaseUIData } card
     * @param { false | Player } [player]
     * @returns { string }
     */
    name(card: Card | VCard | CardBaseUIData, player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): string;
    /**
     * @param {Card | VCard | Card[] | VCard[]} card
     * @param {false | Player} [player]
     * @returns {string}
     */
    suit(card: Card | VCard | Card[] | VCard[], player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): string;
    /**
     * @param {Card | VCard | Card[] | VCard[]} card
     * @param {false | Player} [player]
     * @returns {string}
     */
    color(card: Card | VCard | Card[] | VCard[], player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): string;
    /**
     * @param {Card | VCard} card
     * @param {false | Player} [player]
     * @returns {number}
     */
    number(card: Card | VCard, player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): number;
    /**
     * 返回一张杀的属性。如有多种属性则用`lib.natureSeparator`分割开来。例：火雷【杀】的返回值为`fire|thunder`
     * @param {string | string[] | Card | VCard} card
     * @param {false | Player} [player]
     * @returns {string}
     */
    nature(card: string | string[] | Card | VCard, player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): string;
    /**
     * 返回包含所有属性的数组
     * @param {string[] | string} card
     * @param {false | Player} [player]
     * @returns {string[]}
     */
    natureList(card: string[] | string, player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): string[];
    cards(num: any, putBack: any): Node | Node[];
    judge(card: any): any;
    judge2(card: any): any;
    distance(from: any, to: any, method: any): number;
    /**
     * @overload
     * @param { string } item
     * @returns { Skill }
     */
    info(item: string): Skill;
    /**
     * @overload
     * @param { Card | VCard | CardBaseUIData } item
     * @param { Player | false } [player]
     * @returns { any }
     */
    info(item: Card | VCard | CardBaseUIData, player?: false | import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined): any;
    /**
     * @param { number | Select | (()=>Select) } [select]
     * @returns { Select }
     */
    select(select?: number | Select | (() => Select) | undefined): Select;
    card(original: any): any;
    /**
     * @overload
     * @returns {GameEvent}
     */
    event(): GameEvent;
    /**
     * @template { keyof GameEvent } T
     * @overload
     * @param {T} key
     * @returns {GameEvent[T]}
     */
    event<T_2 extends keyof import("noname-typings/nonameModules/noname/library/element/gameEvent.js").GameEvent>(key: T_2): import("noname-typings/nonameModules/noname/library/element/gameEvent.js").GameEvent[T_2];
    player(): import("noname-typings/nonameModules/noname/library/element/player.js").Player;
    players(sort: any, dead: any, out: any): import("noname-typings/nonameModules/noname/library/element/player.js").Player[];
    position(card: any, ordering: any): number | "e" | "j" | "x" | "s" | "h" | "c" | "d" | "o" | null | undefined;
    skillTranslation(str: any, player: any): string;
    skillInfoTranslation(name: any, player: any): any;
    /**
     * @returns {string}
     */
    translation(str: any, arg: any): string;
    menuZoom(): any;
    strNumber(num: any): any;
    cnNumber(num: any, ordinal: any): any;
    /**
     * 遍历子元素
     * @param {HTMLElement} node
     * @returns {Iterable<HTMLElement>} 迭代器
     */
    iterableChildNodes(node: HTMLElement, ...args: any[]): Iterable<HTMLElement>;
    /**
     * @param {((a: Button, b: Button) => number)} [sort] 排序函数
     * @returns { Button[] }
     */
    selectableButtons(sort?: ((a: Button, b: Button) => number) | undefined): Button[];
    /**
     * @param {((a: Card, b: Card) => number)} [sort] 排序函数
     * @returns { Card[] }
     */
    selectableCards(sort?: ((a: Card, b: Card) => number) | undefined): Card[];
    /**
     * @returns { string[] } 技能名数组
     */
    skills(): string[];
    gainableSkills(func: any, player: any): any[];
    gainableSkillsName(name: any, func: any): any[];
    gainableCharacters(func: any): string[];
    /**
     * @param {((a: Player, b: Player) => number)} [sort] 排序函数
     * @returns { Player[] }
     */
    selectableTargets(sort?: ((a: Player, b: Player) => number) | undefined): Player[];
    filter(filter: any, i: any): any;
    cardCount(card: any, player: any): any;
    skillCount(skill: any, player: any): any;
    owner(card: any, method: any): import("noname-typings/nonameModules/noname/library/element/player.js").Player | undefined;
    noSelected(): boolean;
    population(identity: any): number;
    totalPopulation(identity: any): number;
    /**
     * @param { Card | VCard } item
     */
    cardtag(item: Card | VCard, tag: any): any;
    tag(item: any, tag: any, item2: any, bool: any): any;
    sortCard(sort: any): ((card: any) => any) | undefined;
    difficulty(): 2 | 1 | 3;
    cardPile(name: any, create: any): any;
    cardPile2(name: any): any;
    discardPile(name: any): any;
    aiStrategy(): 2 | 1 | 3 | 4 | 5 | 6;
    skillintro(name: any, learn: any, learn2: any): string;
    intro(name: any): string;
    storageintro(type: any, content: any, player: any, dialog: any, skill: any): any;
    nodeintro(node: any, simple: any, evt: any): import("../library/element/dialog.js").Dialog | undefined;
    linkintro(dialog: any, content: any, player: any): void;
    groups(): string[];
    types(): any[];
    links(buttons: any): any[];
    threaten(target: any, player: any, hp: any): number;
    condition(player: any): any;
    attitude(from: any, to: any, ...args: any[]): any;
    sgnAttitude(...args: any[]): 0 | 1 | -1;
    useful_raw(card: any, player: any): any;
    useful(card: any, player: any): any;
    unuseful(card: any): number;
    unuseful2(card: any): number;
    unuseful3(card: any): number;
    value(card: any, player: any, method: any): any;
    equipResult(player: any, target: any, name: any): number;
    equipValue(card: any, player: any): number;
    equipValueNumber(card: any): number;
    disvalue(card: any, player: any): number;
    disvalue2(card: any, player: any): number;
    skillthreaten(skill: any, player: any, target: any): number | void;
    cacheOrder(item: any): number;
    /**
     * @returns { number }
     */
    order(item: any, player?: import("noname-typings/nonameModules/noname/library/element/player.js").Player): number;
    result(item: any, skill: any): any;
    cacheEffectUse(target: any, card: any, player: any, player2: any, isLink: any): number;
    effect_use(target: any, card: any, player: any, player2: any, isLink: any): number;
    cacheEffect(target: any, card: any, player: any, player2: any, isLink: any): number;
    effect(target: any, card: any, player: any, player2: any, isLink: any): number;
    damageEffect(target: any, player: any, viewer: any, nature: any): any;
    /**
     *
     * @param {any} source 如果参数是function，执行此函数并返回结果，传参为此方法剩余的参数。如果参数不是function，直接返回结果。
     * @returns 返回的结果
     */
    dynamicVariable(source: any, ...args: any[]): any;
    recoverEffect(target: any, player: any, viewer: any): number;
    buttonValue(button: any): number;
    attitude2(to: any): any;
}
export let get: Get;
export function setGet(instance?: Get | undefined): void;
import { Is } from "./is.js";
import { Promises } from "./promises.js";
export { Is, Promises };
