/**
 * @template T
 * @typedef {import("./index").AnnounceSubscriberType<T>} AnnounceSubscriberType
 */
/**
 * @typedef {import("./index").IAnnounceSubscriber} IAnnounceSubscriber
 */
/**
 *
 */
export class Announce {
    /**
     *
     * @param {EventTarget} eventTarget
     * @param {WeakMap<function(any): void, IAnnounceSubscriber>} records
     * @param {AnnounceSubscriberType<any>} [SubscriberType]
     */
    constructor(eventTarget: EventTarget, records: WeakMap<(arg0: any) => void, IAnnounceSubscriber>, SubscriberType?: AnnounceSubscriberType<any> | undefined);
    /**
     * 推送任意数据给所有监听了指定事件的订阅者，并返回给定的数据
     *
     * 若不存在订阅指定事件的订阅者，则推送的数据将无意义
     *
     * @template T
     * @param {string} name - 要推送事件的名称
     * @param {T} values - 要推送的数据
     * @returns {T}
     */
    publish<T>(name: string, values: T): T;
    /**
     * 订阅给定名字的事件，并返回给定的函数
     *
     * 在事件触发时执行给定的函数
     *
     * 给定的函数将被存储至当前实例中，用于取消订阅时获取
     *
     * @template T
     * @param {string} name - 要订阅事件的名称
     * @param {(values: T) => void} method - 事件触发时执行的函数
     * @returns {(values: T) => void}
     */
    subscribe<T_1>(name: string, method: (values: T_1) => void): (values: T_1) => void;
    /**
     * 取消指定事件某一个函数的订阅，并返回该函数
     *
     * 给定的函数将不再于事件触发时执行，其余同事件需触发的函数不受限制
     *
     * @template T
     * @param {string} name - 要取消订阅事件的名称
     * @param {(values: T) => void} method - 订阅指定事件的函数
     * @returns {(values: T) => void}
     */
    unsubscribe<T_2>(name: string, method: (values: T_2) => void): (values: T_2) => void;
    #private;
}
/**
 * @template T
 */
export class AnnounceSubscriber<T> {
    /**
     *
     * @param {function(T, string): void} content
     * @param {EventTarget} target
     */
    constructor(content: (arg0: T, arg1: string) => void, target: EventTarget);
    get isEmpty(): boolean;
    /**
     * @param {string} name
     */
    subscribe(name: string): void;
    /**
     * @param {string} name
     */
    unsubscribe(name: string): void;
    #private;
}
export type AnnounceSubscriberType<T> = import("./index").AnnounceSubscriberType<T>;
export type IAnnounceSubscriber = import("./index").IAnnounceSubscriber;
