export class LibInit {
    /**
     * 部分函数的Promise版本
     */
    promises: LibInitPromises;
    init(): void;
    reset(): void;
    onload(): Promise<void>;
    startOnline(): void;
    onfree(): void;
    connection(ws: any): void;
    sheet(...args: any[]): HTMLStyleElement;
    css(path: any, file: any, before: any): HTMLLinkElement;
    jsForExtension(path: any, file: any, onLoad: any, onError: any): void;
    js(path: any, file: any, onLoad: any, onError: any): HTMLScriptElement | undefined;
    /**
     * 同步lib.init.js
     * @returns { void }
     */
    jsSync(path: any, file: any, onLoad: any, onError: any): void;
    req(str: any, onload: any, onerror: any, master: any): void;
    /**
     * 同步lib.init.req
     */
    reqSync(str: any, onload: any, onerror: any, master: any): string | undefined;
    json(url: any, onload: any, onerror: any): void;
    /**
     * 同步lib.init.json
     */
    jsonSync(url: any, onload: any, onerror: any): void;
    cssstyles(): void;
    layout(layout: any, nosave: any): void;
    background(): void;
    /**
     *
     * @param {*} item
     * @param {Function} [scope] 作用域
     * @returns
     */
    parsex(item: any, scope?: Function | undefined): any;
    eval(func: any): any;
    encode(strUni: any): string;
    decode(str: any): string;
    stringify(obj: any): string;
    stringifySkill(obj: any): string;
    /**
     * 在返回当前加载的esm模块相对位置。
     * @param {*} url 传入import.meta.url
     */
    getCurrentFileLocation(url: any): string;
}
import { LibInitPromises } from "./promises.js";
