export class LibInitPromises {
    /**
     * Promise版的`lib.init.js`
     *
     * @param {string} path - 文件路径
     * @param {string | string[]} [file] - 文件名或文件名组，忽略则直接读取`path`的内容
     * @returns {Promise<Event>}
     */
    js(path: string, file?: string | string[] | undefined): Promise<Event>;
    /**
     * Promise版的`lib.init.css`
     *
     * @param {string} path - 文件路径
     * @param {string | string[]} [file] - 文件名或文件名组，忽略则直接读取`path`的内容
     * @param {Element} [before] - 新样式dom的位置
     * @param {boolean} [noerror = false] - 是否忽略报错
     * @returns {Promise<HTMLLinkElement>}
     */
    css(path: string, file?: string | string[] | undefined, before?: Element | undefined, noerror?: boolean | undefined): Promise<HTMLLinkElement>;
    /**
     * Promise版的`lib.init.req`
     *
     * @param {string} str - 要读取的地址
     * @param {string} [master]
     * @returns {Promise<ProgressEvent>}
     */
    req(str: string, master?: string | undefined): Promise<ProgressEvent>;
    /**
     * Promise版的`lib.init.json`
     *
     * @param {string} url - 要读取的地址
     * @returns {Promise<object>}
     */
    json(url: string): Promise<object>;
    /**
     * Promise版的`lib.init.sheet`
     *
     * @returns {Promise<HTMLStyleElement>}
     */
    sheet(): Promise<HTMLStyleElement>;
}
