/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.com.sun.media.sound.ModelDirectedPlayer;
import cn.sherlock.com.sun.media.sound.ModelDirector;
import cn.sherlock.com.sun.media.sound.ModelPerformer;

public class ModelStandardDirector
implements ModelDirector {
    ModelPerformer[] performers;
    ModelDirectedPlayer player;
    boolean noteOnUsed = false;
    boolean noteOffUsed = false;

    public ModelStandardDirector(ModelPerformer[] performers, ModelDirectedPlayer player) {
        this.performers = performers;
        this.player = player;
        for (int i = 0; i < performers.length; ++i) {
            ModelPerformer p = performers[i];
            if (p.isReleaseTriggered()) {
                this.noteOffUsed = true;
                continue;
            }
            this.noteOnUsed = true;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void noteOff(int noteNumber, int velocity) {
        if (!this.noteOffUsed) {
            return;
        }
        for (int i = 0; i < this.performers.length; ++i) {
            ModelPerformer p = this.performers[i];
            if (p.getKeyFrom() > noteNumber || p.getKeyTo() < noteNumber || p.getVelFrom() > velocity || p.getVelTo() < velocity || !p.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }

    @Override
    public void noteOn(int noteNumber, int velocity) {
        if (!this.noteOnUsed) {
            return;
        }
        for (int i = 0; i < this.performers.length; ++i) {
            ModelPerformer p = this.performers[i];
            if (p.getKeyFrom() > noteNumber || p.getKeyTo() < noteNumber || p.getVelFrom() > velocity || p.getVelTo() < velocity || p.isReleaseTriggered()) continue;
            this.player.play(i, null);
        }
    }
}

