/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.com.sun.media.sound.ModelByteBuffer;
import cn.sherlock.com.sun.media.sound.ModelByteBufferWavetable;
import cn.sherlock.com.sun.media.sound.ModelConnectionBlock;
import cn.sherlock.com.sun.media.sound.ModelDestination;
import cn.sherlock.com.sun.media.sound.ModelIdentifier;
import cn.sherlock.com.sun.media.sound.ModelInstrument;
import cn.sherlock.com.sun.media.sound.ModelPatch;
import cn.sherlock.com.sun.media.sound.ModelPerformer;
import cn.sherlock.com.sun.media.sound.ModelSource;
import cn.sherlock.com.sun.media.sound.ModelStandardTransform;
import cn.sherlock.com.sun.media.sound.ModelTransform;
import cn.sherlock.com.sun.media.sound.SF2GlobalRegion;
import cn.sherlock.com.sun.media.sound.SF2InstrumentRegion;
import cn.sherlock.com.sun.media.sound.SF2Layer;
import cn.sherlock.com.sun.media.sound.SF2LayerRegion;
import cn.sherlock.com.sun.media.sound.SF2Modulator;
import cn.sherlock.com.sun.media.sound.SF2Region;
import cn.sherlock.com.sun.media.sound.SF2Sample;
import cn.sherlock.com.sun.media.sound.SF2Soundbank;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.kshoji.javax.sound.midi.Patch;

public class SF2Instrument
extends ModelInstrument {
    protected String name = "";
    protected int preset = 0;
    protected int bank = 0;
    protected long library = 0L;
    protected long genre = 0L;
    protected long morphology = 0L;
    protected SF2GlobalRegion globalregion = null;
    protected List<SF2InstrumentRegion> regions = new ArrayList<SF2InstrumentRegion>();

    public SF2Instrument() {
        super(null, null, null, null);
    }

    public SF2Instrument(SF2Soundbank soundbank) {
        super(soundbank, null, null, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Patch getPatch() {
        if (this.bank == 128) {
            return new ModelPatch(0, this.preset, true);
        }
        return new ModelPatch(this.bank << 7, this.preset, false);
    }

    public void setPatch(Patch patch) {
        if (patch instanceof ModelPatch && ((ModelPatch)patch).isPercussion()) {
            this.bank = 128;
            this.preset = patch.getProgram();
        } else {
            this.bank = patch.getBank() >> 7;
            this.preset = patch.getProgram();
        }
    }

    @Override
    public Object getData() {
        return null;
    }

    public long getGenre() {
        return this.genre;
    }

    public void setGenre(long genre) {
        this.genre = genre;
    }

    public long getLibrary() {
        return this.library;
    }

    public void setLibrary(long library) {
        this.library = library;
    }

    public long getMorphology() {
        return this.morphology;
    }

    public void setMorphology(long morphology) {
        this.morphology = morphology;
    }

    public List<SF2InstrumentRegion> getRegions() {
        return this.regions;
    }

    public SF2GlobalRegion getGlobalRegion() {
        return this.globalregion;
    }

    public void setGlobalZone(SF2GlobalRegion zone) {
        this.globalregion = zone;
    }

    public String toString() {
        if (this.bank == 128) {
            return "Drumkit: " + this.name + " preset #" + this.preset;
        }
        return "Instrument: " + this.name + " bank #" + this.bank + " preset #" + this.preset;
    }

    @Override
    public ModelPerformer[] getPerformers() {
        int performercount = 0;
        for (SF2InstrumentRegion presetzone : this.regions) {
            performercount += presetzone.getLayer().getRegions().size();
        }
        ModelPerformer[] performers = new ModelPerformer[performercount];
        int pi = 0;
        SF2GlobalRegion presetglobal = this.globalregion;
        for (SF2InstrumentRegion presetzone : this.regions) {
            HashMap<Integer, Short> pgenerators = new HashMap<Integer, Short>();
            pgenerators.putAll(presetzone.getGenerators());
            if (presetglobal != null) {
                pgenerators.putAll(presetglobal.getGenerators());
            }
            SF2Layer layer = presetzone.getLayer();
            SF2GlobalRegion layerglobal = layer.getGlobalRegion();
            for (SF2LayerRegion layerzone : layer.getRegions()) {
                ModelIdentifier dest;
                ModelIdentifier src;
                float fvalue;
                byte[] bytes;
                ModelPerformer performer = new ModelPerformer();
                if (layerzone.getSample() != null) {
                    performer.setName(layerzone.getSample().getName());
                } else {
                    performer.setName(layer.getName());
                }
                performers[pi++] = performer;
                byte keyfrom = 0;
                byte keyto = 127;
                byte velfrom = 0;
                byte velto = 127;
                if (layerzone.contains(57)) {
                    performer.setExclusiveClass(layerzone.getInteger(57));
                }
                if (layerzone.contains(43)) {
                    bytes = layerzone.getBytes(43);
                    if (bytes[0] >= 0 && bytes[0] > keyfrom) {
                        keyfrom = bytes[0];
                    }
                    if (bytes[1] >= 0 && bytes[1] < keyto) {
                        keyto = bytes[1];
                    }
                }
                if (layerzone.contains(44)) {
                    bytes = layerzone.getBytes(44);
                    if (bytes[0] >= 0 && bytes[0] > velfrom) {
                        velfrom = bytes[0];
                    }
                    if (bytes[1] >= 0 && bytes[1] < velto) {
                        velto = bytes[1];
                    }
                }
                if (presetzone.contains(43)) {
                    bytes = presetzone.getBytes(43);
                    if (bytes[0] > keyfrom) {
                        keyfrom = bytes[0];
                    }
                    if (bytes[1] < keyto) {
                        keyto = bytes[1];
                    }
                }
                if (presetzone.contains(44)) {
                    bytes = presetzone.getBytes(44);
                    if (bytes[0] > velfrom) {
                        velfrom = bytes[0];
                    }
                    if (bytes[1] < velto) {
                        velto = bytes[1];
                    }
                }
                performer.setKeyFrom(keyfrom);
                performer.setKeyTo(keyto);
                performer.setVelFrom(velfrom);
                performer.setVelTo(velto);
                int startAddrsOffset = layerzone.getShort(0);
                int endAddrsOffset = layerzone.getShort(1);
                int startloopAddrsOffset = layerzone.getShort(2);
                int endloopAddrsOffset = layerzone.getShort(3);
                endAddrsOffset += layerzone.getShort(12) * 32768;
                startloopAddrsOffset += layerzone.getShort(45) * 32768;
                endloopAddrsOffset += layerzone.getShort(50) * 32768;
                startloopAddrsOffset -= (startAddrsOffset += layerzone.getShort(4) * 32768);
                endloopAddrsOffset -= startAddrsOffset;
                SF2Sample sample = layerzone.getSample();
                int rootkey = sample.originalPitch;
                if (layerzone.getShort(58) != -1) {
                    rootkey = layerzone.getShort(58);
                }
                float pitchcorrection = -rootkey * 100 + sample.pitchCorrection;
                ModelByteBuffer buff = sample.getDataBuffer();
                ModelByteBuffer buff24 = sample.getData24Buffer();
                if (startAddrsOffset != 0 || endAddrsOffset != 0) {
                    buff = buff.subbuffer(startAddrsOffset * 2, buff.capacity() + (long)(endAddrsOffset * 2));
                    if (buff24 != null) {
                        buff24 = buff24.subbuffer(startAddrsOffset, buff24.capacity() + (long)endAddrsOffset);
                    }
                }
                ModelByteBufferWavetable osc = new ModelByteBufferWavetable(buff, sample.getFormat(), pitchcorrection);
                if (buff24 != null) {
                    osc.set8BitExtensionBuffer(buff24);
                }
                HashMap<Integer, Short> generators = new HashMap<Integer, Short>();
                if (layerglobal != null) {
                    generators.putAll(layerglobal.getGenerators());
                }
                generators.putAll(layerzone.getGenerators());
                for (Map.Entry gen : pgenerators.entrySet()) {
                    short val = !generators.containsKey(gen.getKey()) ? layerzone.getShort((Integer)gen.getKey()) : ((Short)generators.get(gen.getKey())).shortValue();
                    val = (short)(val + (Short)gen.getValue());
                    generators.put((Integer)gen.getKey(), val);
                }
                short sampleMode = this.getGeneratorValue(generators, 54);
                if ((sampleMode == 1 || sampleMode == 3) && sample.startLoop >= 0L && sample.endLoop > 0L) {
                    osc.setLoopStart((int)(sample.startLoop + (long)startloopAddrsOffset));
                    osc.setLoopLength((int)(sample.endLoop - sample.startLoop + (long)endloopAddrsOffset - (long)startloopAddrsOffset));
                    if (sampleMode == 1) {
                        osc.setLoopType(1);
                    }
                    if (sampleMode == 3) {
                        osc.setLoopType(2);
                    }
                }
                performer.getOscillators().add(osc);
                short volDelay = this.getGeneratorValue(generators, 33);
                short volAttack = this.getGeneratorValue(generators, 34);
                short volHold = this.getGeneratorValue(generators, 35);
                short volDecay = this.getGeneratorValue(generators, 36);
                short volSustain = this.getGeneratorValue(generators, 37);
                short volRelease = this.getGeneratorValue(generators, 38);
                if (volHold != -12000) {
                    short volKeyNumToHold = this.getGeneratorValue(generators, 39);
                    volHold = (short)(volHold + 60 * volKeyNumToHold);
                    fvalue = -volKeyNumToHold * 128;
                    src = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                    dest = ModelDestination.DESTINATION_EG1_HOLD;
                    performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src), fvalue, new ModelDestination(dest)));
                }
                if (volDecay != -12000) {
                    short volKeyNumToDecay = this.getGeneratorValue(generators, 40);
                    volDecay = (short)(volDecay + 60 * volKeyNumToDecay);
                    fvalue = -volKeyNumToDecay * 128;
                    src = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                    dest = ModelDestination.DESTINATION_EG1_DECAY;
                    performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src), fvalue, new ModelDestination(dest)));
                }
                this.addTimecentValue(performer, ModelDestination.DESTINATION_EG1_DELAY, volDelay);
                this.addTimecentValue(performer, ModelDestination.DESTINATION_EG1_ATTACK, volAttack);
                this.addTimecentValue(performer, ModelDestination.DESTINATION_EG1_HOLD, volHold);
                this.addTimecentValue(performer, ModelDestination.DESTINATION_EG1_DECAY, volDecay);
                volSustain = (short)(1000 - volSustain);
                if (volSustain < 0) {
                    volSustain = 0;
                }
                if (volSustain > 1000) {
                    volSustain = 1000;
                }
                this.addValue(performer, ModelDestination.DESTINATION_EG1_SUSTAIN, volSustain);
                this.addTimecentValue(performer, ModelDestination.DESTINATION_EG1_RELEASE, volRelease);
                if (this.getGeneratorValue(generators, 11) != 0 || this.getGeneratorValue(generators, 7) != 0) {
                    ModelIdentifier dest2;
                    ModelIdentifier src2;
                    float fvalue2;
                    short modDelay = this.getGeneratorValue(generators, 25);
                    short modAttack = this.getGeneratorValue(generators, 26);
                    short modHold = this.getGeneratorValue(generators, 27);
                    short modDecay = this.getGeneratorValue(generators, 28);
                    int modSustain = this.getGeneratorValue(generators, 29);
                    short modRelease = this.getGeneratorValue(generators, 30);
                    if (modHold != -12000) {
                        short modKeyNumToHold = this.getGeneratorValue(generators, 31);
                        modHold = (short)(modHold + 60 * modKeyNumToHold);
                        fvalue2 = -modKeyNumToHold * 128;
                        src2 = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                        dest2 = ModelDestination.DESTINATION_EG2_HOLD;
                        performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src2), fvalue2, new ModelDestination(dest2)));
                    }
                    if (modDecay != -12000) {
                        short modKeyNumToDecay = this.getGeneratorValue(generators, 32);
                        modDecay = (short)(modDecay + 60 * modKeyNumToDecay);
                        fvalue2 = -modKeyNumToDecay * 128;
                        src2 = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                        dest2 = ModelDestination.DESTINATION_EG2_DECAY;
                        performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src2), fvalue2, new ModelDestination(dest2)));
                    }
                    this.addTimecentValue(performer, ModelDestination.DESTINATION_EG2_DELAY, modDelay);
                    this.addTimecentValue(performer, ModelDestination.DESTINATION_EG2_ATTACK, modAttack);
                    this.addTimecentValue(performer, ModelDestination.DESTINATION_EG2_HOLD, modHold);
                    this.addTimecentValue(performer, ModelDestination.DESTINATION_EG2_DECAY, modDecay);
                    if (modSustain < 0) {
                        modSustain = 0;
                    }
                    if (modSustain > 1000) {
                        modSustain = 1000;
                    }
                    this.addValue(performer, ModelDestination.DESTINATION_EG2_SUSTAIN, 1000 - modSustain);
                    this.addTimecentValue(performer, ModelDestination.DESTINATION_EG2_RELEASE, modRelease);
                    if (this.getGeneratorValue(generators, 11) != 0) {
                        double fvalue3 = this.getGeneratorValue(generators, 11);
                        src2 = ModelSource.SOURCE_EG2;
                        dest2 = ModelDestination.DESTINATION_FILTER_FREQ;
                        performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src2), fvalue3, new ModelDestination(dest2)));
                    }
                    if (this.getGeneratorValue(generators, 7) != 0) {
                        double fvalue4 = this.getGeneratorValue(generators, 7);
                        src2 = ModelSource.SOURCE_EG2;
                        dest2 = ModelDestination.DESTINATION_PITCH;
                        performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src2), fvalue4, new ModelDestination(dest2)));
                    }
                }
                if (this.getGeneratorValue(generators, 10) != 0 || this.getGeneratorValue(generators, 5) != 0 || this.getGeneratorValue(generators, 13) != 0) {
                    short lfo_freq = this.getGeneratorValue(generators, 22);
                    short lfo_delay = this.getGeneratorValue(generators, 21);
                    this.addTimecentValue(performer, ModelDestination.DESTINATION_LFO1_DELAY, lfo_delay);
                    this.addValue(performer, ModelDestination.DESTINATION_LFO1_FREQ, lfo_freq);
                }
                short vib_freq = this.getGeneratorValue(generators, 24);
                short vib_delay = this.getGeneratorValue(generators, 23);
                this.addTimecentValue(performer, ModelDestination.DESTINATION_LFO2_DELAY, vib_delay);
                this.addValue(performer, ModelDestination.DESTINATION_LFO2_FREQ, vib_freq);
                if (this.getGeneratorValue(generators, 6) != 0) {
                    double fvalue5 = this.getGeneratorValue(generators, 6);
                    ModelIdentifier src3 = ModelSource.SOURCE_LFO2;
                    ModelIdentifier dest3 = ModelDestination.DESTINATION_PITCH;
                    performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src3, false, true), fvalue5, new ModelDestination(dest3)));
                }
                if (this.getGeneratorValue(generators, 10) != 0) {
                    double fvalue6 = this.getGeneratorValue(generators, 10);
                    ModelIdentifier src4 = ModelSource.SOURCE_LFO1;
                    ModelIdentifier dest4 = ModelDestination.DESTINATION_FILTER_FREQ;
                    performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src4, false, true), fvalue6, new ModelDestination(dest4)));
                }
                if (this.getGeneratorValue(generators, 5) != 0) {
                    double fvalue7 = this.getGeneratorValue(generators, 5);
                    ModelIdentifier src5 = ModelSource.SOURCE_LFO1;
                    ModelIdentifier dest5 = ModelDestination.DESTINATION_PITCH;
                    performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src5, false, true), fvalue7, new ModelDestination(dest5)));
                }
                if (this.getGeneratorValue(generators, 13) != 0) {
                    double fvalue8 = this.getGeneratorValue(generators, 13);
                    ModelIdentifier src6 = ModelSource.SOURCE_LFO1;
                    ModelIdentifier dest6 = ModelDestination.DESTINATION_GAIN;
                    performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src6, false, true), fvalue8, new ModelDestination(dest6)));
                }
                if (layerzone.getShort(46) != -1) {
                    double val = (double)layerzone.getShort(46) / 128.0;
                    this.addValue(performer, ModelDestination.DESTINATION_KEYNUMBER, val);
                }
                if (layerzone.getShort(47) != -1) {
                    double val = (double)layerzone.getShort(47) / 128.0;
                    this.addValue(performer, ModelDestination.DESTINATION_VELOCITY, val);
                }
                if (this.getGeneratorValue(generators, 8) < 13500) {
                    short filter_freq = this.getGeneratorValue(generators, 8);
                    short filter_q = this.getGeneratorValue(generators, 9);
                    this.addValue(performer, ModelDestination.DESTINATION_FILTER_FREQ, filter_freq);
                    this.addValue(performer, ModelDestination.DESTINATION_FILTER_Q, filter_q);
                }
                int tune = 100 * this.getGeneratorValue(generators, 51);
                if ((tune += this.getGeneratorValue(generators, 52)) != 0) {
                    this.addValue(performer, ModelDestination.DESTINATION_PITCH, (short)tune);
                }
                if (this.getGeneratorValue(generators, 17) != 0) {
                    short val = this.getGeneratorValue(generators, 17);
                    this.addValue(performer, ModelDestination.DESTINATION_PAN, val);
                }
                if (this.getGeneratorValue(generators, 48) != 0) {
                    short val = this.getGeneratorValue(generators, 48);
                    this.addValue(performer, ModelDestination.DESTINATION_GAIN, -0.376287f * (float)val);
                }
                if (this.getGeneratorValue(generators, 15) != 0) {
                    short val = this.getGeneratorValue(generators, 15);
                    this.addValue(performer, ModelDestination.DESTINATION_CHORUS, val);
                }
                if (this.getGeneratorValue(generators, 16) != 0) {
                    short val = this.getGeneratorValue(generators, 16);
                    this.addValue(performer, ModelDestination.DESTINATION_REVERB, val);
                }
                if (this.getGeneratorValue(generators, 56) != 100) {
                    short fvalue9 = this.getGeneratorValue(generators, 56);
                    if (fvalue9 == 0) {
                        dest = ModelDestination.DESTINATION_PITCH;
                        performer.getConnectionBlocks().add(new ModelConnectionBlock(null, rootkey * 100, new ModelDestination(dest)));
                    } else {
                        dest = ModelDestination.DESTINATION_PITCH;
                        performer.getConnectionBlocks().add(new ModelConnectionBlock(null, rootkey * (100 - fvalue9), new ModelDestination(dest)));
                    }
                    ModelIdentifier src7 = ModelSource.SOURCE_NOTEON_KEYNUMBER;
                    ModelIdentifier dest7 = ModelDestination.DESTINATION_PITCH;
                    performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(src7), 128 * fvalue9, new ModelDestination(dest7)));
                }
                performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_NOTEON_VELOCITY, new ModelTransform(){

                    @Override
                    public double transform(double value) {
                        if (value < 0.5) {
                            return 1.0 - value * 2.0;
                        }
                        return 0.0;
                    }
                }), -2400.0, new ModelDestination(ModelDestination.DESTINATION_FILTER_FREQ)));
                performer.getConnectionBlocks().add(new ModelConnectionBlock(new ModelSource(ModelSource.SOURCE_LFO2, false, true, 0), new ModelSource(new ModelIdentifier("midi_cc", "1", 0), false, false, 0), 50.0, new ModelDestination(ModelDestination.DESTINATION_PITCH)));
                if (layer.getGlobalRegion() != null) {
                    for (SF2Modulator modulator : layer.getGlobalRegion().getModulators()) {
                        this.convertModulator(performer, modulator);
                    }
                }
                for (SF2Modulator modulator : layerzone.getModulators()) {
                    this.convertModulator(performer, modulator);
                }
                if (presetglobal != null) {
                    for (SF2Modulator modulator : presetglobal.getModulators()) {
                        this.convertModulator(performer, modulator);
                    }
                }
                for (SF2Modulator modulator : presetzone.getModulators()) {
                    this.convertModulator(performer, modulator);
                }
            }
        }
        return performers;
    }

    private void convertModulator(ModelPerformer performer, SF2Modulator modulator) {
        ModelSource src1 = SF2Instrument.convertSource(modulator.getSourceOperator());
        ModelSource src2 = SF2Instrument.convertSource(modulator.getAmountSourceOperator());
        if (src1 == null && modulator.getSourceOperator() != 0) {
            return;
        }
        if (src2 == null && modulator.getAmountSourceOperator() != 0) {
            return;
        }
        double amount = modulator.getAmount();
        double[] amountcorrection = new double[1];
        ModelSource[] extrasrc = new ModelSource[1];
        amountcorrection[0] = 1.0;
        ModelDestination dst = SF2Instrument.convertDestination(modulator.getDestinationOperator(), amountcorrection, extrasrc);
        amount *= amountcorrection[0];
        if (dst == null) {
            return;
        }
        if (modulator.getTransportOperator() == 2) {
            ((ModelStandardTransform)dst.getTransform()).setTransform(4);
        }
        ModelConnectionBlock conn = new ModelConnectionBlock(src1, src2, amount, dst);
        if (extrasrc[0] != null) {
            conn.addSource(extrasrc[0]);
        }
        performer.getConnectionBlocks().add(conn);
    }

    private static ModelSource convertSource(int src) {
        if (src == 0) {
            return null;
        }
        ModelIdentifier id = null;
        int idsrc = src & 0x7F;
        if ((src & 0x80) != 0) {
            id = new ModelIdentifier("midi_cc", Integer.toString(idsrc));
        } else {
            if (idsrc == 2) {
                id = ModelSource.SOURCE_NOTEON_VELOCITY;
            }
            if (idsrc == 3) {
                id = ModelSource.SOURCE_NOTEON_KEYNUMBER;
            }
            if (idsrc == 10) {
                id = ModelSource.SOURCE_MIDI_POLY_PRESSURE;
            }
            if (idsrc == 13) {
                id = ModelSource.SOURCE_MIDI_CHANNEL_PRESSURE;
            }
            if (idsrc == 14) {
                id = ModelSource.SOURCE_MIDI_PITCH;
            }
            if (idsrc == 16) {
                id = new ModelIdentifier("midi_rpn", "0");
            }
        }
        if (id == null) {
            return null;
        }
        ModelSource msrc = new ModelSource(id);
        ModelStandardTransform transform = (ModelStandardTransform)msrc.getTransform();
        if ((0x100 & src) != 0) {
            transform.setDirection(true);
        } else {
            transform.setDirection(false);
        }
        if ((0x200 & src) != 0) {
            transform.setPolarity(true);
        } else {
            transform.setPolarity(false);
        }
        if ((0x400 & src) != 0) {
            transform.setTransform(1);
        }
        if ((0x800 & src) != 0) {
            transform.setTransform(2);
        }
        if ((0xC00 & src) != 0) {
            transform.setTransform(3);
        }
        return msrc;
    }

    protected static ModelDestination convertDestination(int dst, double[] amountcorrection, ModelSource[] extrasrc) {
        ModelIdentifier id = null;
        switch (dst) {
            case 8: {
                id = ModelDestination.DESTINATION_FILTER_FREQ;
                break;
            }
            case 9: {
                id = ModelDestination.DESTINATION_FILTER_Q;
                break;
            }
            case 15: {
                id = ModelDestination.DESTINATION_CHORUS;
                break;
            }
            case 16: {
                id = ModelDestination.DESTINATION_REVERB;
                break;
            }
            case 17: {
                id = ModelDestination.DESTINATION_PAN;
                break;
            }
            case 21: {
                id = ModelDestination.DESTINATION_LFO1_DELAY;
                break;
            }
            case 22: {
                id = ModelDestination.DESTINATION_LFO1_FREQ;
                break;
            }
            case 23: {
                id = ModelDestination.DESTINATION_LFO2_DELAY;
                break;
            }
            case 24: {
                id = ModelDestination.DESTINATION_LFO2_FREQ;
                break;
            }
            case 25: {
                id = ModelDestination.DESTINATION_EG2_DELAY;
                break;
            }
            case 26: {
                id = ModelDestination.DESTINATION_EG2_ATTACK;
                break;
            }
            case 27: {
                id = ModelDestination.DESTINATION_EG2_HOLD;
                break;
            }
            case 28: {
                id = ModelDestination.DESTINATION_EG2_DECAY;
                break;
            }
            case 29: {
                id = ModelDestination.DESTINATION_EG2_SUSTAIN;
                amountcorrection[0] = -1.0;
                break;
            }
            case 30: {
                id = ModelDestination.DESTINATION_EG2_RELEASE;
                break;
            }
            case 33: {
                id = ModelDestination.DESTINATION_EG1_DELAY;
                break;
            }
            case 34: {
                id = ModelDestination.DESTINATION_EG1_ATTACK;
                break;
            }
            case 35: {
                id = ModelDestination.DESTINATION_EG1_HOLD;
                break;
            }
            case 36: {
                id = ModelDestination.DESTINATION_EG1_DECAY;
                break;
            }
            case 37: {
                id = ModelDestination.DESTINATION_EG1_SUSTAIN;
                amountcorrection[0] = -1.0;
                break;
            }
            case 38: {
                id = ModelDestination.DESTINATION_EG1_RELEASE;
                break;
            }
            case 46: {
                id = ModelDestination.DESTINATION_KEYNUMBER;
                break;
            }
            case 47: {
                id = ModelDestination.DESTINATION_VELOCITY;
                break;
            }
            case 51: {
                amountcorrection[0] = 100.0;
                id = ModelDestination.DESTINATION_PITCH;
                break;
            }
            case 52: {
                id = ModelDestination.DESTINATION_PITCH;
                break;
            }
            case 48: {
                id = ModelDestination.DESTINATION_GAIN;
                amountcorrection[0] = -0.376287f;
                break;
            }
            case 6: {
                id = ModelDestination.DESTINATION_PITCH;
                extrasrc[0] = new ModelSource(ModelSource.SOURCE_LFO2, false, true);
                break;
            }
            case 5: {
                id = ModelDestination.DESTINATION_PITCH;
                extrasrc[0] = new ModelSource(ModelSource.SOURCE_LFO1, false, true);
                break;
            }
            case 10: {
                id = ModelDestination.DESTINATION_FILTER_FREQ;
                extrasrc[0] = new ModelSource(ModelSource.SOURCE_LFO1, false, true);
                break;
            }
            case 13: {
                id = ModelDestination.DESTINATION_GAIN;
                amountcorrection[0] = -0.376287f;
                extrasrc[0] = new ModelSource(ModelSource.SOURCE_LFO1, false, true);
                break;
            }
            case 7: {
                id = ModelDestination.DESTINATION_PITCH;
                extrasrc[0] = new ModelSource(ModelSource.SOURCE_EG2, false, true);
                break;
            }
            case 11: {
                id = ModelDestination.DESTINATION_FILTER_FREQ;
                extrasrc[0] = new ModelSource(ModelSource.SOURCE_EG2, false, true);
                break;
            }
        }
        if (id != null) {
            return new ModelDestination(id);
        }
        return null;
    }

    private void addTimecentValue(ModelPerformer performer, ModelIdentifier dest, short value) {
        double fvalue = value == -12000 ? Double.NEGATIVE_INFINITY : (double)value;
        performer.getConnectionBlocks().add(new ModelConnectionBlock(fvalue, new ModelDestination(dest)));
    }

    private void addValue(ModelPerformer performer, ModelIdentifier dest, short value) {
        double fvalue = value;
        performer.getConnectionBlocks().add(new ModelConnectionBlock(fvalue, new ModelDestination(dest)));
    }

    private void addValue(ModelPerformer performer, ModelIdentifier dest, double value) {
        double fvalue = value;
        performer.getConnectionBlocks().add(new ModelConnectionBlock(fvalue, new ModelDestination(dest)));
    }

    private short getGeneratorValue(Map<Integer, Short> generators, int gen) {
        if (generators.containsKey(gen)) {
            return generators.get(gen);
        }
        return SF2Region.getDefaultValue(gen);
    }
}

