/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.com.sun.media.sound;

import cn.sherlock.javax.sound.sampled.AudioFormat;
import cn.sherlock.javax.sound.sampled.AudioInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class SoftJitterCorrector
extends AudioInputStream {
    public SoftJitterCorrector(AudioInputStream stream, int buffersize, int smallbuffersize) {
        super(new JitterStream(stream, buffersize, smallbuffersize), stream.getFormat(), stream.getFrameLength());
    }

    private static class JitterStream
    extends InputStream {
        static int MAX_BUFFER_SIZE = 0x100000;
        boolean active = true;
        Thread thread;
        AudioInputStream stream;
        int writepos = 0;
        int readpos = 0;
        byte[][] buffers;
        Object buffers_mutex = new Object();
        int w_count = 1000;
        int w_min_tol = 2;
        int w_max_tol = 10;
        int w = 0;
        int w_min = -1;
        int bbuffer_pos = 0;
        int bbuffer_max = 0;
        byte[] bbuffer = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] nextReadBuffer() {
            Object object = this.buffers_mutex;
            synchronized (object) {
                if (this.writepos > this.readpos) {
                    int w_m = this.writepos - this.readpos;
                    if (w_m < this.w_min) {
                        this.w_min = w_m;
                    }
                    int buffpos = this.readpos++;
                    return this.buffers[buffpos % this.buffers.length];
                }
                this.w_min = -1;
                this.w = this.w_count - 1;
            }
            while (true) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    return null;
                }
                object = this.buffers_mutex;
                synchronized (object) {
                    if (this.writepos > this.readpos) {
                        this.w = 0;
                        this.w_min = -1;
                        this.w = this.w_count - 1;
                        int buffpos = this.readpos++;
                        return this.buffers[buffpos % this.buffers.length];
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] nextWriteBuffer() {
            Object object = this.buffers_mutex;
            synchronized (object) {
                return this.buffers[this.writepos % this.buffers.length];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit() {
            Object object = this.buffers_mutex;
            synchronized (object) {
                ++this.writepos;
                if (this.writepos - this.readpos > this.buffers.length) {
                    int newsize = this.writepos - this.readpos + 10;
                    newsize = Math.max(this.buffers.length * 2, newsize);
                    this.buffers = new byte[newsize][this.buffers[0].length];
                }
            }
        }

        public JitterStream(AudioInputStream s, int buffersize, int smallbuffersize) {
            this.w_count = 10 * (buffersize / smallbuffersize);
            if (this.w_count < 100) {
                this.w_count = 100;
            }
            this.buffers = new byte[buffersize / smallbuffersize + 10][smallbuffersize];
            this.bbuffer_max = MAX_BUFFER_SIZE / smallbuffersize;
            this.stream = s;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    AudioFormat format = stream.getFormat();
                    int bufflen = buffers[0].length;
                    int frames = bufflen / format.getFrameSize();
                    long nanos = (long)((double)frames * 1.0E9 / (double)format.getSampleRate());
                    long now = System.nanoTime();
                    long next = now + nanos;
                    int correction = 0;
                    while (true) {
                        JitterStream jitterStream = this;
                        // MONITORENTER : jitterStream
                        if (!active) {
                            // MONITOREXIT : jitterStream
                            return;
                        }
                        // MONITOREXIT : jitterStream
                        Object object = buffers;
                        // MONITORENTER : buffers
                        int curbuffsize = writepos - readpos;
                        if (correction == 0) {
                            ++w;
                            if (w_min != Integer.MAX_VALUE && w == w_count) {
                                correction = 0;
                                if (w_min < w_min_tol) {
                                    correction = (w_min_tol + w_max_tol) / 2 - w_min;
                                }
                                if (w_min > w_max_tol) {
                                    correction = (w_min_tol + w_max_tol) / 2 - w_min;
                                }
                                w = 0;
                                w_min = Integer.MAX_VALUE;
                            }
                        }
                        // MONITOREXIT : object
                        while (curbuffsize > bbuffer_max) {
                            object = buffers;
                            // MONITORENTER : buffers
                            curbuffsize = writepos - readpos;
                            // MONITOREXIT : object
                            JitterStream jitterStream2 = this;
                            object = jitterStream2;
                            // MONITORENTER : jitterStream2
                            if (!active) {
                                // MONITOREXIT : object
                                break;
                            }
                            // MONITOREXIT : object
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (correction < 0) {
                            ++correction;
                        } else {
                            byte[] buff = this.nextWriteBuffer();
                            try {
                                int s;
                                for (int n = 0; n != buff.length; n += s) {
                                    s = stream.read(buff, n, buff.length - n);
                                    if (s < 0) {
                                        throw new EOFException();
                                    }
                                    if (s != 0) continue;
                                    Thread.yield();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.commit();
                        }
                        if (correction > 0) {
                            --correction;
                            next = System.nanoTime() + nanos;
                            continue;
                        }
                        long wait = next - System.nanoTime();
                        if (wait > 0L) {
                            try {
                                Thread.sleep(wait / 1000000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        next += nanos;
                    }
                }
            };
            this.thread = new Thread(runnable);
            this.thread.setDaemon(true);
            this.thread.setPriority(10);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            JitterStream jitterStream = this;
            synchronized (jitterStream) {
                this.active = false;
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stream.close();
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b) == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        public void fillBuffer() {
            this.bbuffer = this.nextReadBuffer();
            this.bbuffer_pos = 0;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (this.bbuffer == null) {
                this.fillBuffer();
            }
            int bbuffer_len = this.bbuffer.length;
            int offlen = off + len;
            while (off < offlen) {
                if (this.available() == 0) {
                    this.fillBuffer();
                    continue;
                }
                byte[] bbuffer = this.bbuffer;
                int bbuffer_pos = this.bbuffer_pos;
                while (off < offlen && bbuffer_pos < bbuffer_len) {
                    b[off++] = bbuffer[bbuffer_pos++];
                }
                this.bbuffer_pos = bbuffer_pos;
            }
            return len;
        }

        @Override
        public int available() {
            return this.bbuffer.length - this.bbuffer_pos;
        }
    }
}

