/*
 * Decompiled with CFR 0.152.
 */
package cn.sherlock.javax.sound.sampled;

import cn.sherlock.javax.sound.sampled.AudioFormat;
import java.io.IOException;
import java.io.InputStream;

public class AudioInputStream
extends InputStream {
    private InputStream stream;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    protected long framePos;
    private long markpos;
    private byte[] pushBackBuffer = null;
    private int pushBackLen = 0;
    private byte[] markPushBackBuffer = null;
    private int markPushBackLen = 0;

    public AudioInputStream(InputStream stream, AudioFormat format, long length) {
        this.format = format;
        this.frameLength = length;
        this.frameSize = format.getFrameSize();
        if (this.frameSize == -1 || this.frameSize <= 0) {
            this.frameSize = 1;
        }
        this.stream = stream;
        this.framePos = 0L;
        this.markpos = 0L;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    @Override
    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("cannot read a single byte if frame size > 1");
        }
        byte[] data = new byte[1];
        int temp = this.read(data);
        if (temp <= 0) {
            return -1;
        }
        return data[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int thisBytesRead;
        if (len % this.frameSize != 0 && (len -= len % this.frameSize) == 0) {
            return 0;
        }
        if (this.frameLength != -1L) {
            if (this.framePos >= this.frameLength) {
                return -1;
            }
            if ((long)(len / this.frameSize) > this.frameLength - this.framePos) {
                len = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
        }
        int bytesRead = 0;
        int thisOff = off;
        if (this.pushBackLen > 0 && len >= this.pushBackLen) {
            System.arraycopy(this.pushBackBuffer, 0, b, off, this.pushBackLen);
            thisOff += this.pushBackLen;
            len -= this.pushBackLen;
            bytesRead += this.pushBackLen;
            this.pushBackLen = 0;
        }
        if ((thisBytesRead = this.stream.read(b, thisOff, len)) == -1) {
            return -1;
        }
        if (thisBytesRead > 0) {
            bytesRead += thisBytesRead;
        }
        if (bytesRead > 0) {
            this.pushBackLen = bytesRead % this.frameSize;
            if (this.pushBackLen > 0) {
                if (this.pushBackBuffer == null) {
                    this.pushBackBuffer = new byte[this.frameSize];
                }
                System.arraycopy(b, off + bytesRead - this.pushBackLen, this.pushBackBuffer, 0, this.pushBackLen);
                bytesRead -= this.pushBackLen;
            }
            this.framePos += (long)(bytesRead / this.frameSize);
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long temp;
        if (n % (long)this.frameSize != 0L) {
            n -= n % (long)this.frameSize;
        }
        if (this.frameLength != -1L && n / (long)this.frameSize > this.frameLength - this.framePos) {
            n = (this.frameLength - this.framePos) * (long)this.frameSize;
        }
        if ((temp = this.stream.skip(n)) % (long)this.frameSize != 0L) {
            throw new IOException("Could not skip an integer number of frames.");
        }
        if (temp >= 0L) {
            this.framePos += temp / (long)this.frameSize;
        }
        return temp;
    }

    @Override
    public int available() throws IOException {
        int temp = this.stream.available();
        if (this.frameLength != -1L && (long)(temp / this.frameSize) > this.frameLength - this.framePos) {
            return (int)(this.frameLength - this.framePos) * this.frameSize;
        }
        return temp;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.stream.mark(readlimit);
        if (this.markSupported()) {
            this.markpos = this.framePos;
            this.markPushBackLen = this.pushBackLen;
            if (this.markPushBackLen > 0) {
                if (this.markPushBackBuffer == null) {
                    this.markPushBackBuffer = new byte[this.frameSize];
                }
                System.arraycopy(this.pushBackBuffer, 0, this.markPushBackBuffer, 0, this.markPushBackLen);
            }
        }
    }

    @Override
    public void reset() throws IOException {
        this.stream.reset();
        this.framePos = this.markpos;
        this.pushBackLen = this.markPushBackLen;
        if (this.pushBackLen > 0) {
            if (this.pushBackBuffer == null) {
                this.pushBackBuffer = new byte[this.frameSize - 1];
            }
            System.arraycopy(this.markPushBackBuffer, 0, this.pushBackBuffer, 0, this.pushBackLen);
        }
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }
}

