/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MidiFileFormat {
    public static final int HEADER_MThd = 1297377380;
    public static final int HEADER_MTrk = 1297379947;
    public static final int UNKNOWN_LENGTH = -1;
    protected int byteLength;
    protected float divisionType;
    protected long microsecondLength;
    protected int resolution;
    protected int type;
    private final AbstractMap<String, Object> properties;

    public MidiFileFormat(int type, float divisionType, int resolution, int bytes, long microseconds) {
        this.type = type;
        this.divisionType = divisionType;
        this.resolution = resolution;
        this.byteLength = bytes;
        this.microsecondLength = microseconds;
        this.properties = new HashMap<String, Object>();
    }

    public MidiFileFormat(int type, float divisionType, int resolution, int bytes, long microseconds, @NonNull Map<String, Object> properties) {
        this(type, divisionType, resolution, bytes, microseconds);
        this.properties.putAll(properties);
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    @Nullable
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getType() {
        return this.type;
    }

    @NonNull
    public Map<String, Object> properties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

