/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;

public abstract class MidiMessage
implements Cloneable {
    @Nullable
    protected byte[] data;
    protected int length;

    protected MidiMessage(@Nullable byte[] data) {
        this.data = data;
        this.length = data == null ? 0 : data.length;
    }

    public void setMessage(@Nullable byte[] data, int length) throws InvalidMidiDataException {
        if (data == null) {
            this.data = null;
            this.length = 0;
        } else {
            if (this.data == null || this.data.length != data.length) {
                this.data = new byte[data.length];
            }
            this.length = data.length;
            System.arraycopy(data, 0, this.data, 0, data.length);
        }
    }

    @Nullable
    public byte[] getMessage() {
        if (this.data == null) {
            return null;
        }
        byte[] resultArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, resultArray, 0, this.data.length);
        return resultArray;
    }

    public int getStatus() {
        if (this.data == null || this.data.length < 1) {
            return 0;
        }
        return this.data[0] & 0xFF;
    }

    public int getLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @NonNull
    static String toHexString(@Nullable byte[] src) {
        if (src == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean needComma = false;
        for (byte srcByte : src) {
            if (needComma) {
                buffer.append(", ");
            }
            buffer.append(String.format("%02x", srcByte & 0xFF));
            needComma = true;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + ":" + MidiMessage.toHexString(this.data);
    }

    public abstract Object clone();
}

