/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MidiDevice;
import jp.kshoji.javax.sound.midi.MidiFileFormat;
import jp.kshoji.javax.sound.midi.MidiUnavailableException;
import jp.kshoji.javax.sound.midi.Receiver;
import jp.kshoji.javax.sound.midi.Sequence;
import jp.kshoji.javax.sound.midi.Sequencer;
import jp.kshoji.javax.sound.midi.Soundbank;
import jp.kshoji.javax.sound.midi.Synthesizer;
import jp.kshoji.javax.sound.midi.Transmitter;
import jp.kshoji.javax.sound.midi.impl.SequencerImpl;
import jp.kshoji.javax.sound.midi.io.StandardMidiFileReader;
import jp.kshoji.javax.sound.midi.io.StandardMidiFileWriter;

public final class MidiSystem {
    private static final Collection<MidiDevice> midiDevices = new HashSet<MidiDevice>();
    private static final Collection<Synthesizer> synthesizers = new HashSet<Synthesizer>();
    private static final StandardMidiFileReader standardMidiFileReader = new StandardMidiFileReader();
    private static final StandardMidiFileWriter standardMidiFileWriter = new StandardMidiFileWriter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMidiDevice(@NonNull MidiDevice midiDevice) {
        Collection<MidiDevice> collection = midiDevices;
        synchronized (collection) {
            midiDevices.add(midiDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMidiDevice(@NonNull MidiDevice midiDevice) {
        Collection<MidiDevice> collection = midiDevices;
        synchronized (collection) {
            midiDevices.remove(midiDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSynthesizer(@NonNull Synthesizer synthesizer) {
        Collection<Synthesizer> collection = synthesizers;
        synchronized (collection) {
            synthesizers.add(synthesizer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSynthesizer(@NonNull Synthesizer synthesizer) {
        Collection<Synthesizer> collection = synthesizers;
        synchronized (collection) {
            synthesizers.remove(synthesizer);
        }
    }

    private MidiSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MidiDevice.Info[] getMidiDeviceInfo() {
        ArrayList<MidiDevice.Info> result = new ArrayList<MidiDevice.Info>();
        Collection<MidiDevice> collection = midiDevices;
        synchronized (collection) {
            for (MidiDevice device : midiDevices) {
                MidiDevice.Info deviceInfo = device.getDeviceInfo();
                if (deviceInfo == null) continue;
                result.add(deviceInfo);
            }
        }
        return result.toArray(new MidiDevice.Info[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MidiDevice getMidiDevice(@NonNull MidiDevice.Info info) throws MidiUnavailableException, IllegalArgumentException {
        if (midiDevices.isEmpty()) {
            throw new MidiUnavailableException("MidiDevice not found");
        }
        Collection<MidiDevice> collection = midiDevices;
        synchronized (collection) {
            for (MidiDevice midiDevice : midiDevices) {
                if (!info.equals(midiDevice.getDeviceInfo())) continue;
                return midiDevice;
            }
        }
        throw new IllegalArgumentException("Requested device not installed: " + info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Receiver getReceiver() throws MidiUnavailableException {
        Collection<MidiDevice> collection = midiDevices;
        synchronized (collection) {
            for (MidiDevice midiDevice : midiDevices) {
                Receiver receiver = midiDevice.getReceiver();
                if (receiver == null) continue;
                return receiver;
            }
        }
        throw new MidiUnavailableException("Receiver not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Transmitter getTransmitter() throws MidiUnavailableException {
        Collection<MidiDevice> collection = midiDevices;
        synchronized (collection) {
            for (MidiDevice midiDevice : midiDevices) {
                Transmitter transmitter = midiDevice.getTransmitter();
                if (transmitter == null) continue;
                return transmitter;
            }
        }
        throw new MidiUnavailableException("Transmitter not found");
    }

    @NonNull
    public static Sequence getSequence(@NonNull File file) throws InvalidMidiDataException, IOException {
        return standardMidiFileReader.getSequence(file);
    }

    @NonNull
    public static Sequence getSequence(@NonNull InputStream stream) throws InvalidMidiDataException, IOException {
        return standardMidiFileReader.getSequence(stream);
    }

    @NonNull
    public static Sequence getSequence(@NonNull URL url) throws InvalidMidiDataException, IOException {
        return standardMidiFileReader.getSequence(url);
    }

    @NonNull
    public static Sequencer getSequencer() throws MidiUnavailableException {
        return new SequencerImpl();
    }

    @NonNull
    public static Sequencer getSequencer(boolean connected) throws MidiUnavailableException {
        return new SequencerImpl();
    }

    @NonNull
    public static Soundbank getSoundbank(@NonNull File file) throws InvalidMidiDataException, IOException {
        throw new UnsupportedOperationException("not implemented.");
    }

    @NonNull
    public static Soundbank getSoundbank(@NonNull InputStream stream) throws InvalidMidiDataException, IOException {
        throw new UnsupportedOperationException("not implemented.");
    }

    @NonNull
    public static Soundbank getSoundbank(@NonNull URL url) throws InvalidMidiDataException, IOException {
        throw new UnsupportedOperationException("not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        Collection<Synthesizer> collection = synthesizers;
        synchronized (collection) {
            Iterator<Synthesizer> iterator = synthesizers.iterator();
            if (iterator.hasNext()) {
                Synthesizer synthesizer = iterator.next();
                return synthesizer;
            }
        }
        throw new MidiUnavailableException("Synthesizer not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSynthesizer(@NonNull Synthesizer synthesizer) {
        Collection<Synthesizer> collection = synthesizers;
        synchronized (collection) {
            synthesizers.add(synthesizer);
        }
    }

    @NonNull
    public static MidiFileFormat getMidiFileFormat(@NonNull File file) throws InvalidMidiDataException, IOException {
        return standardMidiFileReader.getMidiFileFormat(file);
    }

    @NonNull
    public static MidiFileFormat getMidiFileFormat(@NonNull InputStream stream) throws InvalidMidiDataException, IOException {
        return standardMidiFileReader.getMidiFileFormat(stream);
    }

    @NonNull
    public static MidiFileFormat getMidiFileFormat(@NonNull URL url) throws InvalidMidiDataException, IOException {
        return standardMidiFileReader.getMidiFileFormat(url);
    }

    @NonNull
    public static int[] getMidiFileTypes() {
        return standardMidiFileWriter.getMidiFileTypes();
    }

    @NonNull
    public static int[] getMidiFileTypes(@NonNull Sequence sequence) {
        return standardMidiFileWriter.getMidiFileTypes(sequence);
    }

    public static boolean isFileTypeSupported(int fileType) {
        return standardMidiFileWriter.isFileTypeSupported(fileType);
    }

    public static boolean isFileTypeSupported(int fileType, @NonNull Sequence sequence) {
        return standardMidiFileWriter.isFileTypeSupported(fileType, sequence);
    }

    public static int write(@NonNull Sequence sequence, int fileType, @NonNull File file) throws IOException {
        return standardMidiFileWriter.write(sequence, fileType, file);
    }

    public static int write(@NonNull Sequence sequence, int fileType, @NonNull OutputStream outputStream) throws IOException {
        return standardMidiFileWriter.write(sequence, fileType, outputStream);
    }

    public static class MidiSystemUtils {
        @NonNull
        public static List<Receiver> getReceivers() throws MidiUnavailableException {
            MidiDevice.Info[] midiDeviceInfos;
            ArrayList<Receiver> result = new ArrayList<Receiver>();
            for (MidiDevice.Info midiDeviceInfo : midiDeviceInfos = MidiSystem.getMidiDeviceInfo()) {
                result.addAll(MidiSystem.getMidiDevice(midiDeviceInfo).getReceivers());
            }
            return result;
        }

        @NonNull
        public static List<Transmitter> getTransmitters() throws MidiUnavailableException {
            MidiDevice.Info[] midiDeviceInfos;
            ArrayList<Transmitter> result = new ArrayList<Transmitter>();
            for (MidiDevice.Info midiDeviceInfo : midiDeviceInfos = MidiSystem.getMidiDeviceInfo()) {
                result.addAll(MidiSystem.getMidiDevice(midiDeviceInfo).getTransmitters());
            }
            return result;
        }
    }
}

