/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Vector;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.Patch;
import jp.kshoji.javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30 = 30.0f;
    public static final float SMPTE_30DROP = 29.97f;
    protected float divisionType;
    protected int resolution;
    protected Vector<Track> tracks;
    private static final float[] SUPPORTING_DIVISION_TYPES = new float[]{0.0f, 24.0f, 25.0f, 30.0f, 29.97f};

    private static boolean isSupportingDivisionType(float divisionType) {
        for (float supportingDivisionType : SUPPORTING_DIVISION_TYPES) {
            if (divisionType != supportingDivisionType) continue;
            return true;
        }
        return false;
    }

    public Sequence(float divisionType, int resolution) throws InvalidMidiDataException {
        if (!Sequence.isSupportingDivisionType(divisionType)) {
            throw new InvalidMidiDataException("Unsupported division type: " + divisionType);
        }
        this.divisionType = divisionType;
        this.resolution = resolution;
        this.tracks = new Vector();
    }

    public Sequence(float divisionType, int resolution, int numberOfTracks) throws InvalidMidiDataException {
        this(divisionType, resolution);
        if (numberOfTracks > 0) {
            for (int i = 0; i < numberOfTracks; ++i) {
                this.tracks.add(new Track());
            }
        }
    }

    @NonNull
    public Track createTrack() {
        Track track = new Track();
        this.tracks.add(track);
        return track;
    }

    public boolean deleteTrack(@Nullable Track track) {
        return this.tracks.remove(track);
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public long getMicrosecondLength() {
        return (long)(1000000.0f * (float)this.getTickLength() / ((this.divisionType == 0.0f ? 2.0f : this.divisionType) * (float)this.resolution * 1.0f));
    }

    public int getResolution() {
        return this.resolution;
    }

    public long getTickLength() {
        long maxTick = 0L;
        for (int i = 0; i < this.tracks.size(); ++i) {
            maxTick = Math.max(maxTick, this.tracks.get(i).ticks());
        }
        return maxTick;
    }

    @NonNull
    public Track[] getTracks() {
        Track[] track = new Track[this.tracks.size()];
        this.tracks.toArray(track);
        return track;
    }

    @NonNull
    public Patch[] getPatchList() {
        return new Patch[0];
    }
}

