/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MetaMessage;
import jp.kshoji.javax.sound.midi.MidiEvent;
import jp.kshoji.javax.sound.midi.Sequence;
import jp.kshoji.javax.sound.midi.Sequencer;

public class Track {
    private static final byte[] END_OF_TRACK = new byte[]{-1, 47, 0};
    private static final Track[] emptyTracks = new Track[0];
    private final List<MidiEvent> events = new ArrayList<MidiEvent>();
    static final Comparator<MidiEvent> midiEventComparator = new Comparator<MidiEvent>(){

        @Override
        public int compare(MidiEvent lhs, MidiEvent rhs) {
            int tickDifference = (int)(lhs.getTick() - rhs.getTick());
            if (tickDifference != 0) {
                return tickDifference * 256;
            }
            byte[] lhsMessage = lhs.getMessage().getMessage();
            byte[] rhsMessage = rhs.getMessage().getMessage();
            if (lhsMessage == null || lhsMessage.length < 1) {
                lhsMessage = new byte[]{0};
            }
            if (rhsMessage == null || rhsMessage.length < 1) {
                rhsMessage = new byte[]{0};
            }
            int lhsInt = lhsMessage[0] & 0xF0;
            int rhsInt = rhsMessage[0] & 0xF0;
            lhsInt = (lhsInt & 0x90) == 128 ? (lhsInt |= 0x10) : (lhsInt &= 0xFFFFFFEF);
            rhsInt = (rhsInt & 0x90) == 128 ? (rhsInt |= 0x10) : (rhsInt &= 0xFFFFFFEF);
            return -(lhsInt - rhsInt);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(@NonNull MidiEvent event) {
        List<MidiEvent> list = this.events;
        synchronized (list) {
            return this.events.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MidiEvent get(int index) throws ArrayIndexOutOfBoundsException {
        List<MidiEvent> list = this.events;
        synchronized (list) {
            return this.events.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(@NonNull MidiEvent event) {
        List<MidiEvent> list = this.events;
        synchronized (list) {
            return this.events.remove(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<MidiEvent> list = this.events;
        synchronized (list) {
            return this.events.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ticks() {
        TrackUtils.sortEvents(this);
        List<MidiEvent> list = this.events;
        synchronized (list) {
            if (this.events.isEmpty()) {
                return 0L;
            }
            return this.events.get(this.events.size() - 1).getTick();
        }
    }

    public static class TrackUtils {
        @NonNull
        public static Track mergeSequenceToTrack(@NonNull Sequencer sequencer, @NonNull Map<Track, Set<Integer>> recordEnable) throws InvalidMidiDataException {
            int trackIndex;
            Sequence sourceSequence = sequencer.getSequence();
            Track mergedTrack = new Track();
            Track[] tracks = sourceSequence == null ? emptyTracks : sourceSequence.getTracks();
            boolean hasSoloTrack = false;
            for (trackIndex = 0; trackIndex < tracks.length; ++trackIndex) {
                if (!sequencer.getTrackSolo(trackIndex)) continue;
                hasSoloTrack = true;
                break;
            }
            for (trackIndex = 0; trackIndex < tracks.length; ++trackIndex) {
                if (sequencer.getTrackMute(trackIndex) || hasSoloTrack && !sequencer.getTrackSolo(trackIndex) || sequencer.isRecording() && recordEnable.get(tracks[trackIndex]) != null && recordEnable.get(tracks[trackIndex]).size() > 0) continue;
                mergedTrack.events.addAll(tracks[trackIndex].events);
            }
            TrackUtils.sortEvents(mergedTrack);
            return mergedTrack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void sortEvents(@NonNull Track track) {
            List<MidiEvent> list = track.events;
            synchronized (list) {
                ArrayList<MidiEvent> filtered = new ArrayList<MidiEvent>();
                for (MidiEvent event : track.events) {
                    if (Arrays.equals(END_OF_TRACK, event.getMessage().getMessage())) continue;
                    filtered.add(event);
                }
                track.events.clear();
                track.events.addAll(filtered);
                Collections.sort(track.events, midiEventComparator);
                if (track.events.isEmpty()) {
                    track.events.add(new MidiEvent(new MetaMessage(END_OF_TRACK), 0L));
                } else {
                    track.events.add(new MidiEvent(new MetaMessage(END_OF_TRACK), track.events.get(track.events.size() - 1).getTick() + 1L));
                }
            }
        }
    }
}

