/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi.impl;

import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MidiChannel;
import jp.kshoji.javax.sound.midi.Receiver;
import jp.kshoji.javax.sound.midi.ShortMessage;
import jp.kshoji.javax.sound.midi.VoiceStatus;

public final class MidiChannelImpl
implements MidiChannel {
    private final int channel;
    private final Receiver receiver;
    private final VoiceStatus voiceStatus;
    private int channelPressure = 127;
    private SparseIntArray controller = new SparseIntArray();
    private int program = 0;
    private boolean mono = false;
    private boolean mute = false;
    private boolean omni = false;
    private int pitchbend = 8192;
    private SparseIntArray polyPressure = new SparseIntArray();
    private boolean solo = false;
    private boolean localControl = true;

    public MidiChannelImpl(int channel, @NonNull Receiver receiver, @NonNull VoiceStatus voiceStatus) {
        this.channel = voiceStatus.channel;
        this.receiver = receiver;
        this.voiceStatus = voiceStatus;
        this.voiceStatus.channel = channel;
    }

    @Override
    public void allNotesOff() {
        try {
            this.receiver.send(new ShortMessage(0xB0 | this.channel, 123, 0), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public void allSoundOff() {
        try {
            this.receiver.send(new ShortMessage(0xB0 | this.channel, 120, 0), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public void resetAllControllers() {
        try {
            this.receiver.send(new ShortMessage(0xB0 | this.channel, 121, 0), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public void noteOff(int noteNumber) {
        if (this.voiceStatus.active && this.voiceStatus.note == noteNumber) {
            this.voiceStatus.active = false;
        }
        try {
            this.receiver.send(new ShortMessage(0x80 | this.channel, noteNumber, 0), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public void noteOff(int noteNumber, int velocity) {
        if (this.voiceStatus.active && this.voiceStatus.note == noteNumber) {
            this.voiceStatus.active = false;
        }
        try {
            this.receiver.send(new ShortMessage(0x80 | this.channel, noteNumber, velocity), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public void noteOn(int noteNumber, int velocity) {
        if (!this.voiceStatus.active) {
            this.voiceStatus.note = noteNumber;
            this.voiceStatus.volume = velocity;
            this.voiceStatus.active = true;
        }
        try {
            this.receiver.send(new ShortMessage(0x90 | this.channel, noteNumber, velocity), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public int getChannelPressure() {
        return this.channelPressure;
    }

    @Override
    public void setChannelPressure(int pressure) {
        this.channelPressure = pressure;
        try {
            this.receiver.send(new ShortMessage(0xD0 | this.channel, pressure >> 7, pressure & 0x7F), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public int getController(int controller) {
        return this.controller.get(controller, 0);
    }

    @Override
    public void controlChange(int controller, int value) {
        this.controller.put(controller, value);
        try {
            this.receiver.send(new ShortMessage(0xB0 | this.channel, controller, value), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    public void programChange(int program) {
        this.program = program;
        try {
            this.receiver.send(new ShortMessage(0xC0 | this.channel, program, 0), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public void programChange(int bank, int program) {
        this.program = program;
        this.voiceStatus.bank = bank;
        this.voiceStatus.program = program;
        try {
            this.receiver.send(new ShortMessage(0xB0 | this.channel, 0, bank >> 7), 0L);
            this.receiver.send(new ShortMessage(0xB0 | this.channel, 32, bank & 0x7F), 0L);
            this.receiver.send(new ShortMessage(0xC0 | this.channel, program, 0), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public boolean getMono() {
        return this.mono;
    }

    @Override
    public void setMono(boolean on) {
        this.mono = on;
        if (this.mono) {
            try {
                this.receiver.send(new ShortMessage(0xB0 | this.channel, 126, 0), 0L);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {}
        } else {
            try {
                this.receiver.send(new ShortMessage(0xB0 | this.channel, 127, 0), 0L);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public boolean getOmni() {
        return this.omni;
    }

    @Override
    public void setOmni(boolean on) {
        this.omni = on;
        if (this.omni) {
            try {
                this.receiver.send(new ShortMessage(0xB0 | this.channel, 125, 0), 0L);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {}
        } else {
            try {
                this.receiver.send(new ShortMessage(0xB0 | this.channel, 124, 0), 0L);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getPitchBend() {
        return this.pitchbend;
    }

    @Override
    public void setPitchBend(int bend) {
        this.pitchbend = bend;
        try {
            this.receiver.send(new ShortMessage(0xE0 | this.channel, bend >> 7, bend & 0x7F), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public int getPolyPressure(int noteNumber) {
        return this.polyPressure.get(noteNumber, 0);
    }

    @Override
    public void setPolyPressure(int noteNumber, int pressure) {
        this.polyPressure.put(noteNumber, pressure);
        try {
            this.receiver.send(new ShortMessage(0xE0 | this.channel, pressure >> 7, pressure & 0x7F), 0L);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
    }

    @Override
    public boolean getSolo() {
        return this.solo;
    }

    @Override
    public void setSolo(boolean soloState) {
        this.solo = soloState;
    }

    @Override
    public boolean localControl(boolean on) {
        this.localControl = on;
        if (this.localControl) {
            try {
                this.receiver.send(new ShortMessage(0xB0 | this.channel, 122, 127), 0L);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {}
        } else {
            try {
                this.receiver.send(new ShortMessage(0xB0 | this.channel, 122, 0), 0L);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
        return this.localControl;
    }
}

