/*
 * Decompiled with CFR 0.152.
 */
package jp.kshoji.javax.sound.midi.io;

import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jp.kshoji.javax.sound.midi.InvalidMidiDataException;
import jp.kshoji.javax.sound.midi.MetaMessage;
import jp.kshoji.javax.sound.midi.MidiEvent;
import jp.kshoji.javax.sound.midi.MidiFileFormat;
import jp.kshoji.javax.sound.midi.MidiMessage;
import jp.kshoji.javax.sound.midi.Sequence;
import jp.kshoji.javax.sound.midi.ShortMessage;
import jp.kshoji.javax.sound.midi.SysexMessage;
import jp.kshoji.javax.sound.midi.Track;
import jp.kshoji.javax.sound.midi.spi.MidiFileReader;

public class StandardMidiFileReader
extends MidiFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MidiFileFormat getMidiFileFormat(@NonNull InputStream inputStream) throws InvalidMidiDataException, IOException {
        try (DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : (inputStream instanceof AssetManager.AssetInputStream ? new MidiDataInputStream(StandardMidiFileReader.convertToByteArrayInputStream(inputStream)) : new DataInputStream(inputStream));){
            int resolution;
            float divisionType;
            if (dataInputStream.readInt() != 1297377380) {
                throw new InvalidMidiDataException("Invalid header");
            }
            int bytes = dataInputStream.readInt();
            if (bytes < 6) {
                throw new InvalidMidiDataException("Invalid header");
            }
            short type = dataInputStream.readShort();
            if (type < 0 || type > 2) {
                throw new InvalidMidiDataException("Invalid header");
            }
            short numberOfTracks = dataInputStream.readShort();
            if (numberOfTracks <= 0) {
                throw new InvalidMidiDataException("Invalid tracks");
            }
            int division = dataInputStream.readShort();
            if ((division & 0x8000) != 0) {
                division = -(division >>> 8 & 0xFF);
                switch (division) {
                    case 24: {
                        divisionType = 24.0f;
                        break;
                    }
                    case 25: {
                        divisionType = 25.0f;
                        break;
                    }
                    case 29: {
                        divisionType = 29.97f;
                        break;
                    }
                    case 30: {
                        divisionType = 30.0f;
                        break;
                    }
                    default: {
                        throw new InvalidMidiDataException("Invalid sequence information");
                    }
                }
                resolution = division & 0xFF;
            } else {
                divisionType = 0.0f;
                resolution = division & Short.MAX_VALUE;
            }
            dataInputStream.skip(bytes - 6);
            ExtendedMidiFileFormat extendedMidiFileFormat = new ExtendedMidiFileFormat((int)type, divisionType, resolution, -1, -1L, numberOfTracks);
            return extendedMidiFileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MidiFileFormat getMidiFileFormat(@NonNull URL url) throws InvalidMidiDataException, IOException {
        try (InputStream inputStream = url.openStream();){
            MidiFileFormat midiFileFormat = this.getMidiFileFormat(inputStream);
            return midiFileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public MidiFileFormat getMidiFileFormat(@NonNull File file) throws InvalidMidiDataException, IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            MidiFileFormat midiFileFormat = this.getMidiFileFormat(inputStream);
            return midiFileFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NonNull
    public Sequence getSequence(@NonNull InputStream inputStream) throws InvalidMidiDataException, IOException {
        try (MidiDataInputStream midiDataInputStream = new MidiDataInputStream(StandardMidiFileReader.convertToByteArrayInputStream(inputStream));){
            ExtendedMidiFileFormat midiFileFormat = (ExtendedMidiFileFormat)this.getMidiFileFormat(midiDataInputStream);
            Sequence sequence = new Sequence(midiFileFormat.getDivisionType(), midiFileFormat.getResolution());
            int numberOfTracks = midiFileFormat.getNumberTracks();
            while (numberOfTracks-- > 0) {
                Track track = sequence.createTrack();
                if (midiDataInputStream.readInt() != 1297379947) {
                    throw new InvalidMidiDataException("Invalid track header");
                }
                midiDataInputStream.readInt();
                int runningStatus = -1;
                int ticks = 0;
                boolean isTrackRunning = true;
                while (isTrackRunning) {
                    void var11_11;
                    ticks += midiDataInputStream.readVariableLengthInt();
                    int data = midiDataInputStream.readUnsignedByte();
                    if (data < 128) {
                        if (runningStatus >= 0 && runningStatus < 240) {
                            ShortMessage shortMessage = StandardMidiFileReader.processRunningMessage(runningStatus, data, midiDataInputStream);
                        } else {
                            if (runningStatus < 240 || runningStatus > 255) throw new InvalidMidiDataException(String.format("Invalid data: %02x %02x", runningStatus, data));
                            ShortMessage shortMessage = StandardMidiFileReader.processSystemMessage(runningStatus, data, midiDataInputStream);
                        }
                    } else if (data < 240) {
                        ShortMessage shortMessage = StandardMidiFileReader.processRunningMessage(data, midiDataInputStream.readUnsignedByte(), midiDataInputStream);
                        runningStatus = data;
                    } else if (data == 240 || data == 247) {
                        int sysexLength = midiDataInputStream.readVariableLengthInt();
                        byte[] sysexData = new byte[sysexLength];
                        midiDataInputStream.readFully(sysexData);
                        SysexMessage sysexMessage = new SysexMessage();
                        sysexMessage.setMessage(data, sysexData, sysexLength);
                        SysexMessage sysexMessage2 = sysexMessage;
                        runningStatus = -1;
                    } else if (data == 255) {
                        int type = midiDataInputStream.readUnsignedByte();
                        int metaLength = midiDataInputStream.readVariableLengthInt();
                        byte[] metaData = new byte[metaLength];
                        midiDataInputStream.readFully(metaData);
                        MetaMessage metaMessage = new MetaMessage();
                        metaMessage.setMessage(type, metaData, metaLength);
                        MetaMessage metaMessage2 = metaMessage;
                        runningStatus = -1;
                        if (type == 47) {
                            isTrackRunning = false;
                        }
                    } else {
                        ShortMessage shortMessage = StandardMidiFileReader.processSystemMessage(data, null, midiDataInputStream);
                        runningStatus = data;
                    }
                    track.add(new MidiEvent((MidiMessage)var11_11, ticks));
                }
                Track.TrackUtils.sortEvents(track);
            }
            Sequence sequence2 = sequence;
            return sequence2;
        }
    }

    @NonNull
    private static ShortMessage processSystemMessage(int data1, Integer data2, @NonNull DataInput midiDataInputStream) throws InvalidMidiDataException, IOException {
        ShortMessage shortMessage;
        switch (data1) {
            case 242: {
                shortMessage = new ShortMessage();
                if (data2 == null) {
                    shortMessage.setMessage(data1, midiDataInputStream.readUnsignedByte(), midiDataInputStream.readUnsignedByte());
                    break;
                }
                shortMessage.setMessage(data1, data2, midiDataInputStream.readUnsignedByte());
                break;
            }
            case 243: 
            case 245: {
                shortMessage = new ShortMessage();
                if (data2 == null) {
                    shortMessage.setMessage(data1, midiDataInputStream.readUnsignedByte(), 0);
                    break;
                }
                shortMessage.setMessage(data1, data2, 0);
                break;
            }
            case 246: 
            case 248: 
            case 250: 
            case 251: 
            case 252: 
            case 254: {
                if (data2 != null) {
                    throw new InvalidMidiDataException(String.format("Invalid data: %02x", data2));
                }
                shortMessage = new ShortMessage();
                shortMessage.setMessage(data1, 0, 0);
                break;
            }
            default: {
                throw new InvalidMidiDataException(String.format("Invalid data: %02x", data1));
            }
        }
        return shortMessage;
    }

    @NonNull
    private static ShortMessage processRunningMessage(int status, int data1, @NonNull DataInput midiDataInputStream) throws InvalidMidiDataException, IOException {
        ShortMessage shortMessage;
        switch (status & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                shortMessage = new ShortMessage();
                shortMessage.setMessage(status, data1, midiDataInputStream.readUnsignedByte());
                break;
            }
            case 192: 
            case 208: {
                shortMessage = new ShortMessage();
                shortMessage.setMessage(status, data1, 0);
                break;
            }
            default: {
                throw new InvalidMidiDataException(String.format("Invalid data: %02x %02x", status, data1));
            }
        }
        return shortMessage;
    }

    @NonNull
    private static ByteArrayInputStream convertToByteArrayInputStream(@NonNull InputStream inputStream) throws IOException {
        if (inputStream instanceof ByteArrayInputStream) {
            return (ByteArrayInputStream)inputStream;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        int readBytes = 0;
        while ((readBytes = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, readBytes);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Sequence getSequence(@NonNull URL url) throws InvalidMidiDataException, IOException {
        try (InputStream inputStream = url.openStream();){
            Sequence sequence = this.getSequence(inputStream);
            return sequence;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Sequence getSequence(@NonNull File file) throws InvalidMidiDataException, IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Sequence sequence = this.getSequence(inputStream);
            return sequence;
        }
    }

    private static class MidiDataInputStream
    extends DataInputStream {
        public MidiDataInputStream(@NonNull InputStream inputStream) {
            super(inputStream);
        }

        public int readVariableLengthInt() throws IOException {
            int value = this.readByte();
            if ((value & 0x80) != 0) {
                byte c;
                value &= 0x7F;
                do {
                    c = this.readByte();
                    value = (value << 7) + (c & 0x7F);
                } while ((c & 0x80) != 0);
            }
            return value;
        }
    }

    private static class ExtendedMidiFileFormat
    extends MidiFileFormat {
        private final int numberOfTracks;

        public int getNumberTracks() {
            return this.numberOfTracks;
        }

        public ExtendedMidiFileFormat(int type, float divisionType, int resolution, int bytes, long microseconds, int numberOfTracks) {
            super(type, divisionType, resolution, bytes, microseconds);
            this.numberOfTracks = numberOfTracks;
        }
    }
}

