import { lib, game, ui, get, ai, _status } from "noname";

const translates = {
	re_yuanshao: "袁绍",
	re_lusu: "鲁肃",
	re_yuji: "于吉",
	wangji: "王基",
	kuailiangkuaiyue: "蒯良蒯越",
	sunliang: "孙亮",
	yl_luzhi: "卢植",
	xuyou: "许攸",
	luji: "陆绩",
	wangping: "王平",
	yanyan: "严颜",

	zhugezhan: "诸葛瞻",
	lukang: "陆抗",
	haozhao: "郝昭",
	yl_yuanshu: "新杀袁术",
	yl_yuanshu_prefix: "新杀",
	zhangxiu: "张绣",
	chendao: "陈到",
	guanqiujian: "毌丘俭",
	zhoufei: "周妃",

	nzry_jianxiang: "荐降",
	nzry_jianxiang_info: "当你成为其他角色使用牌的目标时，你可令手牌数最少的一名角色摸一张牌。",
	nzry_shenshi: "审时",
	nzry_shenshi_info: "转换技，阳：出牌阶段限一次，你可以将一张牌交给一名除你外手牌数最多的角色，然后对其造成1点伤害，若该角色因此死亡，则你可以令一名角色将手牌摸至四张。阴：其他角色对你造成伤害后，你可以观看该角色的手牌，然后交给其一张牌，当前角色回合结束时，若此牌仍在该角色的手牌区或装备区，你将手牌摸至四张。",
	nzry_mingren: "明任",
	nzry_mingren_info: "①游戏开始时，你摸两张牌，然后将一张手牌置于你的武将牌上，称为“任”。②结束阶段，你可以用一张手牌替换“任”。",
	nzry_zhenliang: "贞良",
	nzry_zhenliang_info: "转换技，阳：出牌阶段限一次，你可以弃置一张与“任”颜色相同的牌并对攻击范围内的一名角色造成1点伤害。阴：当你于回合外使用或打出的牌结算完成后，若此牌与“任”颜色相同，则你可以令一名角色摸一张牌。",
	nzry_chenglve: "成略",
	nzry_chenglve_info: "转换技，出牌阶段限一次，阳：你可以摸一张牌，然后弃置两张手牌。阴：你可以摸两张牌，然后弃置一张手牌。若如此做，直到本回合结束，你使用与弃置牌花色相同的牌无距离和次数限制。",
	nzry_cunmu: "寸目",
	nzry_cunmu_info: "锁定技，当你摸牌时，改为从牌堆底摸牌。",
	nzry_kuizhu: "溃诛",
	nzry_kuizhu_info: "弃牌阶段结束后，你可以选择一项：①令至多X名角色各摸一张牌。②对任意名体力值之和为X的角色造成1点伤害。（X为你此阶段弃置的牌数）",
	nzry_zhizheng: "掣政",
	rechezheng: "掣政",
	nzry_zhizheng_info: "锁定技，你的出牌阶段内，当你对攻击范围内不包含你的其他角色造成伤害时，防止此伤害。出牌阶段结束时，若你本阶段内使用的牌数小于这些角色的数量，则你弃置其中一名角色的一张牌。",
	nzry_lijun1: "立军",
	nzry_lijun: "立军",
	nzry_lijun_info: "主公技，其他吴势力角色的出牌阶段限一次，其使用【杀】结算后，可以将此【杀】对应的实体牌交给你，然后你可以令其摸一张牌且本阶段内使用【杀】的次数上限+1。",
	nzry_huaiju: "怀橘",
	nzry_huaiju_info: "锁定技，游戏开始时，你获得3个“橘”标记。（有“橘”的角色受到伤害时，防止此伤害，然后移去一个“橘”；有“橘”的角色摸牌阶段额外摸一张牌）",
	tachibana_effect: "怀橘",
	nzry_yili: "遗礼",
	nzry_yili_info: "出牌阶段开始时，你可以失去1点体力或移去一个“橘”，然后令一名其他角色获得一个“橘”。",
	nzry_zhenglun: "整论",
	nzry_zhenglun_info: "若你没有“橘”，你可以跳过摸牌阶段然后获得一个“橘”。",
	nzry_feijun: "飞军",
	nzry_feijun_info: "出牌阶段限一次。你可以弃置一张牌，然后选择一项：⒈令一名手牌数大于你的角色交给你一张牌；⒉令一名装备区里牌数大于你的角色弃置一张装备牌。",
	nzry_binglve: "兵略",
	nzry_binglve_info: "锁定技，当你发动“飞军”时，若目标与你之前指定的目标均不相同，则你摸两张牌。",
	nzry_juzhan: "拒战",
	nzry_juzhan_info: "转换技，阳：当你成为其他角色【杀】的目标后，你可以与其各摸一张牌，然后其本回合内不能再对你使用牌。阴：当你使用【杀】指定一名角色为目标后，你可以获得其一张牌，然后你本回合内不能再对其使用牌。",

	liangyin: "良姻",
	liangyin_info: "当有牌移至游戏外时，你可以令手牌数大于你的一名角色摸一张牌；当有牌从游戏外加入任意角色的手牌时，你可以令手牌数小于你的一名角色弃置一张牌。",
	kongsheng: "箜声",
	kongsheng_info: "准备阶段，你可以将任意张牌置于你的武将牌上；结束阶段，你使用武将牌上的装备牌，并获得武将牌上的其他牌。",
	kongsheng2: "箜声",
	kongsheng2_info: "",
	xinfu_zuilun: "罪论",
	xinfu_zuilun_info: "结束阶段，你可以观看牌堆顶三张牌，你每满足以下一项便保留一张，然后以任意顺序放回其余的牌：1.你于此回合内造成过伤害；2.你于此回合内未弃置过牌；3.手牌数为全场最少。若均不满足，你与一名其他角色失去1点体力。",
	xinfu_fuyin: "父荫",
	xinfu_fuyin_info: "锁定技，你每回合第一次成为【杀】或【决斗】的目标后，若你的手牌数小于等于该角色，此牌对你无效。",
	drlt_wanglie: "往烈",
	drlt_wanglie_info: "①出牌阶段，你使用的第一张牌无距离限制。②当你于出牌阶段内使用牌时，你可以令此牌不能被响应，然后你于本阶段内不能再使用牌。",
	drlt_xiongluan: "雄乱",
	drlt_xiongluan_info: "限定技，出牌阶段，你可以废除你的判定区和装备区，然后指定一名其他角色。直到回合结束，你对其使用牌无距离和次数限制，其不能使用和打出手牌。",
	drlt_congjian: "从谏",
	drlt_congjian_info: "当你成为锦囊牌的目标时，若此牌的目标数大于1，则你可以交给其中一名其他目标角色一张牌，然后摸一张牌，若你给出的是装备牌，改为摸两张牌。",
	drlt_yongsi: "庸肆",
	drlt_yongsi_info: "锁定技，摸牌阶段，你改为摸X张牌（X为存活势力数）；出牌阶段结束时，若你本回合：1.没有造成伤害，将手牌摸至当前体力值；2.造成的伤害超过1点，本回合手牌上限改为已损失体力值。",
	drlt_weidi: "伪帝",
	weidi_tag: "伪帝",
	drlt_weidi_info: "主公技，弃牌阶段开始时，若你的手牌数大于手牌上限，则你可以将至多X张手牌分别交给等量的其他群雄角色（X为你的手牌数与手牌上限之差）。",
	drlt_qianjie: "谦节",
	drlt_qianjie_info: "锁定技，当你横置时，取消之。你不能成为延时类锦囊的目标。你不能成为其他角色拼点的目标。",
	drlt_jueyan: "决堰",
	drlt_jueyan_info: `出牌阶段限一次，你可以废除一种装备栏，然后执行对应一项：武器栏，你本回合内使用【杀】的次数上限+3且本局游戏使用【杀】的次数上限+1；防具栏，你摸三张牌，且本局游戏手牌上限+3；坐骑栏，你本局游戏使用牌无距离限制；宝物栏，你获得${get.poptip("rejizhi")}。然后修改〖决堰〗。`,
	drlt_jueyan_rewrite: "决堰·改",
	drlt_jueyan_rewrite_info: `出牌阶段限一次，你可以废除一种装备栏，然后执行对应一项：武器栏，你本回合内使用【杀】的次数上限+3；防具栏，你摸三张牌，且本回合手牌上限+3；坐骑栏，你本回合内使用牌无距离限制；宝物栏，你获得${get.poptip("rejizhi")}直到回合结束。`,
	drlt_poshi: "破势",
	drlt_poshi_info: `觉醒技，准备阶段开始时，若你的装备栏均已被废除或体力值为1，则你减1点体力上限，将手牌摸至体力上限，失去〖决堰〗并获得${get.poptip("drlt_huairou")}。`,
	drlt_huairou: "怀柔",
	drlt_huairou_info: "出牌阶段，你可以重铸装备牌。",
	drlt_zhengu: "镇骨",
	drlt_zhengu2: "镇骨",
	drlt_zhengu_info: "结束阶段，你可以选择一名其他角色，你的回合结束后和该角色的下个回合结束时，其将手牌摸至或弃至X张。（X为你的手牌数且至多为5）",
	drlt_zhenrong: "征荣",
	drlt_zhenrong_info: "当你对其他角色造成伤害后，若其手牌比你多，你可以将其一张牌置于你的武将牌上，称为“荣”。",
	drlt_hongju: "鸿举",
	drlt_hongju_info: `觉醒技，准备阶段，若“荣”的数量大于或等于3且场上有角色死亡，则你可以用任意张手牌替换等量的“荣”，然后减1点体力上限并获得${get.poptip("drlt_qingce")}。`,
	drlt_qingce: "清侧",
	drlt_qingce_info: "出牌阶段，你可以移去一张“荣”，然后弃置一名角色装备区或判定区内的一张牌。",

	zhengrong: "征荣",
	hongju: "鸿举",
	qingce: "清侧",
	qingce_backup: "清侧",
	zhengrong_info: "当你使用带有「伤害」标签的基本牌或锦囊牌指定目标后，你可以将一名手牌数不小于你的目标角色的一张牌置于你的武将牌上，称为「荣」。",
	hongju_info: `觉醒技，准备阶段，若你武将牌上「荣」的数量不小于3，则你触发此技能。你可以用任意数量的手牌交换等量的「荣」。你减1点体力上限并获得技能${get.poptip("qingce")}。`,
	qingce_info: "出牌阶段，你可以获得一张「荣」并弃置一张手牌，然后弃置场上的一张牌。",

	jianchu: "鞬出",
	jianchu_info: "当你使用【杀】指定一名角色为目标后，你可以弃置其一张牌，若以此法弃置的牌为装备牌，此【杀】不可被【闪】响应，若不为装备牌，该角色获得此【杀】。",
	redimeng: "缔盟",
	redimeng_info: "出牌阶段限一次，你可以弃置X张牌选择两名其他角色（X为这两名角色的手牌差），你混合他们的手牌，然后令其中一名角色获得其中的一张牌，并令另一名角色获得其中的一张牌，然后重复此流程，直到这些牌均被获得为止。",
	reluanji: "乱击",
	reluanji_info: "你可以将两张与你本回合以此法转化的花色均不相同的手牌当【万箭齐发】使用，然后当一名角色因响应此牌而打出【闪】时，该角色摸一张牌。若你以此法使用的【万箭齐发】未造成伤害，则你可以在此牌结算完成后摸X张牌。(X为此牌的目标数)",
	xintianxiang: "天香",
	xintianxiang2: "天香",
	xintianxiang3: "天香",
	xintianxiang4: "天香",
	xintianxiang_bg: "香",
	xintianxiang_info: "当你受到伤害时，你可以弃置一张♥牌，将此伤害转移给一名其他角色，然后你选择一项：令该角色摸X张牌（X为其已损失的体力值）；或防止其造成与受到的所有伤害，且此技能失效直到你的下回合开始。",
	xinshensu: "神速",
	xinshensu_info: "你可以选择一至三项：1. 跳过判定阶段和摸牌阶段；2. 跳过出牌阶段并弃置一张装备牌；3. 跳过弃牌阶段并将你的武将牌翻面。你每选择一项，视为你对一名其他角色使用一张没有距离限制的【杀】。",
	yinghun: "英魂",
	yinghun_info: "准备阶段开始时，你可令一名其他角色执行一项：摸X张牌，然后弃置一张牌；或摸一张牌，然后弃置X张牌（X为你已损失的体力值）。",
	gzyinghun: "英魂",
	gzyinghun_info: "准备阶段开始时，若你已受伤，你可令一名其他角色执行一项：摸X张牌，然后弃置一张牌；或摸一张牌，然后弃置X张牌（X为你已损失的体力值）。",

	tiaoxin: "挑衅",
	zhiji: "志继",
	zhiji_draw: "摸牌",
	zhiji_recover: "回血",
	xiangle: "享乐",
	fangquan: "放权",
	ruoyu: "若愚",
	qiaobian: "巧变",
	tuntian: "屯田",
	tuntian_bg: "田",
	zaoxian: "凿险",
	jixi: "急袭",
	jiang: "激昂",
	hunzi: "魂姿",
	zhiba: "制霸",
	zhiba2: "制霸",
	zhijian: "直谏",
	guzheng: "固政",
	beige: "悲歌",
	duanchang: "断肠",
	// fushen:'附身',
	huashen: "化身",
	xinsheng: "新生",
	qimou: "奇谋",
	xinqiangxi: "强袭",
	xinjushou: "据守",
	xinjiewei: "解围",
	retianxiang: "天香",
	retianxiang_info: "当你受到伤害时，你可以弃置一张红桃手牌，防止此次伤害并选择一名其他角色，然后你选择一项：1.令其受到伤害来源对其造成的1点伤害，然后摸X张牌（X为其已损失体力值且至多为5）；2.令其失去1点体力，然后获得你弃置的牌。",
	xinjiewei_info: "你可以将装备区里的牌当【无懈可击】使用；当你的武将牌从背面翻至正面时，你可以弃置一张牌，然后移动场上的一张牌。",
	xinjushou_info: "结束阶段，你可以翻面并摸四张牌，然后弃置一张手牌，若以此法弃置的是装备牌，则你改为使用之。",
	jixi_info: "出牌阶段，你可以将任意一张“田”当作【顺手牵羊】使用。",
	xinqiangxi_info: "出牌阶段各限一次，你可以选择一项：1. 失去1点体力并对你攻击范围内的一名其他角色造成1点伤害；2. 弃置一张装备牌并对你攻击范围内的一名其他角色造成1点伤害。",
	qimou_info: "限定技，出牌阶段，你可以失去任意点体力，然后直到回合结束，你计算与其他角色的距离时-X，且你可以多使用X张【杀】（X为你失去的体力值）。",
	tiaoxin_info: "出牌阶段限一次，你可以指定一名攻击范围内包含你的角色，该角色需对你使用一张【杀】，否则你弃置其一张牌。",
	zhiji_info: `觉醒技，准备阶段，若你没有手牌，你须回复1点体力或摸两张牌，然后减1点体力上限，并获得技能${get.poptip("reguanxing")}。`,
	xiangle_info: "锁定技，当你成为一名角色使用【杀】的目标后，该角色需弃置一张基本牌，否则此【杀】对你无效。",
	fangquan_info: "你可跳过你的出牌阶段，若如此做，回合结束时，你可以弃置一张手牌并令一名其他角色进行一个额外的回合。",
	ruoyu_info: `主公技，觉醒技，准备阶段，若你的体力是全场最少的(或之一)，你须增加1点体力上限并回复1点体力，然后获得技能${get.poptip("rejijiang")}。`,
	qiaobian_info: "你可以弃置一张手牌并跳过自己的一个阶段（准备阶段和结束阶段除外）。若你以此法跳过了摸牌阶段，则你可以获得至多两名其他角色的各一张手牌；若你以此法跳过了出牌阶段，则你可以移动场上的一张牌。",
	tuntian_info: "①当你于回合外失去牌后，你可以判定。若判定结果不为♥，则你将此牌置于你的武将牌上，称为“田”。②你计算与其他角色的距离时-X（X为你武将牌上“田”的数目）。",
	zaoxian_info: `觉醒技，准备阶段，若你武将牌上至少拥有三张“田”，则你减1点体力上限，并获得技能${get.poptip("jixi")}。`,
	jiang_info: "每当你使用（指定目标后）或被使用（成为目标后）一张【决斗】或红色的【杀】时，你可以摸一张牌。",
	hunzi_info: `觉醒技，准备阶段，若你的体力值为1，你减1点体力上限，并获得技能${get.poptip("reyingzi")}和${get.poptip("gzyinghun")}。`,
	zhiba_info: "主公技，其他吴势力角色的出牌阶段限一次，其可与你进行一次拼点。若该角色没赢，你可以获得双方拼点的牌。若你已发动过〖魂姿〗，你可以拒绝此拼点。",
	zhijian_info: "出牌阶段，你可以将手牌中的一张装备牌置于一名其他角色装备区里（不得替换原装备），然后摸一张牌。",
	guzheng_info: "其他角色的弃牌阶段结束时，你可以令其获得本阶段内进入弃牌堆的牌中的一张，然后你获得其余的牌。",
	beige_info: "当有角色受到【杀】造成的伤害后，你可以弃一张牌，并令其进行一次判定，若判定结果为：♥该角色回复1点体力；♦︎该角色摸两张牌；♣伤害来源弃两张牌；♠伤害来源将其武将牌翻面。",
	duanchang_info: "锁定技，杀死你的角色失去当前的所有技能。",
	// fushen_info:'回合开始前，你可以选择与任意一名角色交换控制权，该角色可选择在下一个回合开始前与你换回。',
	huashen_info: "①游戏开始时，你随机将武将牌堆中的两张牌扣置于武将牌上（均称为“化身牌”），选择并亮出一张“化身牌”并声明该武将牌上的一个技能，你拥有该技能且同时将性别和势力属性变成与该武将相同直到该化身被替换（你不可声明限定技、觉醒技、隐匿技、使命技、主公技等特殊技能）。②回合开始时或回合结束时，你重新可以选择一张“化身牌”并声明该武将牌上的一个技能。",
	xinsheng_info: "当你受到1点伤害后，你可以获得一张“化身牌”。",
	jiangwei: "姜维",
	liushan: "刘禅",
	zhanghe: "张郃",
	dengai: "邓艾",
	sunce: "孙策",
	zhangzhang: "张昭张纮",
	caiwenji: "蔡琰",
	zuoci: "左慈",

	zhurong: "祝融",
	menghuo: "孟获",
	caopi: "曹丕",
	re_xuhuang: "徐晃",
	lusu: "旧鲁肃",
	lusu_prefix: "旧",
	sunjian: "孙坚",
	dongzhuo: "董卓",
	jiaxu: "贾诩",
	huoshou: "祸首",
	huoshou1: "祸首",
	huoshou2: "祸首",
	zaiqi: "再起",
	zaiqixx: "再起",
	juxiang: "巨象",
	juxiang1: "巨象",
	juxiang2: "巨象",
	lieren: "烈刃",
	xingshang: "行殇",
	fangzhu: "放逐",
	songwei: "颂威",
	songwei2: "颂威",
	duanliang: "断粮",
	duanliang1: "断粮",
	haoshi: "好施",
	dimeng: "缔盟",
	jiuchi: "酒池",
	roulin: "肉林",
	benghuai: "崩坏",
	baonue: "暴虐",
	baonue2: "暴虐",
	baonue_hp: "体力",
	baonue_maxHp: "体力上限",
	luanwu: "乱武",
	wansha: "完杀",
	weimu: "帷幕",
	jiezi: "截辎",
	jiezi_info: "锁定技，其他角色跳过摸牌阶段后，你摸一张牌。",
	huoshou_info: "锁定技，【南蛮入侵】对你无效；你视为所有【南蛮入侵】的伤害来源。",
	zaiqi_info: "摸牌阶段，若你已受伤，则你可以改为亮出牌堆顶的X张牌（X为你已损失的体力值），并回复X点体力（X为其中♥牌的数目）。然后你将这些♥牌置入弃牌堆，并获得其余的牌。",
	zaiqixx_info: "摸牌阶段，若你已受伤，则你可以改为亮出牌堆顶的X张牌（X为你已损失的体力值+1），并回复X点体力（X为其中♥牌的数目）。然后你将这些♥牌置入弃牌堆，并获得其余的牌。",
	juxiang_info: "锁定技。①【南蛮入侵】对你无效。②其他角色使用的【南蛮入侵】结算结束后，你获得此牌对应的所有实体牌。",
	lieren_info: "当你使用【杀】造成伤害后，可与受到该伤害的角色进行拼点；若你赢，你获得对方的一张牌。",
	xingshang_info: "当有角色死亡后，你可以获得该角色的所有牌。",
	fangzhu_info: "当你受到伤害后，你可令一名其他角色摸X张牌（X为你已损失的体力值），然后该角色将武将牌翻面。",
	songwei_info: "主公技，其他魏势力的角色的判定牌结果为黑色且生效后，其可以令你摸一张牌。",
	duanliang_info: "你可以将一张黑色基本牌或装备牌当做【兵粮寸断】使用；若一名角色的手牌数大于或等于你的手牌数，则你对其使用【兵粮寸断】没有距离限制。",
	haoshi_info: "摸牌阶段，你可以额外摸两张牌。若此时你的手牌数多于五张，你须将一半(向下取整)的手牌交给场上除你外手牌数最少的一名角色。",
	dimeng_info: "出牌阶段限一次，你可以选择其他两名角色，你弃置等同于这两名角色手牌数量之差的牌，然后交换他们的手牌。",
	yinghun_old_info: "准备阶段，若你已受伤，则你可以令一名其他角色执行下列两项中的一项： 1.摸X张牌，然后弃一张牌。 2.摸一张牌，然后弃X张牌。 （X为你已损失的体力值）",
	jiuchi_info: "你可以将一张♠手牌当作【酒】使用。",
	roulin_info: "锁定技。你对女性角色、女性角色对你使用【杀】时，都需连续使用两张【闪】才能抵消。",
	benghuai_info: "锁定技。结束阶段，若你的体力不为全场最少，你失去1点体力或减1点体力上限。",
	baonue_info: "主公技，其他群雄角色造成伤害后，可进行一次判定，若为♠，你回复1点体力。",
	luanwu_info: "限定技，出牌阶段，你可令除你外的所有角色依次对与其距离最近的另一名角色使用一张【杀】，否则失去1点体力。",
	wansha_info: "锁定技，你的回合内，除你以外，不处于濒死状态的角色不能使用【桃】。",
	weimu_info: "锁定技，你不能成为黑色锦囊牌的目标。",

	sp_zhugeliang: "卧龙",
	pangtong: "庞统",
	xunyu: "荀彧",
	dianwei: "典韦",
	taishici: "太史慈",
	yanwen: "颜良文丑",
	yuanshao: "旧袁绍",
	yuanshao_prefix: "旧",
	re_pangde: "庞德",
	huoji: "火计",
	bazhen: "八阵",
	kanpo: "看破",
	niepan: "涅槃",
	oldniepan: "涅槃",
	quhu: "驱虎",
	jieming: "节命",
	qiangxix: "强袭",
	qiangxi: "强袭",
	tianyi: "天义",
	shuangxiong: "双雄",
	shuangxiong1: "双雄",
	shuangxiong2: "双雄",
	luanji: "乱击",
	xueyi: "血裔",
	mengjin: "猛进",
	huoji_info: "你可以将一张红色手牌当作【火攻】使用。",
	bazhen_info: "锁定技，若你的防具栏内没有牌且没有被废除，则你视为装备着【八卦阵】。",
	kanpo_info: "你可以将你的任意一张黑色手牌当做【无懈可击】使用。",
	niepan_info: "限定技，出牌阶段或当你处于濒死状态时，你可以弃置你区域内的所有牌并复原你的武将牌，然后摸三张牌并将体力回复至3点。",
	oldniepan_info: "限定技，当你处于濒死状态时，你可以弃置你区域内的所有牌并复原你的武将牌，然后摸三张牌并将体力回复至3点。",
	quhu_info: "出牌阶段限一次，你可以与一名体力值大于你的角色拼点，若你赢，则该角色对其攻击范围内另一名由你指定的角色造成1点伤害。若你没赢，该角色对你造成1点伤害。",
	jieming_info: "当你受到1点伤害后，你可令一名角色将手牌摸至X张（X为其体力上限且至多为5）。",
	qiangxi_info: "出牌阶段限一次，你可以失去1点体力或弃置一张武器牌，然后对你攻击范围内的一名其他角色造成1点伤害。",
	qiangxix_info: "出牌阶段限两次，你可以失去1点体力或弃置一张武器牌，然后对一名本阶段内未成为过〖强袭〗的目标的其他角色造成1点伤害。",
	tianyi_info: "出牌阶段限一次，你可以和一名其他角色拼点。若你赢，你获得以下技能效果直到回合结束：你使用【杀】没有距离限制；可额外使用一张【杀】；使用【杀】时可额外指定一个目标。若你没赢，你不能使用【杀】直到回合结束。",
	shuangxiong_info: "摸牌阶段，你可以改为进行一次判定：你获得此判定牌，且你可以于此回合内将任意一张与此判定牌不同颜色的手牌当做【决斗】使用。",
	luanji_info: "出牌阶段，你可以将任意两张相同花色的手牌当做【万箭齐发】使用。",
	xueyi_info: "主公技，锁定技，场上每有一名其他群雄角色存活，你的手牌上限便+2。",
	mengjin_info: "当你使用的【杀】被【闪】抵消时，你可以弃置目标角色的一张牌。",

	re_xiahouyuan: "夏侯渊",
	re_huangzhong: "黄忠",
	re_weiyan: "魏延",

	old_zhoutai: "周泰",
	old_caoren: "曹仁",
	xuhuang: "旧徐晃",
	xuhuang_prefix: "旧",
	pangde: "旧庞德",
	pangde_prefix: "旧",
	xiahouyuan: "旧夏侯渊",
	xiahouyuan_prefix: "旧",
	huangzhong: "旧黄忠",
	huangzhong_prefix: "旧",
	sp_zhangjiao: "张角",
	weiyan: "旧魏延",
	weiyan_prefix: "旧",
	xiaoqiao: "小乔",
	zhangjiao: "旧张角",
	zhangjiao_prefix: "旧",
	//yuji:'于吉',
	shensu: "神速",
	shensu1: "神速",
	shensu2: "神速",
	shensu4: "神速",
	jushou: "据守",
	moon_jushou: "据守",
	liegong: "烈弓",
	kuanggu: "狂骨",
	tianxiang: "天香",
	hongyan: "红颜",
	buqu: "不屈",
	buqu_bg: "创",
	leiji: "雷击",
	guidao: "鬼道",
	huangtian: "黄天",
	huangtian2: "黄天",
	guhuo: "蛊惑",
	fenji: "奋激",
	releiji: "雷击",
	jiewei: "解围",
	tiangong: "天公",
	tiangong2: "天公",
	xinliegong: "烈弓",
	xinkuanggu: "狂骨",
	gzbuqu: "不屈",
	gzbuqu_info: "①当你扣减1点体力时，若你的体力值小于1，你可以将牌堆顶的一张牌置于你的武将牌上，称为“创”。②当你回复1点体力时，你移去一张“创”。③若你有“创”且点数均不相同，则你不结算濒死流程。",
	xinkuanggu_info: "当你造成1点伤害后，若受伤角色受到此伤害时你与其的距离不大于1，则你可以回复1点体力或摸一张牌。",
	xinliegong_info: "①你使用【杀】可以选择你距离不大于此【杀】点数的角色为目标。②当你使用【杀】指定一个目标后，你可以根据下列条件执行相应的效果：1.其手牌数小于等于你的手牌数，此【杀】不可被响应，2.其体力值大于等于你的体力值，此【杀】伤害+1。",
	jiewei_info: "当你的武将牌翻面后，你可以摸一张牌。然后你可以使用一张锦囊牌或装备牌，并可以在此牌结算后弃置场上一张同类型的牌。",
	releiji_info: "当你使用或打出一张【闪】时，你可令一名其他角色进行一次判定：若结果为梅花，你回复1点体力，并对其造成1点雷电伤害；若结果为黑桃，你对其造成2点雷电伤害。",
	tiangong_info: "锁定技，你防止即将受到的雷电伤害。每当你造成雷电伤害时，你摸一张牌。",
	shensu_info: "你可以跳过判定阶段和摸牌阶段，或跳过出牌阶段并弃置一张装备牌。若如此做，则你可以视为对任意一名角色使用一张无距离限制的【杀】。",
	jushou_info: "结束阶段，你可以摸三张牌并翻面。",
	moon_jushou_info: "结束阶段，你可以摸一张牌并翻面。",
	liegong_info: "当你使用【杀】时，若目标的手牌数大于等于你的体力值，或小于等于你的攻击范围，你可令此【杀】不能被响应。",
	kuanggu_info: "锁定技，当你造成伤害后，若受伤角色受到此伤害时你与其的距离不大于1，你回复X点体力（X为伤害值）。",
	tianxiang_info: "当你即将受到伤害时，你可以弃置一张♥手牌，将伤害转移给一名其他角色，然后该角色摸X张牌（X为其已损失的体力值）。",
	hongyan_info: "锁定技，你区域内的黑桃牌和黑桃判定牌均视为红桃。",
	buqu_info: "锁定技，当你处于濒死状态时，你亮出牌堆顶的一张牌并置于你的武将牌上，称之为“创”。若此牌的点数与你武将牌上已有的“创”点数均不同，则你回复至1体力。若点数相同，则将此牌置入弃牌堆。只要你的武将牌上有“创”，你的手牌上限便与“创”的数量相等。",
	buqu_info_guozhan: "锁定技，当你处于濒死状态时，你亮出牌堆顶的一张牌并置于你的武将牌上，称之为“创”。若此牌的点数与你武将牌上已有的“创”点数均不同，则你回复至1体力。若点数相同，则将此牌置入弃牌堆。",
	leiji_info: "当你使用或打出一张【闪】时，你可令任意一名角色进行一次判定。若结果为黑桃，其受到2点雷电伤害。",
	guidao_info: "一名角色的判定牌生效前，你可以打出一张黑色牌替换之。",
	huangtian_info: "主公技，其他群势力角色的出牌阶段限一次，其可以交给你一张【闪】或【闪电】。",
	guhuo_info: "每名角色的回合限一次，你可以扣置一张手牌当一张基本牌或普通锦囊牌使用或打出。其他角色依次选择是否质疑。一旦有其他角色质疑则翻开此牌：若为假则此牌作废，若为真，则质疑角色获得技能“缠怨”（锁定技，你不能质疑于吉，只要你的体力值为1，你失去你的武将技能）。",
	fenji_info: "当一名角色的手牌不因赠予或交给而被另一名角色得到后，或一名角色的手牌被另一名角色弃置后，你可以失去1点体力，令其摸两张牌。",

	new_fenji: "奋激",
	new_fenji_info: "一名角色的结束阶段开始时，若其没有手牌，你可以令其摸两张牌，然后你失去1点体力。",
	gzduanliang: "断粮",
	gzduanliang_info: "你可以将一张黑色基本牌或黑色装备牌当【兵粮寸断】使用；你可以对距离为2的角色使用【兵粮寸断】。",
	xinfu_guhuo: "蛊惑",
	xinfu_guhuo_info: `每回合限一次。你可以扣置一张手牌当做一张基本牌或普通锦囊牌使用或打出，其他角色依次选择是否质疑。当有角色质疑时，你终止质疑流程并展示此牌：若为假，此牌作废；若为真，该角色获得${get.poptip("chanyuan")}。`,
	guhuo_guess: "蛊惑",
	guhuo_guess_info: "",
	chanyuan: "缠怨",
	chanyuan_info: "锁定技。你不能于〖蛊惑〗的结算流程中进行质疑。当你的体力值为1时，你的其他技能失效。",
	guhuo_respond: "蛊惑",
	guhuo_respond_info: "",
	guhuo_wuxie: "蛊惑",
	guhuo_wuxie_info: "",
	guhuo_phase: "蛊惑",
	guhuo_phase_info: "",
	xinhongyan: "红颜",
	xinhongyan_info: "锁定技，你的♠牌和♠判定牌的花色视为♥。一名角色的判定结果生效前，若判定结果为♥，则你将其改为一种花色。",
	olliangyin: "良姻",
	olliangyin_info: "当有牌发生移动后，若此移动事件是本回合内你拥有〖良姻〗期间的首个有牌移出游戏/移入游戏的事件，则你可以选择一名其他角色。你与其各摸一张牌/弃置一张牌，然后你可以选择你或其中的一名手牌数为X的角色，该角色回复1点体力（X为你的“箜”数）。",
	olkongsheng: "箜声",
	olkongsheng_info: "①准备阶段开始时，你可以将任意张牌置于你的武将牌上，称为“箜”。②结束阶段开始时，若你有不为装备牌的“箜”，则你获得“箜”中的非装备牌，然后令一名角色依次使用“箜”中的装备牌并失去1点体力。",
	dcwanglie: "往烈",
	dcwanglie_info: "①出牌阶段，你对其他角色使用的前两张牌无距离限制。②当你于出牌阶段内使用牌时，你可以令此牌不能被响应，然后你于本阶段内不能使用牌指定其他角色为目标。",
	nzry_shicai: "恃才",
	nzry_shicai_info: "当你使用非装备牌结算结束后，或成为自己使用装备牌的目标后，若此牌为你本回合使用的首张该类型牌，则你可以将此牌置于牌堆顶，然后摸一张牌。",
	lianhuan: "连环",
	lianhuan_info: "你可以将♣手牌当作【铁索连环】使用或重铸。",
};

export default translates;
