import { lib, game, ui, get, ai, _status } from "./utils.js";

export function content(config, pack) {
	if (lib.config.extension_杀海拾遗_forbidconfigs !== lib.extensionPack["杀海拾遗"].version) {
		const configs = {
			forbidboss: ["gjqt_aruan"],
			forbidchess: ["swd_kangnalishi"],
			forbiddouble: ["hs_siwangzhiyi", "hs_ronghejuren", "hs_shanlingjuren", "swd_kangnalishi"],
			forbidstone: ["gjqt_bailitusu", "gjqt_aruan", "hs_malfurion", "hs_siwangzhiyi", "hs_xuanzhuanjijia", "hs_guldan", "hs_yngvar", "hs_anduin", "hs_antonidas", "hs_lreno", "ow_tianshi", "pal_xuanxiao", "pal_yuejinzhao", "swd_anka", "swd_nicole", "swd_tuwei", "swd_guyue", "swd_rongshuang", "swd_jiangziya", "swd_qiner", "swd_hanluo", "swd_huanglei", "swd_muyun"],
			forbidthreecard: ["gw_ciguhanshuang", "gw_birinongwu", "gw_qinpendayu", "gw_poxiao"],
		};
		for (const key in configs) {
			if (Array.isArray(lib.config[key])) {
				lib.config[key].addArray(configs[key]);
				game.saveConfig(key, lib.config[key]);
			}
		}
		game.saveExtensionConfig("杀海拾遗", "forbidconfigs", lib.extensionPack["杀海拾遗"].version);
	}

	if (lib.perfectPair) {
		// 原因不明
		if (lib.perfectPair.hanba) {
			lib.perfectPair.hanba.push("swd_muyun");
		} else {
			lib.perfectPair.hanba = ["swd_muyun"];
		}
	}

	if (lib.rank) {
		const rank = {
			s: ["gjqt_bailitusu", "gjqt_beiluo", "gjqt_xieyi", "hs_malorne", "hs_medivh", "hs_sthrall", "pal_yuejinzhao", "swd_cheyun", "swd_duguningke", "swd_guyue", "swd_huanglei", "swd_murongshi", "swd_muyun", "swd_septem", "swd_tuobayuer", "swd_xuanyuanjianxian", "swd_yuxiaoxue", "swd_zhaoyun"],
			ap: ["gjqt_aruan", "gjqt_cenying", "gjqt_ouyangshaogong", "gjqt_yunwuyue", "gw_diandian", "gw_yioufeisisp", "hs_alakir", "hs_ashamoer", "hs_aya", "hs_hajiasha", "hs_malygos", "hs_neptulon", "hs_tyrande", "hs_xsylvanas", "ow_ana", "ow_dva", "ow_liekong", "ow_luxiao", "ow_mei", "ow_yuanshi", "pal_liumengli", "pal_lixiaoyao", "pal_murongziying", "pal_xiahoujinxuan", "pal_xuanxiao", "pal_yueqi", "pal_yuntianhe", "pal_zixuan", "swd_huanyuanzhi", "swd_huiyan", "swd_jiliang", "swd_jipeng", "swd_muyue", "swd_qi", "swd_shuijing", "swd_shuwaner", "swd_tuwei", "swd_yuwentuo"],
			a: [
				"gjqt_fanglansheng",
				"gjqt_fengqingxue",
				"gjqt_xiayize",
				"gw_aigeleisi",
				"gw_aimin",
				"gw_airuiting",
				"gw_aisinie",
				"gw_bulanwang",
				"gw_dagong",
				"gw_enxier",
				"gw_falanxisika",
				"gw_fulisi",
				"gw_haluo",
				"gw_jieluote",
				"gw_kairuisi",
				"gw_kanbi",
				"gw_kaxier",
				"gw_linjing",
				"gw_luobo",
				"gw_luoqi",
				"gw_meizi",
				"gw_nvyemo",
				"gw_puxila",
				"gw_shasixiwusi",
				"gw_telisi",
				"gw_xili",
				"gw_yenaifa",
				"gw_yioufeisi",
				"gw_yisilinni",
				"gw_zhangyujushou",
				"hs_alleria",
				"hs_amala",
				"hs_anduin",
				"hs_antonidas",
				"hs_bannabusi",
				"hs_bchillmaw",
				"hs_enzoth",
				"hs_fandral",
				"hs_fuding",
				"hs_heifengqishi",
				"hs_jaina",
				"hs_kaituozhe",
				"hs_kalimosi",
				"hs_khadgar",
				"hs_lafamu",
				"hs_laila",
				"hs_laxiao",
				"hs_lrhonin",
				"hs_manyututeng",
				"hs_morgl",
				"hs_pengpeng",
				"hs_sainaliusi",
				"hs_sapphiron",
				"hs_shanlingjuren",
				"hs_siwangxianzhi",
				"hs_trueheart",
				"hs_tuoqi",
				"hs_walian",
				"hs_xialikeer",
				"hs_xukongzhiying",
				"hs_yashaji",
				"hs_yelinlonghou",
				"hs_yinggencao",
				"hs_yngvar",
				"hs_ysera",
				"hs_zhanzhenggushu",
				"hs_zhihuanhua",
				"hs_zhishigushu",
				"mtg_jiding",
				"mtg_jiesi",
				"mtg_lilianna",
				"ow_banzang",
				"ow_chanyata",
				"ow_heiying",
				"ow_laiyinhate",
				"ow_maikelei",
				"ow_tianshi",
				"ow_tuobiang",
				"ow_zhaliya",
				"pal_jingtian",
				"pal_longkui",
				"pal_luozhaoyan",
				"pal_mingxiu",
				"pal_muchanglan",
				"pal_nangonghuang",
				"pal_tangyurou",
				"pal_wangpengxu",
				"pal_xia",
				"pal_xingxuan",
				"swd_anka",
				"swd_chenjingchou",
				"swd_hengai",
				"swd_huzhongxian",
				"swd_kangnalishi",
				"swd_kendi",
				"swd_lanyin",
				"swd_shanxiaoxiao",
				"swd_sikongyu",
				"swd_wangsiyue",
				"swd_xiarou",
				"swd_ziqiao",
			],
			am: [
				"gjqt_chuqi",
				"gjqt_xiangling",
				"gjqt_xunfang",
				"gjqt_yanjiaxieyi",
				"gjqt_yuewuyi",
				"gw_bierna",
				"gw_fenghuang",
				"gw_fuertaisite",
				"gw_haizhiyezhu",
				"gw_hengsaite",
				"gw_huoge",
				"gw_kaerweite",
				"gw_kuite",
				"gw_laduoweide",
				"gw_lanbote",
				"gw_laomaotou",
				"gw_mieren",
				"gw_nitelila",
				"gw_oudimu",
				"gw_sanhanya",
				"gw_saqiya",
				"gw_shanhu",
				"gw_xigedelifa",
				"gw_zhuoertan",
				"hs_aedwin",
				"hs_aiqinvyao",
				"hs_alextrasza",
				"hs_barnes",
				"hs_bilanyoulong",
				"hs_blingtron",
				"hs_bolvar",
				"hs_brann",
				"hs_fachaotuteng",
				"hs_jiaziruila",
				"hs_kazhakusi",
				"hs_kchromaggus",
				"hs_kcthun",
				"hs_magni",
				"hs_mijiaojisi",
				"hs_mojinbaozi",
				"hs_pyros",
				"hs_ronghejuren",
				"hs_shaku",
				"hs_shizugui",
				"hs_shuiwenxuejia",
				"hs_siwangzhiyi",
				"hs_taisi",
				"hs_totemic",
				"hs_wujiyuansu",
				"hs_wvelen",
				"hs_yangyanwageli",
				"hs_yogg",
				"old_majun",
				"ow_baolei",
				"ow_falaozhiying",
				"ow_kuangshu",
				"ow_orisa",
				"ow_shibing",
				"ow_wensidun",
				"pal_anu",
				"pal_changqing",
				"pal_hanlingsha",
				"pal_jushifang",
				"pal_wenhui",
				"pal_xianqing",
				"pal_xuejian",
				"pal_zhaoliner",
				"swd_duanmeng",
				"swd_duopeng",
				"swd_fengyu",
				"swd_fuyan",
				"swd_jiuyou",
				"swd_kama",
				"swd_linyue",
				"swd_maixing",
				"swd_nicole",
				"swd_rongshuang",
				"swd_weida",
				"swd_xiaohuanglong",
				"swd_xiyan",
				"swd_xuanyuanjiantong",
				"swd_yeyaxi",
				"swd_yuchiyanhong",
				"swd_yuli",
			],
			bp: [
				"diy_luxun",
				"diy_zhouyu",
				"diy_caiwenji",
				"diy_lukang",
				"diy_zhenji",
				"gjqt_hongyu",
				"gjqt_wenrenyu",
				"gjqt_yinqianshang",
				"gw_aokeweisite",
				"gw_feilafanruide",
				"gw_gaier",
				"gw_qigaiwang",
				"hs_anomalus",
				"hs_duyaxinshi",
				"hs_fengjianhuanfengzhe",
				"hs_finley",
				"hs_guldan",
				"hs_hallazeal",
				"hs_hemite",
				"hs_hudunren",
				"hs_huolituteng",
				"hs_jgarrosh",
				"hs_liadrin",
				"hs_loatheb",
				"hs_lreno",
				"hs_lrexxar",
				"hs_malfurion",
				"hs_nate",
				"hs_nozdormu",
				"hs_ruanniguai",
				"hs_selajin",
				"hs_shifazhe",
				"hs_tanghangu",
				"hs_tgolem",
				"hs_waleera",
				"hs_wuther",
				"hs_xuanzhuanjijia",
				"hs_xuefashi",
				"hs_yelise",
				"hs_zhouzhuo",
				"ow_heibaihe",
				"ow_luba",
				"ow_sishen",
				"ow_zhixuzhiguang",
				"pal_jiangcheng",
				"pal_jiangyunfan",
				"pal_leiyuange",
				"pal_longyou",
				"pal_shenqishuang",
				"pal_sumei",
				"pal_wangxiaohu",
				"pal_xiaoman",
				"swd_chunyuheng",
				"swd_fengtianling",
				"swd_haidapang",
				"swd_hanlong",
				"swd_hupo",
				"swd_huyue",
				"swd_jiangwu",
				"swd_jiangziya",
				"swd_jiting",
				"swd_lilian",
				"swd_moye",
				"swd_qiner",
				"swd_quxian",
				"swd_shangzhang",
				"swd_shaowei",
				"swd_situqiang",
				"swd_zhiyin",
				"swd_zhuoshanzhu",
				"swd_zidashu",
			],
			b: ["diy_sp_zhouyu", "hs_huzhixiannv", "hs_jiawodun", "hs_jinglinglong", "hs_shirencao", "hs_yelinchulong", "pal_linyueru", "swd_fu", "swd_hanluo", "swd_jialanduo", "swd_luchengxuan", "swd_youzhao", "swd_zhanggao"],
			bm: ["diy_caocao", "diy_weiyan"],
			c: ["diy_yuji"],
		};
		for (let i in rank) {
			lib.rank[i].addArray(rank[i]);
		}
		if (lib.rank.rarity) {
			const rarity = {
				legend: ["gjqt_aruan", "gw_jieluote", "gw_yenaifa", "gw_telisi", "gw_xili", "hs_neptulon", "hs_sthrall", "hs_malorne", "hs_medivh", "hs_pyros", "hs_siwangzhiyi", "hs_aya", "hs_kazhakusi", "hs_malygos", "hs_ysera", "old_majun", "pal_liumengli", "pal_yuntianhe", "swd_muyun", "swd_zhaoyun", "swd_septem", "swd_yuwentuo", "swd_duguningke", "swd_guyue", "swd_yuxiaoxue", "swd_huanglei", "swd_xuanyuanjianxian", "swd_qi", "swd_huzhongxian", "swd_murongshi", "swd_huiyan"],
				epic: ["diy_zhenji", "gjqt_fanglansheng", "gjqt_fengqingxue", "gjqt_xiayize", "gjqt_bailitusu", "gjqt_ouyangshaogong", "gjqt_xunfang", "gw_aisinie", "gw_falanxisika", "hs_tyrande", "hs_amala", "hs_alextrasza", "hs_totemic", "hs_bchillmaw", "hs_aedwin", "hs_antonidas", "hs_wvelen", "hs_alakir", "hs_xsylvanas", "hs_blingtron", "hs_fuding", "hs_lafamu", "hs_nozdormu", "hs_jiaziruila", "hs_yelise", "hs_xuefashi", "hs_liadrin", "ow_yuanshi", "ow_tianshi", "ow_zhixuzhiguang", "pal_yueqi", "pal_yuejinzhao", "pal_mingxiu", "pal_xuanxiao", "pal_zixuan", "pal_xuejian", "pal_murongziying", "pal_lixiaoyao", "pal_xingxuan", "swd_shuwaner", "swd_kendi", "swd_weida", "swd_lilian", "swd_jipeng", "swd_cheyun", "swd_tuobayuer", "swd_jiliang", "swd_muyue", "swd_lanyin", "swd_chenjingchou", "swd_kama", "swd_anka", "swd_huanyuanzhi", "swd_kangnalishi", "swd_zhiyin", "swd_xiarou", "swd_wangsiyue", "swd_qiner"],
				rare: [
					"diy_luxun",
					"diy_zhouyu",
					"diy_caiwenji",
					"diy_lukang",
					"gjqt_xiangling",
					"gjqt_yuewuyi",
					"gjqt_hongyu",
					"gw_yioufeisi",
					"gw_luoqi",
					"hs_selajin",
					"hs_enzoth",
					"hs_yashaji",
					"hs_yogg",
					"hs_kcthun",
					"hs_nate",
					"hs_anomalus",
					"hs_jinglinglong",
					"hs_alleria",
					"hs_lreno",
					"hs_zhouzhuo",
					"hs_loatheb",
					"hs_finley",
					"hs_xialikeer",
					"hs_sainaliusi",
					"hs_lrhonin",
					"hs_anduin",
					"hs_wuther",
					"hs_zhishigushu",
					"hs_jaina",
					"hs_malfurion",
					"hs_mijiaojisi",
					"hs_waleera",
					"hs_yngvar",
					"ow_falaozhiying",
					"ow_chanyata",
					"ow_liekong",
					"pal_shenqishuang",
					"pal_nangonghuang",
					"pal_wangpengxu",
					"pal_jingtian",
					"pal_changqing",
					"pal_zhaoliner",
					"pal_linyueru",
					"swd_xiyan",
					"swd_quxian",
					"swd_hengai",
					"swd_shuijing",
					"swd_sikongyu",
					"swd_shanxiaoxiao",
					"swd_linyue",
					"swd_xuanyuanjiantong",
					"swd_maixing",
					"swd_jiuyou",
					"swd_yuchiyanhong",
					"swd_duopeng",
					"swd_yuli",
					"swd_rongshuang",
					"swd_situqiang",
					"swd_chunyuheng",
					"swd_jiangziya",
					"swd_nicole",
					"swd_zhuoshanzhu",
					"swd_shaowei",
					"swd_jialanduo",
				],
				junk: ["diy_yuji"],
			};
			for (let i in rarity) {
				lib.rank.rarity[i].addArray(rarity[i]);
			}
		}
	}

	if (get.mode() === "stone") {
		// 炉石模式专属
		game.bannedcards?.addArray(["chuansongmen", "fengxueren", "guiyoujie", "jiguanshu", "lingjiandai", "sifeizhenmian"]);
		lib.character.stone_yisela = new Character({
			sex: "female",
			group: "qun",
			hp: 4,
			skills: ["stone_chenshui", "stonesha", "stoneshan", "stonedraw"],
			isMinskin: true,
			isFellowInStoneMode: true,
			isHiddenInStoneMode: true,
			trashBin: ["stonelegend"],
			extraModeData: [6, 2],
			img: "extension/炉石传说/image/character/hs_ysera.jpg",
		});
		lib.translate.stone_yisela = "伊瑟拉";
		lib.skill.stone_chenshui = {
			trigger: { player: "phaseEnd" },
			forced: true,
			content: function () {
				var list = ["hsmengjing_feicuiyoulong", "hsmengjing_huanxiaojiemei", "hsmengjing_suxing", "hsmengjing_mengye", "hsmengjing_mengjing"];
				var target = player.getLeader();
				target.gain(game.createCard(list.randomGet()));
				target.$draw();
				player.line(target, "green");
			},
			ai: {
				threaten: 2,
			},
		};
		lib.translate.stone_chenshui = "沉睡";
		lib.translate.stone_chenshui_info = "在你的结束阶段，令己方主将获得一张梦境牌。";
		const name = "stone_yisela_stonecharacter";
		lib.card[name] = {
			image: "extension/炉石传说/image/character/hs_ysera.jpg",
			stoneact: 6,
			career: null,
			stonehidden: true,
		};
		for (let i in lib.element.stonecharacter) {
			lib.card[name][i] = lib.element.stonecharacter[i];
		}
		lib.translate[name] = "伊瑟拉";
		lib.translate[name + "_info"] = get.skillintro("stone_yisela");
	}
}
