# Plan - マルチモデル協調計画

マルチモデル協調計画 - コンテキスト取得 + デュアルモデル分析 → ステップバイステップの実装計画を生成。

$ARGUMENTS

---

## コアプロトコル

- **言語プロトコル**: ツール/モデルとやり取りする際は**英語**を使用し、ユーザーとはユーザーの言語でコミュニケーション
- **必須並列**: Codex/Gemini呼び出しは`run_in_background: true`を使用する必要があります(単一モデル呼び出しも含む、メインスレッドのブロッキングを避けるため)
- **コード主権**: 外部モデルは**ファイルシステムへの書き込みアクセスがゼロ**、すべての変更はClaudeが実行
- **損失制限メカニズム**: 現在のフェーズの出力が検証されるまで次のフェーズに進まない
- **計画のみ**: このコマンドはコンテキストの読み取りと`.claude/plan/*`計画ファイルへの書き込みを許可しますが、**本番コードを変更しない**

---

## マルチモデル呼び出し仕様

**呼び出し構文**(並列: `run_in_background: true`を使用):

```
Bash({
  command: "~/.claude/bin/codeagent-wrapper {{LITE_MODE_FLAG}}--backend <codex|gemini> {{GEMINI_MODEL_FLAG}}- \"$PWD\" <<'EOF'
ROLE_FILE: <ロールプロンプトパス>
<TASK>
Requirement: <強化された要件>
Context: <取得したプロジェクトコンテキスト>
</TASK>
OUTPUT: 疑似コードを含むステップバイステップの実装計画。ファイルを変更しない。
EOF",
  run_in_background: true,
  timeout: 3600000,
  description: "簡潔な説明"
})
```

**モデルパラメータの注意事項**:
- `{{GEMINI_MODEL_FLAG}}`: `--backend gemini`を使用する場合、`--gemini-model gemini-3-pro-preview`で置き換える(末尾のスペースに注意); codexの場合は空文字列を使用

**ロールプロンプト**:

| フェーズ | Codex | Gemini |
|-------|-------|--------|
| 分析 | `~/.claude/.ccg/prompts/codex/analyzer.md` | `~/.claude/.ccg/prompts/gemini/analyzer.md` |
| 計画 | `~/.claude/.ccg/prompts/codex/architect.md` | `~/.claude/.ccg/prompts/gemini/architect.md` |

**セッション再利用**: 各呼び出しは`SESSION_ID: xxx`を返します(通常ラッパーによって出力される)、**保存する必要があります**後続の`/ccg:execute`使用のため。

**バックグラウンドタスクの待機**(最大タイムアウト600000ms = 10分):

```
TaskOutput({ task_id: "<task_id>", block: true, timeout: 600000 })
```

**重要**:
- `timeout: 600000`を指定する必要があります。指定しないとデフォルトの30秒で早期タイムアウトが発生します
- 10分後もまだ完了していない場合、`TaskOutput`でポーリングを継続し、**プロセスを強制終了しない**
- タイムアウトにより待機がスキップされた場合、**`AskUserQuestion`を呼び出してユーザーに待機を継続するか、タスクを強制終了するかを尋ねる必要があります**

---

## 実行ワークフロー

**計画タスク**: $ARGUMENTS

### フェーズ 1: 完全なコンテキスト取得

`[Mode: Research]`

#### 1.1 プロンプト強化(最初に実行する必要があります)

**`mcp__ace-tool__enhance_prompt`ツールを呼び出す必要があります**:

```
mcp__ace-tool__enhance_prompt({
  prompt: "$ARGUMENTS",
  conversation_history: "<直近5-10の会話ターン>",
  project_root_path: "$PWD"
})
```

強化されたプロンプトを待ち、**後続のすべてのフェーズのために元の$ARGUMENTSを強化結果で置き換える**。

#### 1.2 コンテキスト取得

**`mcp__ace-tool__search_context`ツールを呼び出す**:

```
mcp__ace-tool__search_context({
  query: "<強化された要件に基づくセマンティッククエリ>",
  project_root_path: "$PWD"
})
```

- 自然言語を使用してセマンティッククエリを構築(Where/What/How)
- **仮定に基づいて回答しない**
- MCPが利用できない場合: Glob + Grepにフォールバックしてファイル検出とキーシンボル位置を特定

#### 1.3 完全性チェック

- 関連するクラス、関数、変数の**完全な定義とシグネチャ**を取得する必要がある
- コンテキストが不十分な場合、**再帰的取得**をトリガー
- 出力を優先: エントリファイル + 行番号 + キーシンボル名; 曖昧さを解決するために必要な場合のみ最小限のコードスニペットを追加

#### 1.4 要件の整合性

- 要件にまだ曖昧さがある場合、**必ず**ユーザーに誘導質問を出力
- 要件の境界が明確になるまで(欠落なし、冗長性なし)

### フェーズ 2: マルチモデル協調分析

`[Mode: Analysis]`

#### 2.1 入力の配分

**CodexとGeminiを並列呼び出し**(`run_in_background: true`):

**元の要件**(事前設定された意見なし)を両方のモデルに配分:

1. **Codexバックエンド分析**:
   - ROLE_FILE: `~/.claude/.ccg/prompts/codex/analyzer.md`
   - フォーカス: 技術的な実現可能性、アーキテクチャへの影響、パフォーマンスの考慮事項、潜在的なリスク
   - OUTPUT: 多角的なソリューション + 長所/短所の分析

2. **Geminiフロントエンド分析**:
   - ROLE_FILE: `~/.claude/.ccg/prompts/gemini/analyzer.md`
   - フォーカス: UI/UXへの影響、ユーザーエクスペリエンス、ビジュアルデザイン
   - OUTPUT: 多角的なソリューション + 長所/短所の分析

`TaskOutput`で両方のモデルの完全な結果を待ちます。**SESSION_ID**(`CODEX_SESSION`と`GEMINI_SESSION`)を保存します。

#### 2.2 クロスバリデーション

視点を統合し、最適化のために反復:

1. **合意を特定**(強いシグナル)
2. **相違を特定**(重み付けが必要)
3. **補完的な強み**: バックエンドロジックはCodexに従い、フロントエンドデザインはGeminiに従う
4. **論理的推論**: ソリューションの論理的なギャップを排除

#### 2.3 (オプションだが推奨) デュアルモデル計画ドラフト

Claudeの統合計画での欠落リスクを減らすために、両方のモデルに並列で「計画ドラフト」を出力させることができます(ただし、ファイルを変更することは**許可されていません**):

1. **Codex計画ドラフト**(バックエンド権威):
   - ROLE_FILE: `~/.claude/.ccg/prompts/codex/architect.md`
   - OUTPUT: ステップバイステップの計画 + 疑似コード(フォーカス: データフロー/エッジケース/エラーハンドリング/テスト戦略)

2. **Gemini計画ドラフト**(フロントエンド権威):
   - ROLE_FILE: `~/.claude/.ccg/prompts/gemini/architect.md`
   - OUTPUT: ステップバイステップの計画 + 疑似コード(フォーカス: 情報アーキテクチャ/インタラクション/アクセシビリティ/ビジュアル一貫性)

`TaskOutput`で両方のモデルの完全な結果を待ち、提案の主要な相違点を記録します。

#### 2.4 実装計画の生成(Claude最終バージョン)

両方の分析を統合し、**ステップバイステップの実装計画**を生成:

```markdown
## 実装計画: <タスク名>

### タスクタイプ
- [ ] フロントエンド(→ Gemini)
- [ ] バックエンド(→ Codex)
- [ ] フルスタック(→ 並列)

### 技術的ソリューション
<Codex + Gemini分析から統合された最適なソリューション>

### 実装ステップ
1. <ステップ1> - 期待される成果物
2. <ステップ2> - 期待される成果物
...

### キーファイル
| ファイル | 操作 | 説明 |
|------|-----------|-------------|
| path/to/file.ts:L10-L50 | 変更 | 説明 |

### リスクと緩和策
| リスク | 緩和策 |
|------|------------|

### SESSION_ID(/ccg:execute使用のため)
- CODEX_SESSION: <session_id>
- GEMINI_SESSION: <session_id>
```

### フェーズ 2 終了: 計画の配信(実装ではない)

**`/ccg:plan`の責任はここで終了します。以下のアクションを実行する必要があります**:

1. 完全な実装計画をユーザーに提示(疑似コードを含む)
2. 計画を`.claude/plan/<feature-name>.md`に保存(要件から機能名を抽出、例: `user-auth`、`payment-module`)
3. **太字テキスト**でプロンプトを出力(**保存された実際のファイルパスを使用する必要があります**):

   ---
   **計画が生成され、`.claude/plan/actual-feature-name.md`に保存されました**

   **上記の計画をレビューしてください。以下のことができます:**
   - **計画を変更**: 調整が必要なことを教えてください、計画を更新します
   - **計画を実行**: 以下のコマンドを新しいセッションにコピー

   ```
   /ccg:execute .claude/plan/actual-feature-name.md
   ```
   ---

   **注意**: 上記の`actual-feature-name.md`は実際に保存されたファイル名で置き換える必要があります!

4. **現在のレスポンスを直ちに終了**(ここで停止。これ以上のツール呼び出しはありません。)

**絶対に禁止**:
- ユーザーに「Y/N」を尋ねてから自動実行(実行は`/ccg:execute`の責任)
- 本番コードへの書き込み操作
- `/ccg:execute`または任意の実装アクションを自動的に呼び出す
- ユーザーが明示的に変更を要求していない場合にモデル呼び出しを継続してトリガー

---

## 計画の保存

計画が完了した後、計画を以下に保存:

- **最初の計画**: `.claude/plan/<feature-name>.md`
- **反復バージョン**: `.claude/plan/<feature-name>-v2.md`、`.claude/plan/<feature-name>-v3.md`...

計画ファイルの書き込みは、計画をユーザーに提示する前に完了する必要があります。

---

## 計画変更フロー

ユーザーが計画の変更を要求した場合:

1. ユーザーフィードバックに基づいて計画内容を調整
2. `.claude/plan/<feature-name>.md`ファイルを更新
3. 変更された計画を再提示
4. ユーザーにレビューまたは実行を再度促す

---

## 次のステップ

ユーザーが承認した後、**手動で**実行:

```bash
/ccg:execute .claude/plan/<feature-name>.md
```

---

## 重要なルール

1. **計画のみ、実装なし** – このコマンドはコード変更を実行しません
2. **Y/Nプロンプトなし** – 計画を提示するだけで、ユーザーが次のステップを決定します
3. **信頼ルール** – バックエンドはCodexに従い、フロントエンドはGeminiに従う
4. 外部モデルは**ファイルシステムへの書き込みアクセスがゼロ**
5. **SESSION_IDの引き継ぎ** – 計画には最後に`CODEX_SESSION` / `GEMINI_SESSION`を含める必要があります(`/ccg:execute resume <SESSION_ID>`使用のため)
