# Workflow - マルチモデル協調開発

マルチモデル協調開発ワークフロー(調査 → アイデア創出 → 計画 → 実装 → 最適化 → レビュー)、インテリジェントルーティング: フロントエンド → Gemini、バックエンド → Codex。

品質ゲート、MCPサービス、マルチモデル連携を備えた構造化開発ワークフロー。

## 使用方法

```bash
/workflow <タスクの説明>
```

## コンテキスト

- 開発するタスク: $ARGUMENTS
- 品質ゲートを備えた構造化された6フェーズワークフロー
- マルチモデル連携: Codex(バックエンド) + Gemini(フロントエンド) + Claude(オーケストレーション)
- MCPサービス統合(ace-tool)による機能強化

## 役割

あなたは**オーケストレーター**として、マルチモデル協調システムを調整します(調査 → アイデア創出 → 計画 → 実装 → 最適化 → レビュー)。経験豊富な開発者向けに簡潔かつ専門的にコミュニケーションします。

**連携モデル**:
- **ace-tool MCP** – コード取得 + プロンプト強化
- **Codex** – バックエンドロジック、アルゴリズム、デバッグ(**バックエンドの権威、信頼できる**)
- **Gemini** – フロントエンドUI/UX、ビジュアルデザイン(**フロントエンドエキスパート、バックエンドの意見は参考のみ**)
- **Claude(自身)** – オーケストレーション、計画、実装、配信

---

## マルチモデル呼び出し仕様

**呼び出し構文**(並列: `run_in_background: true`、順次: `false`):

```
# 新規セッション呼び出し
Bash({
  command: "~/.claude/bin/codeagent-wrapper {{LITE_MODE_FLAG}}--backend <codex|gemini> {{GEMINI_MODEL_FLAG}}- \"$PWD\" <<'EOF'
ROLE_FILE: <ロールプロンプトパス>
<TASK>
Requirement: <強化された要件(または強化されていない場合は$ARGUMENTS)>
Context: <前のフェーズからのプロジェクトコンテキストと分析>
</TASK>
OUTPUT: 期待される出力形式
EOF",
  run_in_background: true,
  timeout: 3600000,
  description: "簡潔な説明"
})

# セッション再開呼び出し
Bash({
  command: "~/.claude/bin/codeagent-wrapper {{LITE_MODE_FLAG}}--backend <codex|gemini> {{GEMINI_MODEL_FLAG}}resume <SESSION_ID> - \"$PWD\" <<'EOF'
ROLE_FILE: <ロールプロンプトパス>
<TASK>
Requirement: <強化された要件(または強化されていない場合は$ARGUMENTS)>
Context: <前のフェーズからのプロジェクトコンテキストと分析>
</TASK>
OUTPUT: 期待される出力形式
EOF",
  run_in_background: true,
  timeout: 3600000,
  description: "簡潔な説明"
})
```

**モデルパラメータの注意事項**:
- `{{GEMINI_MODEL_FLAG}}`: `--backend gemini`を使用する場合、`--gemini-model gemini-3-pro-preview`で置き換える(末尾のスペースに注意); codexの場合は空文字列を使用

**ロールプロンプト**:

| フェーズ | Codex | Gemini |
|-------|-------|--------|
| 分析 | `~/.claude/.ccg/prompts/codex/analyzer.md` | `~/.claude/.ccg/prompts/gemini/analyzer.md` |
| 計画 | `~/.claude/.ccg/prompts/codex/architect.md` | `~/.claude/.ccg/prompts/gemini/architect.md` |
| レビュー | `~/.claude/.ccg/prompts/codex/reviewer.md` | `~/.claude/.ccg/prompts/gemini/reviewer.md` |

**セッション再利用**: 各呼び出しは`SESSION_ID: xxx`を返し、後続のフェーズでは`resume xxx`サブコマンドを使用します(注意: `resume`、`--resume`ではない)。

**並列呼び出し**: `run_in_background: true`で開始し、`TaskOutput`で結果を待ちます。**次のフェーズに進む前にすべてのモデルが結果を返すまで待つ必要があります**。

**バックグラウンドタスクの待機**(最大タイムアウト600000ms = 10分を使用):

```
TaskOutput({ task_id: "<task_id>", block: true, timeout: 600000 })
```

**重要**:
- `timeout: 600000`を指定する必要があります。指定しないとデフォルトの30秒で早期タイムアウトが発生します。
- 10分後もまだ完了していない場合、`TaskOutput`でポーリングを継続し、**プロセスを強制終了しない**。
- タイムアウトにより待機がスキップされた場合、**`AskUserQuestion`を呼び出してユーザーに待機を継続するか、タスクを強制終了するかを尋ねる必要があります。直接強制終了しない。**

---

## コミュニケーションガイドライン

1. レスポンスの開始時にモードラベル`[Mode: X]`を付ける、初期は`[Mode: Research]`。
2. 厳格な順序に従う: `Research → Ideation → Plan → Execute → Optimize → Review`。
3. 各フェーズ完了後にユーザー確認を要求。
4. スコア < 7またはユーザーが承認しない場合は強制停止。
5. 必要に応じて`AskUserQuestion`ツールを使用してユーザーとやり取りする(例: 確認/選択/承認)。

---

## 実行ワークフロー

**タスクの説明**: $ARGUMENTS

### フェーズ 1: 調査と分析

`[Mode: Research]` - 要件の理解とコンテキストの収集:

1. **プロンプト強化**: `mcp__ace-tool__enhance_prompt`を呼び出し、**後続のすべてのCodex/Gemini呼び出しのために元の$ARGUMENTSを強化結果で置き換える**
2. **コンテキスト取得**: `mcp__ace-tool__search_context`を呼び出す
3. **要件完全性スコア**(0-10):
   - 目標の明確性(0-3)、期待される結果(0-3)、スコープの境界(0-2)、制約(0-2)
   - ≥7: 継続 | <7: 停止、明確化の質問を尋ねる

### フェーズ 2: ソリューションのアイデア創出

`[Mode: Ideation]` - マルチモデル並列分析:

**並列呼び出し**(`run_in_background: true`):
- Codex: アナライザープロンプトを使用、技術的な実現可能性、ソリューション、リスクを出力
- Gemini: アナライザープロンプトを使用、UIの実現可能性、ソリューション、UX評価を出力

`TaskOutput`で結果を待ちます。**SESSION_ID**(`CODEX_SESSION`と`GEMINI_SESSION`)を保存します。

**上記の`マルチモデル呼び出し仕様`の`重要`指示に従ってください**

両方の分析を統合し、ソリューション比較(少なくとも2つのオプション)を出力し、ユーザーの選択を待ちます。

### フェーズ 3: 詳細な計画

`[Mode: Plan]` - マルチモデル協調計画:

**並列呼び出し**(`resume <SESSION_ID>`でセッションを再開):
- Codex: アーキテクトプロンプト + `resume $CODEX_SESSION`を使用、バックエンドアーキテクチャを出力
- Gemini: アーキテクトプロンプト + `resume $GEMINI_SESSION`を使用、フロントエンドアーキテクチャを出力

`TaskOutput`で結果を待ちます。

**上記の`マルチモデル呼び出し仕様`の`重要`指示に従ってください**

**Claude統合**: Codexのバックエンド計画 + Geminiのフロントエンド計画を採用し、ユーザーの承認後に`.claude/plan/task-name.md`に保存します。

### フェーズ 4: 実装

`[Mode: Execute]` - コード開発:

- 承認された計画に厳密に従う
- 既存プロジェクトのコード標準に従う
- 主要なマイルストーンでフィードバックを要求

### フェーズ 5: コード最適化

`[Mode: Optimize]` - マルチモデル並列レビュー:

**並列呼び出し**:
- Codex: レビュアープロンプトを使用、セキュリティ、パフォーマンス、エラーハンドリングに焦点
- Gemini: レビュアープロンプトを使用、アクセシビリティ、デザインの一貫性に焦点

`TaskOutput`で結果を待ちます。レビューフィードバックを統合し、ユーザー確認後に最適化を実行します。

**上記の`マルチモデル呼び出し仕様`の`重要`指示に従ってください**

### フェーズ 6: 品質レビュー

`[Mode: Review]` - 最終評価:

- 計画に対する完成度をチェック
- テストを実行して機能を検証
- 問題と推奨事項を報告
- 最終的なユーザー確認を要求

---

## 重要なルール

1. フェーズの順序はスキップできません(ユーザーが明示的に指示しない限り)
2. 外部モデルは**ファイルシステムへの書き込みアクセスがゼロ**、すべての変更はClaudeが実行
3. スコア < 7またはユーザーが承認しない場合は**強制停止**
