# 検証コマンド

現在のコードベースの状態に対して包括的な検証を実行します。

## 手順

この正確な順序で検証を実行してください:

1. **ビルドチェック**
   - このプロジェクトのビルドコマンドを実行
   - 失敗した場合、エラーを報告して**停止**

2. **型チェック**
   - TypeScript/型チェッカーを実行
   - すべてのエラーをファイル:行番号とともに報告

3. **Lintチェック**
   - Linterを実行
   - 警告とエラーを報告

4. **テストスイート**
   - すべてのテストを実行
   - 合格/不合格の数を報告
   - カバレッジのパーセンテージを報告

5. **Console.log監査**
   - ソースファイルでconsole.logを検索
   - 場所を報告

6. **Git状態**
   - コミットされていない変更を表示
   - 最後のコミット以降に変更されたファイルを表示

## 出力

簡潔な検証レポートを生成します:

```
VERIFICATION: [PASS/FAIL]

Build:    [OK/FAIL]
Types:    [OK/X errors]
Lint:     [OK/X issues]
Tests:    [X/Y passed, Z% coverage]
Secrets:  [OK/X found]
Logs:     [OK/X console.logs]

Ready for PR: [YES/NO]
```

重大な問題がある場合は、修正案とともにリストアップします。

## 引数

$ARGUMENTS は以下のいずれか:
- `quick` - ビルド + 型チェックのみ
- `full` - すべてのチェック（デフォルト）
- `pre-commit` - コミットに関連するチェック
- `pre-pr` - 完全なチェック + セキュリティスキャン
