# コーディングスタイル

## 不変性（重要）

常に新しいオブジェクトを作成し、既存のものを変更しないでください:

```
// 疑似コード
誤り:  modify(original, field, value) → original をその場で変更
正解: update(original, field, value) → 変更を加えた新しいコピーを返す
```

理由: 不変データは隠れた副作用を防ぎ、デバッグを容易にし、安全な並行処理を可能にします。

## ファイル構成

多数の小さなファイル > 少数の大きなファイル:
- 高い凝集性、低い結合性
- 通常 200-400 行、最大 800 行
- 大きなモジュールからユーティリティを抽出
- 型ではなく、機能/ドメインごとに整理

## エラーハンドリング

常に包括的にエラーを処理してください:
- すべてのレベルでエラーを明示的に処理
- UI 向けコードではユーザーフレンドリーなエラーメッセージを提供
- サーバー側では詳細なエラーコンテキストをログに記録
- エラーを黙って無視しない

## 入力検証

常にシステム境界で検証してください:
- 処理前にすべてのユーザー入力を検証
- 可能な場合はスキーマベースの検証を使用
- 明確なエラーメッセージで早期に失敗
- 外部データ（API レスポンス、ユーザー入力、ファイルコンテンツ）を決して信頼しない

## コード品質チェックリスト

作業を完了とマークする前に:
- [ ] コードが読みやすく、適切に命名されている
- [ ] 関数が小さい（50 行未満）
- [ ] ファイルが焦点を絞っている（800 行未満）
- [ ] 深いネストがない（4 レベル以下）
- [ ] 適切なエラーハンドリング
- [ ] ハードコードされた値がない（定数または設定を使用）
- [ ] 変更がない（不変パターンを使用）
