# 代码审查

对未提交的更改进行全面的安全性和质量审查：

1. 获取更改的文件：`git diff --name-only HEAD`

2. 对每个更改的文件，检查：

**安全问题（严重）：**

* 硬编码的凭据、API 密钥、令牌
* SQL 注入漏洞
* XSS 漏洞
* 缺少输入验证
* 不安全的依赖项
* 路径遍历风险

**代码质量（高）：**

* 函数长度超过 50 行
* 文件长度超过 800 行
* 嵌套深度超过 4 层
* 缺少错误处理
* `console.log` 语句
* `TODO`/`FIXME` 注释
* 公共 API 缺少 JSDoc

**最佳实践（中）：**

* 可变模式（应使用不可变模式）
* 代码/注释中使用表情符号
* 新代码缺少测试
* 无障碍性问题（a11y）

3. 生成报告，包含：
   * 严重性：严重、高、中、低
   * 文件位置和行号
   * 问题描述
   * 建议的修复方法

4. 如果发现严重或高优先级问题，则阻止提交

绝不允许包含安全漏洞的代码！
