# 性能优化

## 模型选择策略

**Haiku 4.5** (具备 Sonnet 90% 的能力，节省 3 倍成本):

* 频繁调用的轻量级智能体
* 结对编程和代码生成
* 多智能体系统中的工作智能体

**Sonnet 4.5** (最佳编码模型):

* 主要的开发工作
* 编排多智能体工作流
* 复杂的编码任务

**Opus 4.5** (最深的推理能力):

* 复杂的架构决策
* 最高级别的推理需求
* 研究和分析任务

## 上下文窗口管理

避免使用上下文窗口的最后 20% 进行:

* 大规模重构
* 跨多个文件的功能实现
* 调试复杂的交互

上下文敏感性较低的任务:

* 单文件编辑
* 创建独立的实用工具
* 文档更新
* 简单的错误修复

## 扩展思考 + 计划模式

扩展思考默认启用，最多保留 31,999 个令牌用于内部推理。

通过以下方式控制扩展思考：

* **切换**：Option+T (macOS) / Alt+T (Windows/Linux)
* **配置**：在 `~/.claude/settings.json` 中设置 `alwaysThinkingEnabled`
* **预算上限**：`export MAX_THINKING_TOKENS=10000`
* **详细模式**：Ctrl+O 查看思考输出

对于需要深度推理的复杂任务:

1. 确保扩展思考已启用（默认开启）
2. 启用 **计划模式** 以获得结构化方法
3. 使用多轮批判进行彻底分析
4. 使用分割角色子代理以获得多元视角

## 构建故障排除

如果构建失败:

1. 使用 **build-error-resolver** 智能体
2. 分析错误信息
3. 逐步修复
4. 每次修复后进行验证
