---
name: eval-harness
description: 克劳德代码会话的正式评估框架，实施评估驱动开发（EDD）原则
tools: Read, Write, Edit, Bash, Grep, Glob
---

# Eval Harness 技能

一个用于 Claude Code 会话的正式评估框架，实现了评估驱动开发 (EDD) 原则。

## 理念

评估驱动开发将评估视为 "AI 开发的单元测试"：

* 在实现 **之前** 定义预期行为
* 在开发过程中持续运行评估
* 跟踪每次更改的回归情况
* 使用 pass@k 指标来衡量可靠性

## 评估类型

### 能力评估

测试 Claude 是否能完成之前无法完成的事情：

```markdown
[能力评估：功能名称]
任务：描述 Claude 应完成的工作
成功标准：
  - [ ] 标准 1
  - [ ] 标准 2
  - [ ] 标准 标准 3
预期输出：对预期结果的描述

```

### 回归评估

确保更改不会破坏现有功能：

```markdown
[回归评估：功能名称]
基线：SHA 或检查点名称
测试：
  - 现有测试-1：通过/失败
  - 现有测试-2：通过/失败
  - 现有测试-3：通过/失败
结果：X/Y 通过（之前为 Y/Y）

```

## 评分器类型

### 1. 基于代码的评分器

使用代码进行确定性检查：

```bash
# Check if file contains expected pattern
grep -q "export function handleAuth" src/auth.ts && echo "PASS" || echo "FAIL"

# Check if tests pass
npm test -- --testPathPattern="auth" && echo "PASS" || echo "FAIL"

# Check if build succeeds
npm run build && echo "PASS" || echo "FAIL"
```

### 2. 基于模型的评分器

使用 Claude 来评估开放式输出：

```markdown
[MODEL GRADER PROMPT]
评估以下代码变更：
1. 它是否解决了所述问题？
2. 它的结构是否良好？
3. 是否处理了边界情况？
4. 错误处理是否恰当？

评分：1-5 (1=差，5=优秀)
推理：[解释]

```

### 3. 人工评分器

标记为需要手动审查：

```markdown
[HUMAN REVIEW REQUIRED]
变更：对更改内容的描述
原因：为何需要人工审核
风险等级：低/中/高

```

## 指标

### pass@k

"k 次尝试中至少成功一次"

* pass@1：首次尝试成功率
* pass@3：3 次尝试内成功率
* 典型目标：pass@3 > 90%

### pass^k

"所有 k 次试验都成功"

* 更高的可靠性门槛
* pass^3：连续 3 次成功
* 用于关键路径

## 评估工作流程

### 1. 定义（编码前）

```markdown
## 评估定义：功能-xyz

### 能力评估
1. 可以创建新用户账户
2. 可以验证电子邮件格式
3. 可以安全地哈希密码

### 回归评估
1. 现有登录功能仍然有效
2. 会话管理未改变
3. 注销流程完整

### 成功指标
- 能力评估的 pass@3 > 90%
- 回归评估的 pass^3 = 100%

```

### 2. 实现

编写代码以通过已定义的评估。

### 3. 评估

```bash
# Run capability evals
[Run each capability eval, record PASS/FAIL]

# Run regression evals
npm test -- --testPathPattern="existing"

# Generate report
```

### 4. 报告

```markdown
评估报告：功能-xyz
========================

能力评估：
  创建用户：    通过（通过@1）
  验证邮箱：    通过（通过@2）
  哈希密码：    通过（通过@1）
  总计：         3/3 通过

回归评估：
  登录流程：     通过
  会话管理：     通过
  登出流程：     通过
  总计：         3/3 通过

指标：
  通过@1： 67% (2/3)
  通过@3： 100% (3/3)

状态：准备就绪，待审核

```

## 集成模式

### 实施前

```
/eval define feature-name
```

在 `.claude/evals/feature-name.md` 处创建评估定义文件

### 实施过程中

```
/eval check feature-name
```

运行当前评估并报告状态

### 实施后

```
/eval report feature-name
```

生成完整的评估报告

## 评估存储

将评估存储在项目中：

```
.claude/
  evals/
    feature-xyz.md      # Eval definition
    feature-xyz.log     # Eval run history
    baseline.json       # Regression baselines
```

## 最佳实践

1. **在编码前定义评估** - 强制清晰地思考成功标准
2. **频繁运行评估** - 及早发现回归问题
3. **随时间跟踪 pass@k** - 监控可靠性趋势
4. **尽可能使用代码评分器** - 确定性 > 概率性
5. **对安全性进行人工审查** - 永远不要完全自动化安全检查
6. **保持评估快速** - 缓慢的评估不会被运行
7. **评估与代码版本化** - 评估是一等工件

## 示例：添加身份验证

```markdown
## EVAL：添加身份验证

### 第 1 阶段：定义 (10 分钟)
能力评估：
- [ ] 用户可以使用邮箱/密码注册
- [ ] 用户可以使用有效凭证登录
- [ ] 无效凭证被拒绝并显示适当的错误
- [ ] 会话在页面重新加载后保持
- [ ] 登出操作清除会话

回归评估：
- [ ] 公共路由仍可访问
- [ ] API 响应未改变
- [ ] 数据库模式兼容

### 第 2 阶段：实施 (时间不定)
[编写代码]

### 第 3 阶段：评估
运行：/eval check add-authentication

### 第 4 阶段：报告
评估报告：添加身份验证
==============================
能力：5/5 通过 (pass@3: 100%)
回归：3/3 通过 (pass^3: 100%)
状态：可以发布

```
