---
name: strategic-compact
description: 建议在逻辑间隔处进行手动上下文压缩，以在任务阶段中保留上下文，而非任意的自动压缩。
---

# 战略精简技能

建议在你的工作流程中的战略节点手动执行 `/compact`，而不是依赖任意的自动精简。

## 为何采用战略精简？

自动精简会在任意时间点触发：

* 通常在任务中途，丢失重要上下文
* 无法感知逻辑任务边界
* 可能中断复杂的多步骤操作

在逻辑边界进行战略精简：

* **探索之后，执行之前** - 精简研究上下文，保留实施计划
* **完成一个里程碑之后** - 为下一阶段全新开始
* **主要上下文切换之前** - 在不同任务开始前清理探索上下文

## 工作原理

`suggest-compact.sh` 脚本在 PreToolUse（编辑/写入）时运行并执行：

1. **追踪工具调用** - 计算会话中的工具调用次数
2. **阈值检测** - 在可配置的阈值（默认：50 次调用）处建议精简
3. **定期提醒** - 在达到阈值后，每 25 次调用提醒一次

## 钩子设置

添加到你的 `~/.claude/settings.json`：

```json
{
  "hooks": {
    "PreToolUse": [{
      "matcher": "tool == \"Edit\" || tool == \"Write\"",
      "hooks": [{
        "type": "command",
        "command": "~/.claude/skills/strategic-compact/suggest-compact.sh"
      }]
    }]
  }
}
```

## 配置

环境变量：

* `COMPACT_THRESHOLD` - 首次建议前的工具调用次数（默认：50）

## 最佳实践

1. **规划后精简** - 一旦计划确定，精简以全新开始
2. **调试后精简** - 在继续之前，清理错误解决上下文
3. **不要在实施中途精简** - 保留相关更改的上下文
4. **阅读建议** - 钩子告诉你*何时*，由你决定*是否*

## 相关

* [长篇指南](https://x.com/affaanmustafa/status/2014040193557471352) - 令牌优化部分
* 内存持久化钩子 - 用于在精简后保留的状态
