# 術語對照表 (Terminology Glossary)

本文件記錄繁體中文翻譯的術語對照，確保翻譯一致性。

## 狀態說明

- **已確認 (Confirmed)**: 經使用者確認的翻譯
- **待確認 (Pending)**: 待使用者審核的翻譯

---

## 術語表

| English | zh-TW | 狀態 | 備註 |
|---------|-------|------|------|
| Agent | Agent | 已確認 | 保留英文 |
| Hook | Hook | 已確認 | 保留英文 |
| Plugin | 外掛 | 已確認 | 台灣慣用 |
| Token | Token | 已確認 | 保留英文 |
| Skill | 技能 | 待確認 | |
| Command | 指令 | 待確認 | |
| Rule | 規則 | 待確認 | |
| TDD (Test-Driven Development) | TDD（測試驅動開發） | 待確認 | 首次使用展開 |
| E2E (End-to-End) | E2E（端對端） | 待確認 | 首次使用展開 |
| API | API | 待確認 | 保留英文 |
| CLI | CLI | 待確認 | 保留英文 |
| IDE | IDE | 待確認 | 保留英文 |
| MCP (Model Context Protocol) | MCP | 待確認 | 保留英文 |
| Workflow | 工作流程 | 待確認 | |
| Codebase | 程式碼庫 | 待確認 | |
| Coverage | 覆蓋率 | 待確認 | |
| Build | 建置 | 待確認 | |
| Debug | 除錯 | 待確認 | |
| Deploy | 部署 | 待確認 | |
| Commit | Commit | 待確認 | Git 術語保留英文 |
| PR (Pull Request) | PR | 待確認 | 保留英文 |
| Branch | 分支 | 待確認 | |
| Merge | 合併 | 待確認 | |
| Repository | 儲存庫 | 待確認 | |
| Fork | Fork | 待確認 | 保留英文 |
| Supabase | Supabase | - | 產品名稱保留 |
| Redis | Redis | - | 產品名稱保留 |
| Playwright | Playwright | - | 產品名稱保留 |
| TypeScript | TypeScript | - | 語言名稱保留 |
| JavaScript | JavaScript | - | 語言名稱保留 |
| Go/Golang | Go | - | 語言名稱保留 |
| React | React | - | 框架名稱保留 |
| Next.js | Next.js | - | 框架名稱保留 |
| PostgreSQL | PostgreSQL | - | 產品名稱保留 |
| RLS (Row Level Security) | RLS（列層級安全性） | 待確認 | 首次使用展開 |
| OWASP | OWASP | - | 保留英文 |
| XSS | XSS | - | 保留英文 |
| SQL Injection | SQL 注入 | 待確認 | |
| CSRF | CSRF | - | 保留英文 |
| Refactor | 重構 | 待確認 | |
| Dead Code | 無用程式碼 | 待確認 | |
| Lint/Linter | Lint | 待確認 | 保留英文 |
| Code Review | 程式碼審查 | 待確認 | |
| Security Review | 安全性審查 | 待確認 | |
| Best Practices | 最佳實務 | 待確認 | |
| Edge Case | 邊界情況 | 待確認 | |
| Happy Path | 正常流程 | 待確認 | |
| Fallback | 備援方案 | 待確認 | |
| Cache | 快取 | 待確認 | |
| Queue | 佇列 | 待確認 | |
| Pagination | 分頁 | 待確認 | |
| Cursor | 游標 | 待確認 | |
| Index | 索引 | 待確認 | |
| Schema | 結構描述 | 待確認 | |
| Migration | 遷移 | 待確認 | |
| Transaction | 交易 | 待確認 | |
| Concurrency | 並行 | 待確認 | |
| Goroutine | Goroutine | - | Go 術語保留 |
| Channel | Channel | 待確認 | Go context 可保留 |
| Mutex | Mutex | - | 保留英文 |
| Interface | 介面 | 待確認 | |
| Struct | Struct | - | Go 術語保留 |
| Mock | Mock | 待確認 | 測試術語可保留 |
| Stub | Stub | 待確認 | 測試術語可保留 |
| Fixture | Fixture | 待確認 | 測試術語可保留 |
| Assertion | 斷言 | 待確認 | |
| Snapshot | 快照 | 待確認 | |
| Trace | 追蹤 | 待確認 | |
| Artifact | 產出物 | 待確認 | |
| CI/CD | CI/CD | - | 保留英文 |
| Pipeline | 管線 | 待確認 | |

---

## 翻譯原則

1. **產品名稱**：保留英文（Supabase, Redis, Playwright）
2. **程式語言**：保留英文（TypeScript, Go, JavaScript）
3. **框架名稱**：保留英文（React, Next.js, Vue）
4. **技術縮寫**：保留英文（API, CLI, IDE, MCP, TDD, E2E）
5. **Git 術語**：大多保留英文（commit, PR, fork）
6. **程式碼內容**：不翻譯（變數名、函式名、註解保持原樣，但說明性註解可翻譯）
7. **首次出現**：縮寫首次出現時展開說明

---

## 更新記錄

- 2024-XX-XX: 初版建立，含使用者已確認術語
