# 程式碼審查

對未提交變更進行全面的安全性和品質審查：

1. 取得變更的檔案：git diff --name-only HEAD

2. 對每個變更的檔案，檢查：

**安全性問題（關鍵）：**
- 寫死的憑證、API 金鑰、Token
- SQL 注入弱點
- XSS 弱點
- 缺少輸入驗證
- 不安全的相依性
- 路徑遍歷風險

**程式碼品質（高）：**
- 函式 > 50 行
- 檔案 > 800 行
- 巢狀深度 > 4 層
- 缺少錯誤處理
- console.log 陳述式
- TODO/FIXME 註解
- 公開 API 缺少 JSDoc

**最佳實務（中）：**
- 變異模式（應使用不可變）
- 程式碼/註解中使用表情符號
- 新程式碼缺少測試
- 無障礙問題（a11y）

3. 產生報告，包含：
   - 嚴重性：關鍵、高、中、低
   - 檔案位置和行號
   - 問題描述
   - 建議修復

4. 如果發現關鍵或高優先問題則阻擋提交

絕不批准有安全弱點的程式碼！
