# /learn - 擷取可重用模式

分析目前的工作階段並擷取值得儲存為技能的模式。

## 觸發

在工作階段中任何時間點解決了非瑣碎問題時執行 `/learn`。

## 擷取內容

尋找：

1. **錯誤解決模式**
   - 發生了什麼錯誤？
   - 根本原因是什麼？
   - 什麼修復了它？
   - 這可以重用於類似錯誤嗎？

2. **除錯技術**
   - 非顯而易見的除錯步驟
   - 有效的工具組合
   - 診斷模式

3. **變通方案**
   - 函式庫怪癖
   - API 限制
   - 特定版本的修復

4. **專案特定模式**
   - 發現的程式碼庫慣例
   - 做出的架構決策
   - 整合模式

## 輸出格式

在 `~/.claude/skills/learned/[pattern-name].md` 建立技能檔案：

```markdown
# [描述性模式名稱]

**擷取日期：** [日期]
**上下文：** [此模式何時適用的簡短描述]

## 問題
[此模式解決什麼問題 - 要具體]

## 解決方案
[模式/技術/變通方案]

## 範例
[如適用的程式碼範例]

## 何時使用
[觸發條件 - 什麼應該啟動此技能]
```

## 流程

1. 審查工作階段中可擷取的模式
2. 識別最有價值/可重用的見解
3. 起草技能檔案
4. 請使用者在儲存前確認
5. 儲存到 `~/.claude/skills/learned/`

## 注意事項

- 不要擷取瑣碎的修復（打字錯誤、簡單的語法錯誤）
- 不要擷取一次性問題（特定 API 停機等）
- 專注於會在未來工作階段節省時間的模式
- 保持技能專注 - 每個技能一個模式
