"""
Model Manager Stub for Lite Version.
"""
from pathlib import Path

class ModelType:
    WHISPER = "whisper"
    SHERPA = "sherpa"
    VOSK = "vosk"
    NLLB = "nllb"

class ModelStatus:
    DOWNLOADED = "downloaded"
    MISSING = "missing"
    DOWNLOADING = "downloading"
    NOT_DOWNLOADED = "not_downloaded"

class ModelInfo:
    def __init__(self, id, name, type):
        self.id = id
        self.name = name
        self.model_type = type
        self.description = ""
        self.hf_repo = ""
    
    def get_size_display(self):
        return "0 MB"

class ModelManager:
    def __init__(self):
        self.models_dir = Path("models")
        
    def get_all_models(self):
        return []
    
    def get_status(self, model):
        return ModelStatus.DOWNLOADED
    
    def download(self, model, progress_callback=None):
        pass
    
    def get_model_path(self, model):
        return self.models_dir / model.id

SUPPORTED_MODELS = []

__all__ = [
    "ModelManager",
    "ModelInfo",
    "ModelType",
    "ModelStatus",
    "SUPPORTED_MODELS",
]
