"""
Lite Version Pipeline Module.
Contains only shared event definitions.
"""

from dataclasses import dataclass
from typing import Optional

@dataclass
class SubtitleEvent:
    """A subtitle event with text and metadata."""
    text: str
    language: str
    confidence: float
    timestamp: float
    is_partial: bool = False
    translated_text: Optional[str] = None
    target_language: Optional[str] = None
    committed_translation: Optional[str] = None
    draft_translation: Optional[str] = None
