"""fix index to optimize message clean job performance

Revision ID: fce013ca180e
Revises: f55813ffe2c8
Create Date: 2026-02-11 15:49:17.603638

"""
from alembic import op
import models as models
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'fce013ca180e'
down_revision = 'f55813ffe2c8'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('messages', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('message_created_at_idx'))

    with op.batch_alter_table('saved_messages', schema=None) as batch_op:
        batch_op.create_index('saved_message_message_id_idx', ['message_id'], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('saved_messages', schema=None) as batch_op:
        batch_op.drop_index('saved_message_message_id_idx')

    with op.batch_alter_table('messages', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('message_created_at_idx'), ['created_at'], unique=False)

    # ### end Alembic commands ###
