import { RiArrowLeftSLine, RiArrowRightSLine } from '@remixicon/react'
import * as React from 'react'
import { useTranslation } from 'react-i18next'
import { cn } from '@/utils/classnames'
import Button from '../base/button'
import Tooltip from '../base/tooltip'
import ShortcutsName from '../workflow/shortcuts-name'

type TooltipContentProps = {
  expand: boolean
}

const TOGGLE_SHORTCUT = ['ctrl', 'B']

const TooltipContent = ({
  expand,
}: TooltipContentProps) => {
  const { t } = useTranslation()

  return (
    <div className="flex items-center gap-x-1">
      <span className="px-0.5 text-text-secondary system-xs-medium">{expand ? t('sidebar.collapseSidebar', { ns: 'layout' }) : t('sidebar.expandSidebar', { ns: 'layout' })}</span>
      <ShortcutsName keys={TOGGLE_SHORTCUT} textColor="secondary" />
    </div>
  )
}

type ToggleButtonProps = {
  expand: boolean
  handleToggle: () => void
  className?: string
}

const ToggleButton = ({
  expand,
  handleToggle,
  className,
}: ToggleButtonProps) => {
  return (
    <Tooltip
      popupContent={<TooltipContent expand={expand} />}
      popupClassName="p-1.5 rounded-lg"
      position="right"
    >
      <Button
        size="small"
        onClick={handleToggle}
        className={cn('rounded-full px-1', className)}
      >
        {
          expand
            ? <RiArrowLeftSLine className="size-4" />
            : <RiArrowRightSLine className="size-4" />
        }
      </Button>
    </Tooltip>
  )
}

export default React.memo(ToggleButton)
