'use client'
import * as React from 'react'
import Checkbox from '@/app/components/base/checkbox'
import Tooltip from '@/app/components/base/tooltip'
import { cn } from '@/utils/classnames'

type CheckboxWithLabelProps = {
  className?: string
  isChecked: boolean
  onChange: (isChecked: boolean) => void
  label: string
  labelClassName?: string
  tooltip?: string
}

const CheckboxWithLabel = ({
  className = '',
  isChecked,
  onChange,
  label,
  labelClassName,
  tooltip,
}: CheckboxWithLabelProps) => {
  return (
    <label className={cn('flex items-center space-x-2', className)}>
      <Checkbox checked={isChecked} onCheck={() => onChange(!isChecked)} />
      <div className={cn('text-text-secondary system-sm-medium', labelClassName)}>{label}</div>
      {tooltip && (
        <Tooltip
          popupContent={
            <div className="w-[200px]">{tooltip}</div>
          }
          triggerClassName="ml-0.5 w-4 h-4"
        />
      )}
    </label>
  )
}
export default React.memo(CheckboxWithLabel)
