import { RiErrorWarningFill } from '@remixicon/react'
import * as React from 'react'
import { cn } from '@/utils/classnames'

type ErrorMessageProps = {
  className?: string
  title: string
  errorMsg?: string
}

const ErrorMessage = ({
  className,
  title,
  errorMsg,
}: ErrorMessageProps) => {
  return (
    <div className={cn(
      'flex gap-x-0.5 rounded-xl border-[0.5px] border-components-panel-border bg-opacity-40 bg-toast-error-bg p-2 shadow-xs shadow-shadow-shadow-3',
      className,
    )}
    >
      <div className="flex size-6 items-center justify-center">
        <RiErrorWarningFill className="h-4 w-4 text-text-destructive" />
      </div>
      <div className="flex flex-col gap-y-0.5 py-1">
        <div className="text-text-primary system-xs-medium">{title}</div>
        {errorMsg && (
          <div className="text-text-secondary system-xs-regular">{errorMsg}</div>
        )}
      </div>
    </div>
  )
}
export default React.memo(ErrorMessage)
