import { memo } from 'react'
import { useTranslation } from 'react-i18next'
import { cn } from '@/utils/classnames'

type SummaryLabelProps = {
  summary?: string
  className?: string
}
const SummaryLabel = ({
  summary,
  className,
}: SummaryLabelProps) => {
  const { t } = useTranslation()

  return (
    <div className={cn('space-y-1', className)}>
      <div className="mt-2 flex items-center justify-between text-text-tertiary system-xs-medium-uppercase">
        {t('segment.summary', { ns: 'datasetDocuments' })}
        <div className="ml-2 h-px grow bg-divider-regular"></div>
      </div>
      <div className="text-text-tertiary body-xs-regular">{summary}</div>
    </div>
  )
}

export default memo(SummaryLabel)
