'use client'
import type { FC } from 'react'
import * as React from 'react'
import { useTranslation } from 'react-i18next'
import { useDocLink } from '@/context/i18n'
import useTheme from '@/hooks/use-theme'
import { Theme } from '@/types/app'
import { cn } from '@/utils/classnames'
import s from './style.module.css'

const i18nPrefix = 'sidebar.noApps'

const NoApps: FC = () => {
  const { t } = useTranslation()
  const { theme } = useTheme()
  const docLink = useDocLink()
  return (
    <div className="rounded-xl bg-background-default-subtle p-4">
      <div className={cn('h-[35px] w-[86px] bg-contain bg-center bg-no-repeat', theme === Theme.dark ? s.dark : s.light)}></div>
      <div className="mt-2 text-text-secondary system-sm-semibold">{t(`${i18nPrefix}.title`, { ns: 'explore' })}</div>
      <div className="my-1 text-text-tertiary system-xs-regular">{t(`${i18nPrefix}.description`, { ns: 'explore' })}</div>
      <a className="text-text-accent system-xs-regular" target="_blank" rel="noopener noreferrer" href={docLink('/use-dify/publish/README')}>{t(`${i18nPrefix}.learnMore`, { ns: 'explore' })}</a>
    </div>
  )
}
export default React.memo(NoApps)
