import type { NullStrategy } from '@/app/components/workflow/nodes/_base/constants'
import type { ValueSelector } from '@/app/components/workflow/types'

// Generic variable types for all resource forms
export enum VarKindType {
  variable = 'variable',
  constant = 'constant',
  mixed = 'mixed',
  nested_node = 'nested_node',
}

export type NestedNodeConfig = {
  extractor_node_id: string
  output_selector: ValueSelector
  null_strategy: NullStrategy
  default_value: unknown
}

// Generic resource variable inputs
export type ResourceVarInputs = Record<string, {
  type: VarKindType
  value?: string | ValueSelector | any
  nested_node_config?: NestedNodeConfig
}>

// Base resource interface
export type BaseResource = {
  name: string
  [key: string]: any
}

// Base resource provider interface
export type BaseResourceProvider = {
  plugin_id?: string
  name: string
  [key: string]: any
}
