// AUTO-GENERATED — DO NOT EDIT
// Source: https://github.com/anthropics/skills
import type { SkillTemplateNode } from '../types'

const children: SkillTemplateNode[] = [
  {
    "name": "SKILL.md",
    "node_type": "file",
    "content": "---\nname: algorithmic-art\ndescription: Creating algorithmic art using p5.js with seeded randomness and interactive parameter exploration. Use this when users request creating art using code, generative art, algorithmic art, flow fields, or particle systems. Create original algorithmic art rather than copying existing artists' work to avoid copyright violations.\nlicense: Complete terms in LICENSE.txt\n---\n\nAlgorithmic philosophies are computational aesthetic movements that are then expressed through code. Output .md files (philosophy), .html files (interactive viewer), and .js files (generative algorithms).\n\nThis happens in two steps:\n1. Algorithmic Philosophy Creation (.md file)\n2. Express by creating p5.js generative art (.html + .js files)\n\nFirst, undertake this task:\n\n## ALGORITHMIC PHILOSOPHY CREATION\n\nTo begin, create an ALGORITHMIC PHILOSOPHY (not static images or templates) that will be interpreted through:\n- Computational processes, emergent behavior, mathematical beauty\n- Seeded randomness, noise fields, organic systems\n- Particles, flows, fields, forces\n- Parametric variation and controlled chaos\n\n### THE CRITICAL UNDERSTANDING\n- What is received: Some subtle input or instructions by the user to take into account, but use as a foundation; it should not constrain creative freedom.\n- What is created: An algorithmic philosophy/generative aesthetic movement.\n- What happens next: The same version receives the philosophy and EXPRESSES IT IN CODE - creating p5.js sketches that are 90% algorithmic generation, 10% essential parameters.\n\nConsider this approach:\n- Write a manifesto for a generative art movement\n- The next phase involves writing the algorithm that brings it to life\n\nThe philosophy must emphasize: Algorithmic expression. Emergent behavior. Computational beauty. Seeded variation.\n\n### HOW TO GENERATE AN ALGORITHMIC PHILOSOPHY\n\n**Name the movement** (1-2 words): \"Organic Turbulence\" / \"Quantum Harmonics\" / \"Emergent Stillness\"\n\n**Articulate the philosophy** (4-6 paragraphs - concise but complete):\n\nTo capture the ALGORITHMIC essence, express how this philosophy manifests through:\n- Computational processes and mathematical relationships?\n- Noise functions and randomness patterns?\n- Particle behaviors and field dynamics?\n- Temporal evolution and system states?\n- Parametric variation and emergent complexity?\n\n**CRITICAL GUIDELINES:**\n- **Avoid redundancy**: Each algorithmic aspect should be mentioned once. Avoid repeating concepts about noise theory, particle dynamics, or mathematical principles unless adding new depth.\n- **Emphasize craftsmanship REPEATEDLY**: The philosophy MUST stress multiple times that the final algorithm should appear as though it took countless hours to develop, was refined with care, and comes from someone at the absolute top of their field. This framing is essential - repeat phrases like \"meticulously crafted algorithm,\" \"the product of deep computational expertise,\" \"painstaking optimization,\" \"master-level implementation.\"\n- **Leave creative space**: Be specific about the algorithmic direction, but concise enough that the next Claude has room to make interpretive implementation choices at an extremely high level of craftsmanship.\n\nThe philosophy must guide the next version to express ideas ALGORITHMICALLY, not through static images. Beauty lives in the process, not the final frame.\n\n### PHILOSOPHY EXAMPLES\n\n**\"Organic Turbulence\"**\nPhilosophy: Chaos constrained by natural law, order emerging from disorder.\nAlgorithmic expression: Flow fields driven by layered Perlin noise. Thousands of particles following vector forces, their trails accumulating into organic density maps. Multiple noise octaves create turbulent regions and calm zones. Color emerges from velocity and density - fast particles burn bright, slow ones fade to shadow. The algorithm runs until equilibrium - a meticulously tuned balance where every parameter was refined through countless iterations by a master of computational aesthetics.\n\n**\"Quantum Harmonics\"**\nPhilosophy: Discrete entities exhibiting wave-like interference patterns.\nAlgorithmic expression: Particles initialized on a grid, each carrying a phase value that evolves through sine waves. When particles are near, their phases interfere - constructive interference creates bright nodes, destructive creates voids. Simple harmonic motion generates complex emergent mandalas. The result of painstaking frequency calibration where every ratio was carefully chosen to produce resonant beauty.\n\n**\"Recursive Whispers\"**\nPhilosophy: Self-similarity across scales, infinite depth in finite space.\nAlgorithmic expression: Branching structures that subdivide recursively. Each branch slightly randomized but constrained by golden ratios. L-systems or recursive subdivision generate tree-like forms that feel both mathematical and organic. Subtle noise perturbations break perfect symmetry. Line weights diminish with each recursion level. Every branching angle the product of deep mathematical exploration.\n\n**\"Field Dynamics\"**\nPhilosophy: Invisible forces made visible through their effects on matter.\nAlgorithmic expression: Vector fields constructed from mathematical functions or noise. Particles born at edges, flowing along field lines, dying when they reach equilibrium or boundaries. Multiple fields can attract, repel, or rotate particles. The visualization shows only the traces - ghost-like evidence of invisible forces. A computational dance meticulously choreographed through force balance.\n\n**\"Stochastic Crystallization\"**\nPhilosophy: Random processes crystallizing into ordered structures.\nAlgorithmic expression: Randomized circle packing or Voronoi tessellation. Start with random points, let them evolve through relaxation algorithms. Cells push apart until equilibrium. Color based on cell size, neighbor count, or distance from center. The organic tiling that emerges feels both random and inevitable. Every seed produces unique crystalline beauty - the mark of a master-level generative algorithm.\n\n*These are condensed examples. The actual algorithmic philosophy should be 4-6 substantial paragraphs.*\n\n### ESSENTIAL PRINCIPLES\n- **ALGORITHMIC PHILOSOPHY**: Creating a computational worldview to be expressed through code\n- **PROCESS OVER PRODUCT**: Always emphasize that beauty emerges from the algorithm's execution - each run is unique\n- **PARAMETRIC EXPRESSION**: Ideas communicate through mathematical relationships, forces, behaviors - not static composition\n- **ARTISTIC FREEDOM**: The next Claude interprets the philosophy algorithmically - provide creative implementation room\n- **PURE GENERATIVE ART**: This is about making LIVING ALGORITHMS, not static images with randomness\n- **EXPERT CRAFTSMANSHIP**: Repeatedly emphasize the final algorithm must feel meticulously crafted, refined through countless iterations, the product of deep expertise by someone at the absolute top of their field in computational aesthetics\n\n**The algorithmic philosophy should be 4-6 paragraphs long.** Fill it with poetic computational philosophy that brings together the intended vision. Avoid repeating the same points. Output this algorithmic philosophy as a .md file.\n\n---\n\n## DEDUCING THE CONCEPTUAL SEED\n\n**CRITICAL STEP**: Before implementing the algorithm, identify the subtle conceptual thread from the original request.\n\n**THE ESSENTIAL PRINCIPLE**:\nThe concept is a **subtle, niche reference embedded within the algorithm itself** - not always literal, always sophisticated. Someone familiar with the subject should feel it intuitively, while others simply experience a masterful generative composition. The algorithmic philosophy provides the computational language. The deduced concept provides the soul - the quiet conceptual DNA woven invisibly into parameters, behaviors, and emergence patterns.\n\nThis is **VERY IMPORTANT**: The reference must be so refined that it enhances the work's depth without announcing itself. Think like a jazz musician quoting another song through algorithmic harmony - only those who know will catch it, but everyone appreciates the generative beauty.\n\n---\n\n## P5.JS IMPLEMENTATION\n\nWith the philosophy AND conceptual framework established, express it through code. Pause to gather thoughts before proceeding. Use only the algorithmic philosophy created and the instructions below.\n\n### ⚠️ STEP 0: READ THE TEMPLATE FIRST ⚠️\n\n**CRITICAL: BEFORE writing any HTML:**\n\n1. **Read** `templates/viewer.html` using the Read tool\n2. **Study** the exact structure, styling, and Anthropic branding\n3. **Use that file as the LITERAL STARTING POINT** - not just inspiration\n4. **Keep all FIXED sections exactly as shown** (header, sidebar structure, Anthropic colors/fonts, seed controls, action buttons)\n5. **Replace only the VARIABLE sections** marked in the file's comments (algorithm, parameters, UI controls for parameters)\n\n**Avoid:**\n- ❌ Creating HTML from scratch\n- ❌ Inventing custom styling or color schemes\n- ❌ Using system fonts or dark themes\n- ❌ Changing the sidebar structure\n\n**Follow these practices:**\n- ✅ Copy the template's exact HTML structure\n- ✅ Keep Anthropic branding (Poppins/Lora fonts, light colors, gradient backdrop)\n- ✅ Maintain the sidebar layout (Seed → Parameters → Colors? → Actions)\n- ✅ Replace only the p5.js algorithm and parameter controls\n\nThe template is the foundation. Build on it, don't rebuild it.\n\n---\n\nTo create gallery-quality computational art that lives and breathes, use the algorithmic philosophy as the foundation.\n\n### TECHNICAL REQUIREMENTS\n\n**Seeded Randomness (Art Blocks Pattern)**:\n```javascript\n// ALWAYS use a seed for reproducibility\nlet seed = 12345; // or hash from user input\nrandomSeed(seed);\nnoiseSeed(seed);\n```\n\n**Parameter Structure - FOLLOW THE PHILOSOPHY**:\n\nTo establish parameters that emerge naturally from the algorithmic philosophy, consider: \"What qualities of this system can be adjusted?\"\n\n```javascript\nlet params = {\n  seed: 12345,  // Always include seed for reproducibility\n  // colors\n  // Add parameters that control YOUR algorithm:\n  // - Quantities (how many?)\n  // - Scales (how big? how fast?)\n  // - Probabilities (how likely?)\n  // - Ratios (what proportions?)\n  // - Angles (what direction?)\n  // - Thresholds (when does behavior change?)\n};\n```\n\n**To design effective parameters, focus on the properties the system needs to be tunable rather than thinking in terms of \"pattern types\".**\n\n**Core Algorithm - EXPRESS THE PHILOSOPHY**:\n\n**CRITICAL**: The algorithmic philosophy should dictate what to build.\n\nTo express the philosophy through code, avoid thinking \"which pattern should I use?\" and instead think \"how to express this philosophy through code?\"\n\nIf the philosophy is about **organic emergence**, consider using:\n- Elements that accumulate or grow over time\n- Random processes constrained by natural rules\n- Feedback loops and interactions\n\nIf the philosophy is about **mathematical beauty**, consider using:\n- Geometric relationships and ratios\n- Trigonometric functions and harmonics\n- Precise calculations creating unexpected patterns\n\nIf the philosophy is about **controlled chaos**, consider using:\n- Random variation within strict boundaries\n- Bifurcation and phase transitions\n- Order emerging from disorder\n\n**The algorithm flows from the philosophy, not from a menu of options.**\n\nTo guide the implementation, let the conceptual essence inform creative and original choices. Build something that expresses the vision for this particular request.\n\n**Canvas Setup**: Standard p5.js structure:\n```javascript\nfunction setup() {\n  createCanvas(1200, 1200);\n  // Initialize your system\n}\n\nfunction draw() {\n  // Your generative algorithm\n  // Can be static (noLoop) or animated\n}\n```\n\n### CRAFTSMANSHIP REQUIREMENTS\n\n**CRITICAL**: To achieve mastery, create algorithms that feel like they emerged through countless iterations by a master generative artist. Tune every parameter carefully. Ensure every pattern emerges with purpose. This is NOT random noise - this is CONTROLLED CHAOS refined through deep expertise.\n\n- **Balance**: Complexity without visual noise, order without rigidity\n- **Color Harmony**: Thoughtful palettes, not random RGB values\n- **Composition**: Even in randomness, maintain visual hierarchy and flow\n- **Performance**: Smooth execution, optimized for real-time if animated\n- **Reproducibility**: Same seed ALWAYS produces identical output\n\n### OUTPUT FORMAT\n\nOutput:\n1. **Algorithmic Philosophy** - As markdown or text explaining the generative aesthetic\n2. **Single HTML Artifact** - Self-contained interactive generative art built from `templates/viewer.html` (see STEP 0 and next section)\n\nThe HTML artifact contains everything: p5.js (from CDN), the algorithm, parameter controls, and UI - all in one file that works immediately in claude.ai artifacts or any browser. Start from the template file, not from scratch.\n\n---\n\n## INTERACTIVE ARTIFACT CREATION\n\n**REMINDER: `templates/viewer.html` should have already been read (see STEP 0). Use that file as the starting point.**\n\nTo allow exploration of the generative art, create a single, self-contained HTML artifact. Ensure this artifact works immediately in claude.ai or any browser - no setup required. Embed everything inline.\n\n### CRITICAL: WHAT'S FIXED VS VARIABLE\n\nThe `templates/viewer.html` file is the foundation. It contains the exact structure and styling needed.\n\n**FIXED (always include exactly as shown):**\n- Layout structure (header, sidebar, main canvas area)\n- Anthropic branding (UI colors, fonts, gradients)\n- Seed section in sidebar:\n  - Seed display\n  - Previous/Next buttons\n  - Random button\n  - Jump to seed input + Go button\n- Actions section in sidebar:\n  - Regenerate button\n  - Reset button\n\n**VARIABLE (customize for each artwork):**\n- The entire p5.js algorithm (setup/draw/classes)\n- The parameters object (define what the art needs)\n- The Parameters section in sidebar:\n  - Number of parameter controls\n  - Parameter names\n  - Min/max/step values for sliders\n  - Control types (sliders, inputs, etc.)\n- Colors section (optional):\n  - Some art needs color pickers\n  - Some art might use fixed colors\n  - Some art might be monochrome (no color controls needed)\n  - Decide based on the art's needs\n\n**Every artwork should have unique parameters and algorithm!** The fixed parts provide consistent UX - everything else expresses the unique vision.\n\n### REQUIRED FEATURES\n\n**1. Parameter Controls**\n- Sliders for numeric parameters (particle count, noise scale, speed, etc.)\n- Color pickers for palette colors\n- Real-time updates when parameters change\n- Reset button to restore defaults\n\n**2. Seed Navigation**\n- Display current seed number\n- \"Previous\" and \"Next\" buttons to cycle through seeds\n- \"Random\" button for random seed\n- Input field to jump to specific seed\n- Generate 100 variations when requested (seeds 1-100)\n\n**3. Single Artifact Structure**\n```html\n<!DOCTYPE html>\n<html>\n<head>\n  <!-- p5.js from CDN - always available -->\n  <script src=\"https://cdnjs.cloudflare.com/ajax/libs/p5.js/1.7.0/p5.min.js\"></script>\n  <style>\n    /* All styling inline - clean, minimal */\n    /* Canvas on top, controls below */\n  </style>\n</head>\n<body>\n  <div id=\"canvas-container\"></div>\n  <div id=\"controls\">\n    <!-- All parameter controls -->\n  </div>\n  <script>\n    // ALL p5.js code inline here\n    // Parameter objects, classes, functions\n    // setup() and draw()\n    // UI handlers\n    // Everything self-contained\n  </script>\n</body>\n</html>\n```\n\n**CRITICAL**: This is a single artifact. No external files, no imports (except p5.js CDN). Everything inline.\n\n**4. Implementation Details - BUILD THE SIDEBAR**\n\nThe sidebar structure:\n\n**1. Seed (FIXED)** - Always include exactly as shown:\n- Seed display\n- Prev/Next/Random/Jump buttons\n\n**2. Parameters (VARIABLE)** - Create controls for the art:\n```html\n<div class=\"control-group\">\n    <label>Parameter Name</label>\n    <input type=\"range\" id=\"param\" min=\"...\" max=\"...\" step=\"...\" value=\"...\" oninput=\"updateParam('param', this.value)\">\n    <span class=\"value-display\" id=\"param-value\">...</span>\n</div>\n```\nAdd as many control-group divs as there are parameters.\n\n**3. Colors (OPTIONAL/VARIABLE)** - Include if the art needs adjustable colors:\n- Add color pickers if users should control palette\n- Skip this section if the art uses fixed colors\n- Skip if the art is monochrome\n\n**4. Actions (FIXED)** - Always include exactly as shown:\n- Regenerate button\n- Reset button\n- Download PNG button\n\n**Requirements**:\n- Seed controls must work (prev/next/random/jump/display)\n- All parameters must have UI controls\n- Regenerate, Reset, Download buttons must work\n- Keep Anthropic branding (UI styling, not art colors)\n\n### USING THE ARTIFACT\n\nThe HTML artifact works immediately:\n1. **In claude.ai**: Displayed as an interactive artifact - runs instantly\n2. **As a file**: Save and open in any browser - no server needed\n3. **Sharing**: Send the HTML file - it's completely self-contained\n\n---\n\n## VARIATIONS & EXPLORATION\n\nThe artifact includes seed navigation by default (prev/next/random buttons), allowing users to explore variations without creating multiple files. If the user wants specific variations highlighted:\n\n- Include seed presets (buttons for \"Variation 1: Seed 42\", \"Variation 2: Seed 127\", etc.)\n- Add a \"Gallery Mode\" that shows thumbnails of multiple seeds side-by-side\n- All within the same single artifact\n\nThis is like creating a series of prints from the same plate - the algorithm is consistent, but each seed reveals different facets of its potential. The interactive nature means users discover their own favorites by exploring the seed space.\n\n---\n\n## THE CREATIVE PROCESS\n\n**User request** → **Algorithmic philosophy** → **Implementation**\n\nEach request is unique. The process involves:\n\n1. **Interpret the user's intent** - What aesthetic is being sought?\n2. **Create an algorithmic philosophy** (4-6 paragraphs) describing the computational approach\n3. **Implement it in code** - Build the algorithm that expresses this philosophy\n4. **Design appropriate parameters** - What should be tunable?\n5. **Build matching UI controls** - Sliders/inputs for those parameters\n\n**The constants**:\n- Anthropic branding (colors, fonts, layout)\n- Seed navigation (always present)\n- Self-contained HTML artifact\n\n**Everything else is variable**:\n- The algorithm itself\n- The parameters\n- The UI controls\n- The visual outcome\n\nTo achieve the best results, trust creativity and let the philosophy guide the implementation.\n\n---\n\n## RESOURCES\n\nThis skill includes helpful templates and documentation:\n\n- **templates/viewer.html**: REQUIRED STARTING POINT for all HTML artifacts.\n  - This is the foundation - contains the exact structure and Anthropic branding\n  - **Keep unchanged**: Layout structure, sidebar organization, Anthropic colors/fonts, seed controls, action buttons\n  - **Replace**: The p5.js algorithm, parameter definitions, and UI controls in Parameters section\n  - The extensive comments in the file mark exactly what to keep vs replace\n\n- **templates/generator_template.js**: Reference for p5.js best practices and code structure principles.\n  - Shows how to organize parameters, use seeded randomness, structure classes\n  - NOT a pattern menu - use these principles to build unique algorithms\n  - Embed algorithms inline in the HTML artifact (don't create separate .js files)\n\n**Critical reminder**:\n- The **template is the STARTING POINT**, not inspiration\n- The **algorithm is where to create** something unique\n- Don't copy the flow field example - build what the philosophy demands\n- But DO keep the exact UI structure and Anthropic branding from the template"
  },
  {
    "name": "templates",
    "node_type": "folder",
    "children": [
      {
        "name": "generator_template.js",
        "node_type": "file",
        "content": "/**\n * ═══════════════════════════════════════════════════════════════════════════\n *                  P5.JS GENERATIVE ART - BEST PRACTICES\n * ═══════════════════════════════════════════════════════════════════════════\n *\n * This file shows STRUCTURE and PRINCIPLES for p5.js generative art.\n * It does NOT prescribe what art you should create.\n *\n * Your algorithmic philosophy should guide what you build.\n * These are just best practices for how to structure your code.\n *\n * ═══════════════════════════════════════════════════════════════════════════\n */\n\n// ============================================================================\n// 1. PARAMETER ORGANIZATION\n// ============================================================================\n// Keep all tunable parameters in one object\n// This makes it easy to:\n// - Connect to UI controls\n// - Reset to defaults\n// - Serialize/save configurations\n\nlet params = {\n    // Define parameters that match YOUR algorithm\n    // Examples (customize for your art):\n    // - Counts: how many elements (particles, circles, branches, etc.)\n    // - Scales: size, speed, spacing\n    // - Probabilities: likelihood of events\n    // - Angles: rotation, direction\n    // - Colors: palette arrays\n\n    seed: 12345,\n    // define colorPalette as an array -- choose whatever colors you'd like ['#d97757', '#6a9bcc', '#788c5d', '#b0aea5']\n    // Add YOUR parameters here based on your algorithm\n};\n\n// ============================================================================\n// 2. SEEDED RANDOMNESS (Critical for reproducibility)\n// ============================================================================\n// ALWAYS use seeded random for Art Blocks-style reproducible output\n\nfunction initializeSeed(seed) {\n    randomSeed(seed);\n    noiseSeed(seed);\n    // Now all random() and noise() calls will be deterministic\n}\n\n// ============================================================================\n// 3. P5.JS LIFECYCLE\n// ============================================================================\n\nfunction setup() {\n    createCanvas(800, 800);\n\n    // Initialize seed first\n    initializeSeed(params.seed);\n\n    // Set up your generative system\n    // This is where you initialize:\n    // - Arrays of objects\n    // - Grid structures\n    // - Initial positions\n    // - Starting states\n\n    // For static art: call noLoop() at the end of setup\n    // For animated art: let draw() keep running\n}\n\nfunction draw() {\n    // Option 1: Static generation (runs once, then stops)\n    // - Generate everything in setup()\n    // - Call noLoop() in setup()\n    // - draw() doesn't do much or can be empty\n\n    // Option 2: Animated generation (continuous)\n    // - Update your system each frame\n    // - Common patterns: particle movement, growth, evolution\n    // - Can optionally call noLoop() after N frames\n\n    // Option 3: User-triggered regeneration\n    // - Use noLoop() by default\n    // - Call redraw() when parameters change\n}\n\n// ============================================================================\n// 4. CLASS STRUCTURE (When you need objects)\n// ============================================================================\n// Use classes when your algorithm involves multiple entities\n// Examples: particles, agents, cells, nodes, etc.\n\nclass Entity {\n    constructor() {\n        // Initialize entity properties\n        // Use random() here - it will be seeded\n    }\n\n    update() {\n        // Update entity state\n        // This might involve:\n        // - Physics calculations\n        // - Behavioral rules\n        // - Interactions with neighbors\n    }\n\n    display() {\n        // Render the entity\n        // Keep rendering logic separate from update logic\n    }\n}\n\n// ============================================================================\n// 5. PERFORMANCE CONSIDERATIONS\n// ============================================================================\n\n// For large numbers of elements:\n// - Pre-calculate what you can\n// - Use simple collision detection (spatial hashing if needed)\n// - Limit expensive operations (sqrt, trig) when possible\n// - Consider using p5 vectors efficiently\n\n// For smooth animation:\n// - Aim for 60fps\n// - Profile if things are slow\n// - Consider reducing particle counts or simplifying calculations\n\n// ============================================================================\n// 6. UTILITY FUNCTIONS\n// ============================================================================\n\n// Color utilities\nfunction hexToRgb(hex) {\n    const result = /^#?([a-f\\d]{2})([a-f\\d]{2})([a-f\\d]{2})$/i.exec(hex);\n    return result ? {\n        r: parseInt(result[1], 16),\n        g: parseInt(result[2], 16),\n        b: parseInt(result[3], 16)\n    } : null;\n}\n\nfunction colorFromPalette(index) {\n    return params.colorPalette[index % params.colorPalette.length];\n}\n\n// Mapping and easing\nfunction mapRange(value, inMin, inMax, outMin, outMax) {\n    return outMin + (outMax - outMin) * ((value - inMin) / (inMax - inMin));\n}\n\nfunction easeInOutCubic(t) {\n    return t < 0.5 ? 4 * t * t * t : 1 - Math.pow(-2 * t + 2, 3) / 2;\n}\n\n// Constrain to bounds\nfunction wrapAround(value, max) {\n    if (value < 0) return max;\n    if (value > max) return 0;\n    return value;\n}\n\n// ============================================================================\n// 7. PARAMETER UPDATES (Connect to UI)\n// ============================================================================\n\nfunction updateParameter(paramName, value) {\n    params[paramName] = value;\n    // Decide if you need to regenerate or just update\n    // Some params can update in real-time, others need full regeneration\n}\n\nfunction regenerate() {\n    // Reinitialize your generative system\n    // Useful when parameters change significantly\n    initializeSeed(params.seed);\n    // Then regenerate your system\n}\n\n// ============================================================================\n// 8. COMMON P5.JS PATTERNS\n// ============================================================================\n\n// Drawing with transparency for trails/fading\nfunction fadeBackground(opacity) {\n    fill(250, 249, 245, opacity); // Anthropic light with alpha\n    noStroke();\n    rect(0, 0, width, height);\n}\n\n// Using noise for organic variation\nfunction getNoiseValue(x, y, scale = 0.01) {\n    return noise(x * scale, y * scale);\n}\n\n// Creating vectors from angles\nfunction vectorFromAngle(angle, magnitude = 1) {\n    return createVector(cos(angle), sin(angle)).mult(magnitude);\n}\n\n// ============================================================================\n// 9. EXPORT FUNCTIONS\n// ============================================================================\n\nfunction exportImage() {\n    saveCanvas('generative-art-' + params.seed, 'png');\n}\n\n// ============================================================================\n// REMEMBER\n// ============================================================================\n//\n// These are TOOLS and PRINCIPLES, not a recipe.\n// Your algorithmic philosophy should guide WHAT you create.\n// This structure helps you create it WELL.\n//\n// Focus on:\n// - Clean, readable code\n// - Parameterized for exploration\n// - Seeded for reproducibility\n// - Performant execution\n//\n// The art itself is entirely up to you!\n//\n// ============================================================================"
      },
      {
        "name": "viewer.html",
        "node_type": "file",
        "content": "<!DOCTYPE html>\n<!--\n    THIS IS A TEMPLATE THAT SHOULD BE USED EVERY TIME AND MODIFIED.\n    WHAT TO KEEP:\n    ✓ Overall structure (header, sidebar, main content)\n    ✓ Anthropic branding (colors, fonts, layout)\n    ✓ Seed navigation section (always include this)\n    ✓ Self-contained artifact (everything inline)\n\n    WHAT TO CREATIVELY EDIT:\n    ✗ The p5.js algorithm (implement YOUR vision)\n    ✗ The parameters (define what YOUR art needs)\n    ✗ The UI controls (match YOUR parameters)\n\n    Let your philosophy guide the implementation.\n    The world is your oyster - be creative!\n-->\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <title>Generative Art Viewer</title>\n    <script src=\"https://cdnjs.cloudflare.com/ajax/libs/p5.js/1.7.0/p5.min.js\"></script>\n    <link rel=\"preconnect\" href=\"https://fonts.googleapis.com\">\n    <link rel=\"preconnect\" href=\"https://fonts.gstatic.com\" crossorigin>\n    <link href=\"https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&family=Lora:wght@400;500&display=swap\" rel=\"stylesheet\">\n    <style>\n        /* Anthropic Brand Colors */\n        :root {\n            --anthropic-dark: #141413;\n            --anthropic-light: #faf9f5;\n            --anthropic-mid-gray: #b0aea5;\n            --anthropic-light-gray: #e8e6dc;\n            --anthropic-orange: #d97757;\n            --anthropic-blue: #6a9bcc;\n            --anthropic-green: #788c5d;\n        }\n\n        * {\n            margin: 0;\n            padding: 0;\n            box-sizing: border-box;\n        }\n\n        body {\n            font-family: 'Poppins', sans-serif;\n            background: linear-gradient(135deg, var(--anthropic-light) 0%, #f5f3ee 100%);\n            min-height: 100vh;\n            color: var(--anthropic-dark);\n        }\n\n        .container {\n            display: flex;\n            min-height: 100vh;\n            padding: 20px;\n            gap: 20px;\n        }\n\n        /* Sidebar */\n        .sidebar {\n            width: 320px;\n            flex-shrink: 0;\n            background: rgba(255, 255, 255, 0.95);\n            backdrop-filter: blur(10px);\n            padding: 24px;\n            border-radius: 12px;\n            box-shadow: 0 10px 30px rgba(20, 20, 19, 0.1);\n            overflow-y: auto;\n            overflow-x: hidden;\n        }\n\n        .sidebar h1 {\n            font-family: 'Lora', serif;\n            font-size: 24px;\n            font-weight: 500;\n            color: var(--anthropic-dark);\n            margin-bottom: 8px;\n        }\n\n        .sidebar .subtitle {\n            color: var(--anthropic-mid-gray);\n            font-size: 14px;\n            margin-bottom: 32px;\n            line-height: 1.4;\n        }\n\n        /* Control Sections */\n        .control-section {\n            margin-bottom: 32px;\n        }\n\n        .control-section h3 {\n            font-size: 16px;\n            font-weight: 600;\n            color: var(--anthropic-dark);\n            margin-bottom: 16px;\n            display: flex;\n            align-items: center;\n            gap: 8px;\n        }\n\n        .control-section h3::before {\n            content: '•';\n            color: var(--anthropic-orange);\n            font-weight: bold;\n        }\n\n        /* Seed Controls */\n        .seed-input {\n            width: 100%;\n            background: var(--anthropic-light);\n            padding: 12px;\n            border-radius: 8px;\n            font-family: 'Courier New', monospace;\n            font-size: 14px;\n            margin-bottom: 12px;\n            border: 1px solid var(--anthropic-light-gray);\n            text-align: center;\n        }\n\n        .seed-input:focus {\n            outline: none;\n            border-color: var(--anthropic-orange);\n            box-shadow: 0 0 0 2px rgba(217, 119, 87, 0.1);\n            background: white;\n        }\n\n        .seed-controls {\n            display: grid;\n            grid-template-columns: 1fr 1fr;\n            gap: 8px;\n            margin-bottom: 8px;\n        }\n\n        .regen-button {\n            margin-bottom: 0;\n        }\n\n        /* Parameter Controls */\n        .control-group {\n            margin-bottom: 20px;\n        }\n\n        .control-group label {\n            display: block;\n            font-size: 14px;\n            font-weight: 500;\n            color: var(--anthropic-dark);\n            margin-bottom: 8px;\n        }\n\n        .slider-container {\n            display: flex;\n            align-items: center;\n            gap: 12px;\n        }\n\n        .slider-container input[type=\"range\"] {\n            flex: 1;\n            height: 4px;\n            background: var(--anthropic-light-gray);\n            border-radius: 2px;\n            outline: none;\n            -webkit-appearance: none;\n        }\n\n        .slider-container input[type=\"range\"]::-webkit-slider-thumb {\n            -webkit-appearance: none;\n            width: 16px;\n            height: 16px;\n            background: var(--anthropic-orange);\n            border-radius: 50%;\n            cursor: pointer;\n            transition: all 0.2s ease;\n        }\n\n        .slider-container input[type=\"range\"]::-webkit-slider-thumb:hover {\n            transform: scale(1.1);\n            background: #c86641;\n        }\n\n        .slider-container input[type=\"range\"]::-moz-range-thumb {\n            width: 16px;\n            height: 16px;\n            background: var(--anthropic-orange);\n            border-radius: 50%;\n            border: none;\n            cursor: pointer;\n            transition: all 0.2s ease;\n        }\n\n        .value-display {\n            font-family: 'Courier New', monospace;\n            font-size: 12px;\n            color: var(--anthropic-mid-gray);\n            min-width: 60px;\n            text-align: right;\n        }\n\n        /* Color Pickers */\n        .color-group {\n            margin-bottom: 16px;\n        }\n\n        .color-group label {\n            display: block;\n            font-size: 12px;\n            color: var(--anthropic-mid-gray);\n            margin-bottom: 4px;\n        }\n\n        .color-picker-container {\n            display: flex;\n            align-items: center;\n            gap: 8px;\n        }\n\n        .color-picker-container input[type=\"color\"] {\n            width: 32px;\n            height: 32px;\n            border: none;\n            border-radius: 6px;\n            cursor: pointer;\n            background: none;\n            padding: 0;\n        }\n\n        .color-value {\n            font-family: 'Courier New', monospace;\n            font-size: 12px;\n            color: var(--anthropic-mid-gray);\n        }\n\n        /* Buttons */\n        .button {\n            background: var(--anthropic-orange);\n            color: white;\n            border: none;\n            padding: 10px 16px;\n            border-radius: 6px;\n            font-size: 14px;\n            font-weight: 500;\n            cursor: pointer;\n            transition: all 0.2s ease;\n            width: 100%;\n        }\n\n        .button:hover {\n            background: #c86641;\n            transform: translateY(-1px);\n        }\n\n        .button:active {\n            transform: translateY(0);\n        }\n\n        .button.secondary {\n            background: var(--anthropic-blue);\n        }\n\n        .button.secondary:hover {\n            background: #5a8bb8;\n        }\n\n        .button.tertiary {\n            background: var(--anthropic-green);\n        }\n\n        .button.tertiary:hover {\n            background: #6b7b52;\n        }\n\n        .button-row {\n            display: flex;\n            gap: 8px;\n        }\n\n        .button-row .button {\n            flex: 1;\n        }\n\n        /* Canvas Area */\n        .canvas-area {\n            flex: 1;\n            display: flex;\n            align-items: center;\n            justify-content: center;\n            min-width: 0;\n        }\n\n        #canvas-container {\n            width: 100%;\n            max-width: 1000px;\n            border-radius: 12px;\n            overflow: hidden;\n            box-shadow: 0 20px 40px rgba(20, 20, 19, 0.1);\n            background: white;\n        }\n\n        #canvas-container canvas {\n            display: block;\n            width: 100% !important;\n            height: auto !important;\n        }\n\n        /* Loading State */\n        .loading {\n            display: flex;\n            align-items: center;\n            justify-content: center;\n            font-size: 18px;\n            color: var(--anthropic-mid-gray);\n        }\n\n        /* Responsive - Stack on mobile */\n        @media (max-width: 600px) {\n            .container {\n                flex-direction: column;\n            }\n\n            .sidebar {\n                width: 100%;\n            }\n\n            .canvas-area {\n                padding: 20px;\n            }\n        }\n    </style>\n</head>\n<body>\n    <div class=\"container\">\n        <!-- Control Sidebar -->\n        <div class=\"sidebar\">\n            <!-- Headers (CUSTOMIZE THIS FOR YOUR ART) -->\n            <h1>TITLE - EDIT</h1>\n            <div class=\"subtitle\">SUBHEADER - EDIT</div>\n\n            <!-- Seed Section (ALWAYS KEEP THIS) -->\n            <div class=\"control-section\">\n                <h3>Seed</h3>\n                <input type=\"number\" id=\"seed-input\" class=\"seed-input\" value=\"12345\" onchange=\"updateSeed()\">\n                <div class=\"seed-controls\">\n                    <button class=\"button secondary\" onclick=\"previousSeed()\">← Prev</button>\n                    <button class=\"button secondary\" onclick=\"nextSeed()\">Next →</button>\n                </div>\n                <button class=\"button tertiary regen-button\" onclick=\"randomSeedAndUpdate()\">↻ Random</button>\n            </div>\n\n            <!-- Parameters Section (CUSTOMIZE THIS FOR YOUR ART) -->\n            <div class=\"control-section\">\n                <h3>Parameters</h3>\n                \n                <!-- Particle Count -->\n                <div class=\"control-group\">\n                    <label>Particle Count</label>\n                    <div class=\"slider-container\">\n                        <input type=\"range\" id=\"particleCount\" min=\"1000\" max=\"10000\" step=\"500\" value=\"5000\" oninput=\"updateParam('particleCount', this.value)\">\n                        <span class=\"value-display\" id=\"particleCount-value\">5000</span>\n                    </div>\n                </div>\n\n                <!-- Flow Speed -->\n                <div class=\"control-group\">\n                    <label>Flow Speed</label>\n                    <div class=\"slider-container\">\n                        <input type=\"range\" id=\"flowSpeed\" min=\"0.1\" max=\"2.0\" step=\"0.1\" value=\"0.5\" oninput=\"updateParam('flowSpeed', this.value)\">\n                        <span class=\"value-display\" id=\"flowSpeed-value\">0.5</span>\n                    </div>\n                </div>\n\n                <!-- Noise Scale -->\n                <div class=\"control-group\">\n                    <label>Noise Scale</label>\n                    <div class=\"slider-container\">\n                        <input type=\"range\" id=\"noiseScale\" min=\"0.001\" max=\"0.02\" step=\"0.001\" value=\"0.005\" oninput=\"updateParam('noiseScale', this.value)\">\n                        <span class=\"value-display\" id=\"noiseScale-value\">0.005</span>\n                    </div>\n                </div>\n\n                <!-- Trail Length -->\n                <div class=\"control-group\">\n                    <label>Trail Length</label>\n                    <div class=\"slider-container\">\n                        <input type=\"range\" id=\"trailLength\" min=\"2\" max=\"20\" step=\"1\" value=\"8\" oninput=\"updateParam('trailLength', this.value)\">\n                        <span class=\"value-display\" id=\"trailLength-value\">8</span>\n                    </div>\n                </div>\n            </div>\n\n            <!-- Colors Section (OPTIONAL - CUSTOMIZE OR REMOVE) -->\n            <div class=\"control-section\">\n                <h3>Colors</h3>\n                \n                <!-- Color 1 -->\n                <div class=\"color-group\">\n                    <label>Primary Color</label>\n                    <div class=\"color-picker-container\">\n                        <input type=\"color\" id=\"color1\" value=\"#d97757\" onchange=\"updateColor('color1', this.value)\">\n                        <span class=\"color-value\" id=\"color1-value\">#d97757</span>\n                    </div>\n                </div>\n\n                <!-- Color 2 -->\n                <div class=\"color-group\">\n                    <label>Secondary Color</label>\n                    <div class=\"color-picker-container\">\n                        <input type=\"color\" id=\"color2\" value=\"#6a9bcc\" onchange=\"updateColor('color2', this.value)\">\n                        <span class=\"color-value\" id=\"color2-value\">#6a9bcc</span>\n                    </div>\n                </div>\n\n                <!-- Color 3 -->\n                <div class=\"color-group\">\n                    <label>Accent Color</label>\n                    <div class=\"color-picker-container\">\n                        <input type=\"color\" id=\"color3\" value=\"#788c5d\" onchange=\"updateColor('color3', this.value)\">\n                        <span class=\"color-value\" id=\"color3-value\">#788c5d</span>\n                    </div>\n                </div>\n            </div>\n\n            <!-- Actions Section (ALWAYS KEEP THIS) -->\n            <div class=\"control-section\">\n                <h3>Actions</h3>\n                <div class=\"button-row\">\n                    <button class=\"button\" onclick=\"resetParameters()\">Reset</button>\n                </div>\n            </div>\n        </div>\n\n        <!-- Main Canvas Area -->\n        <div class=\"canvas-area\">\n            <div id=\"canvas-container\">\n                <div class=\"loading\">Initializing generative art...</div>\n            </div>\n        </div>\n    </div>\n\n    <script>\n        // ═══════════════════════════════════════════════════════════════════════\n        // GENERATIVE ART PARAMETERS - CUSTOMIZE FOR YOUR ALGORITHM\n        // ═══════════════════════════════════════════════════════════════════════\n\n        let params = {\n            seed: 12345,\n            particleCount: 5000,\n            flowSpeed: 0.5,\n            noiseScale: 0.005,\n            trailLength: 8,\n            colorPalette: ['#d97757', '#6a9bcc', '#788c5d']\n        };\n\n        let defaultParams = {...params}; // Store defaults for reset\n\n        // ═══════════════════════════════════════════════════════════════════════\n        // P5.JS GENERATIVE ART ALGORITHM - REPLACE WITH YOUR VISION\n        // ═══════════════════════════════════════════════════════════════════════\n\n        let particles = [];\n        let flowField = [];\n        let cols, rows;\n        let scl = 10; // Flow field resolution\n\n        function setup() {\n            let canvas = createCanvas(1200, 1200);\n            canvas.parent('canvas-container');\n            \n            initializeSystem();\n            \n            // Remove loading message\n            document.querySelector('.loading').style.display = 'none';\n        }\n\n        function initializeSystem() {\n            // Seed the randomness for reproducibility\n            randomSeed(params.seed);\n            noiseSeed(params.seed);\n\n            // Clear particles and recreate\n            particles = [];\n            \n            // Initialize particles\n            for (let i = 0; i < params.particleCount; i++) {\n                particles.push(new Particle());\n            }\n\n            // Calculate flow field dimensions\n            cols = floor(width / scl);\n            rows = floor(height / scl);\n            \n            // Generate flow field\n            generateFlowField();\n\n            // Clear background\n            background(250, 249, 245); // Anthropic light background\n        }\n\n        function generateFlowField() {\n          // fill this in\n        }\n\n        function draw() {\n            // fill this in\n        }\n\n        // ═══════════════════════════════════════════════════════════════════════\n        // PARTICLE SYSTEM - CUSTOMIZE FOR YOUR ALGORITHM\n        // ═══════════════════════════════════════════════════════════════════════\n\n        class Particle {\n            constructor() {\n                // fill this in\n            }\n            // fill this in\n        }\n\n        // ═══════════════════════════════════════════════════════════════════════\n        // UI CONTROL HANDLERS - CUSTOMIZE FOR YOUR PARAMETERS\n        // ═══════════════════════════════════════════════════════════════════════\n\n        function updateParam(paramName, value) {\n            // fill this in\n        }\n\n        function updateColor(colorId, value) {\n            // fill this in\n        }\n\n        // ═══════════════════════════════════════════════════════════════════════\n        // SEED CONTROL FUNCTIONS - ALWAYS KEEP THESE\n        // ═══════════════════════════════════════════════════════════════════════\n\n        function updateSeedDisplay() {\n            document.getElementById('seed-input').value = params.seed;\n        }\n\n        function updateSeed() {\n            let input = document.getElementById('seed-input');\n            let newSeed = parseInt(input.value);\n            if (newSeed && newSeed > 0) {\n                params.seed = newSeed;\n                initializeSystem();\n            } else {\n                // Reset to current seed if invalid\n                updateSeedDisplay();\n            }\n        }\n\n        function previousSeed() {\n            params.seed = Math.max(1, params.seed - 1);\n            updateSeedDisplay();\n            initializeSystem();\n        }\n\n        function nextSeed() {\n            params.seed = params.seed + 1;\n            updateSeedDisplay();\n            initializeSystem();\n        }\n\n        function randomSeedAndUpdate() {\n            params.seed = Math.floor(Math.random() * 999999) + 1;\n            updateSeedDisplay();\n            initializeSystem();\n        }\n\n        function resetParameters() {\n            params = {...defaultParams};\n            \n            // Update UI elements\n            document.getElementById('particleCount').value = params.particleCount;\n            document.getElementById('particleCount-value').textContent = params.particleCount;\n            document.getElementById('flowSpeed').value = params.flowSpeed;\n            document.getElementById('flowSpeed-value').textContent = params.flowSpeed;\n            document.getElementById('noiseScale').value = params.noiseScale;\n            document.getElementById('noiseScale-value').textContent = params.noiseScale;\n            document.getElementById('trailLength').value = params.trailLength;\n            document.getElementById('trailLength-value').textContent = params.trailLength;\n            \n            // Reset colors\n            document.getElementById('color1').value = params.colorPalette[0];\n            document.getElementById('color1-value').textContent = params.colorPalette[0];\n            document.getElementById('color2').value = params.colorPalette[1];\n            document.getElementById('color2-value').textContent = params.colorPalette[1];\n            document.getElementById('color3').value = params.colorPalette[2];\n            document.getElementById('color3-value').textContent = params.colorPalette[2];\n            \n            updateSeedDisplay();\n            initializeSystem();\n        }\n\n        // Initialize UI on load\n        window.addEventListener('load', function() {\n            updateSeedDisplay();\n        });\n    </script>\n</body>\n</html>"
      }
    ]
  }
]

export default children
