// AUTO-GENERATED — DO NOT EDIT
// Source: https://github.com/anthropics/skills
import type { SkillTemplateNode } from '../types'

const children: SkillTemplateNode[] = [
  {
    "name": "SKILL.md",
    "node_type": "file",
    "content": "---\nname: internal-comms\ndescription: A set of resources to help me write all kinds of internal communications, using the formats that my company likes to use. Claude should use this skill whenever asked to write some sort of internal communications (status reports, leadership updates, 3P updates, company newsletters, FAQs, incident reports, project updates, etc.).\nlicense: Complete terms in LICENSE.txt\n---\n\n## When to use this skill\nTo write internal communications, use this skill for:\n- 3P updates (Progress, Plans, Problems)\n- Company newsletters\n- FAQ responses\n- Status reports\n- Leadership updates\n- Project updates\n- Incident reports\n\n## How to use this skill\n\nTo write any internal communication:\n\n1. **Identify the communication type** from the request\n2. **Load the appropriate guideline file** from the `examples/` directory:\n    - `examples/3p-updates.md` - For Progress/Plans/Problems team updates\n    - `examples/company-newsletter.md` - For company-wide newsletters\n    - `examples/faq-answers.md` - For answering frequently asked questions\n    - `examples/general-comms.md` - For anything else that doesn't explicitly match one of the above\n3. **Follow the specific instructions** in that file for formatting, tone, and content gathering\n\nIf the communication type doesn't match any existing guideline, ask for clarification or more context about the desired format.\n\n## Keywords\n3P updates, company newsletter, company comms, weekly update, faqs, common questions, updates, internal comms\n"
  },
  {
    "name": "examples",
    "node_type": "folder",
    "children": [
      {
        "name": "3p-updates.md",
        "node_type": "file",
        "content": "## Instructions\nYou are being asked to write a 3P update. 3P updates stand for \"Progress, Plans, Problems.\" The main audience is for executives, leadership, other teammates, etc. They're meant to be very succinct and to-the-point: think something you can read in 30-60sec or less. They're also for people with some, but not a lot of context on what the team does.\n\n3Ps can cover a team of any size, ranging all the way up to the entire company. The bigger the team, the less granular the tasks should be. For example, \"mobile team\" might have \"shipped feature\" or \"fixed bugs,\" whereas the company might have really meaty 3Ps, like \"hired 20 new people\" or \"closed 10 new deals.\" \n\nThey represent the work of the team across a time period, almost always one week. They include three sections:\n1) Progress: what the team has accomplished over the next time period. Focus mainly on things shipped, milestones achieved, tasks created, etc.\n2) Plans: what the team plans to do over the next time period. Focus on what things are top-of-mind, really high priority, etc. for the team.\n3) Problems: anything that is slowing the team down. This could be things like too few people, bugs or blockers that are preventing the team from moving forward, some deal that fell through, etc.\n\nBefore writing them, make sure that you know the team name. If it's not specified, you can ask explicitly what the team name you're writing for is.\n\n\n## Tools Available\nWhenever possible, try to pull from available sources to get the information you need:\n- Slack: posts from team members with their updates - ideally look for posts in large channels with lots of reactions\n- Google Drive: docs written from critical team members with lots of views\n- Email: emails with lots of responses of lots of content that seems relevant\n- Calendar: non-recurring meetings that have a lot of importance, like product reviews, etc.\n\n\nTry to gather as much context as you can, focusing on the things that covered the time period you're writing for:\n- Progress: anything between a week ago and today\n- Plans: anything from today to the next week\n- Problems: anything between a week ago and today\n\n\nIf you don't have access, you can ask the user for things they want to cover. They might also include these things to you directly, in which case you're mostly just formatting for this particular format.\n\n## Workflow\n\n1. **Clarify scope**: Confirm the team name and time period (usually past week for Progress/Problems, next\nweek for Plans)\n2. **Gather information**: Use available tools or ask the user directly\n3. **Draft the update**: Follow the strict formatting guidelines\n4. **Review**: Ensure it's concise (30-60 seconds to read) and data-driven\n\n## Formatting\n\nThe format is always the same, very strict formatting. Never use any formatting other than this. Pick an emoji that is fun and captures the vibe of the team and update.\n\n[pick an emoji] [Team Name] (Dates Covered, usually a week)\nProgress: [1-3 sentences of content]\nPlans: [1-3 sentences of content]\nProblems: [1-3 sentences of content]\n\nEach section should be no more than 1-3 sentences: clear, to the point. It should be data-driven, and generally include metrics where possible. The tone should be very matter-of-fact, not super prose-heavy."
      },
      {
        "name": "company-newsletter.md",
        "node_type": "file",
        "content": "## Instructions\nYou are being asked to write a company-wide newsletter update. You are meant to summarize the past week/month of a company in the form of a newsletter that the entire company will read. It should be maybe ~20-25 bullet points long. It will be sent via Slack and email, so make it consumable for that.\n\nIdeally it includes the following attributes:\n- Lots of links: pulling documents from Google Drive that are very relevant, linking to prominent Slack messages in announce channels and from executives, perhgaps referencing emails that went company-wide, highlighting significant things that have happened in the company.\n- Short and to-the-point: each bullet should probably be no longer than ~1-2 sentences\n- Use the \"we\" tense, as you are part of the company. Many of the bullets should say \"we did this\" or \"we did that\"\n\n## Tools to use\nIf you have access to the following tools, please try to use them. If not, you can also let the user know directly that their responses would be better if they gave them access.\n\n- Slack: look for messages in channels with lots of people, with lots of reactions or lots of responses within the thread\n- Email: look for things from executives that discuss company-wide announcements\n- Calendar: if there were meetings with large attendee lists, particularly things like All-Hands meetings, big company announcements, etc. If there were documents attached to those meetings, those are great links to include.\n- Documents: if there were new docs published in the last week or two that got a lot of attention, you can link them. These should be things like company-wide vision docs, plans for the upcoming quarter or half, things authored by critical executives, etc.\n- External press: if you see references to articles or press we've received over the past week, that could be really cool too.\n\nIf you don't have access to any of these things, you can ask the user for things they want to cover. In this case, you'll mostly just be polishing up and fitting to this format more directly.\n\n## Sections\nThe company is pretty big: 1000+ people. There are a variety of different teams and initiatives going on across the company. To make sure the update works well, try breaking it into sections of similar things. You might break into clusters like {product development, go to market, finance} or {recruiting, execution, vision}, or {external news, internal news} etc. Try to make sure the different areas of the company are highlighted well.\n\n## Prioritization\nFocus on:\n- Company-wide impact (not team-specific details)\n- Announcements from leadership\n- Major milestones and achievements\n- Information that affects most employees\n- External recognition or press\n\nAvoid:\n- Overly granular team updates (save those for 3Ps)\n- Information only relevant to small groups\n- Duplicate information already communicated\n\n## Example Formats\n\n:megaphone: Company Announcements\n- Announcement 1\n- Announcement 2\n- Announcement 3\n\n:dart: Progress on Priorities\n- Area 1\n    - Sub-area 1\n    - Sub-area 2\n    - Sub-area 3\n- Area 2\n    - Sub-area 1\n    - Sub-area 2\n    - Sub-area 3\n- Area 3\n    - Sub-area 1\n    - Sub-area 2\n    - Sub-area 3\n\n:pillar: Leadership Updates\n- Post 1\n- Post 2\n- Post 3\n\n:thread: Social Updates\n- Update 1\n- Update 2\n- Update 3\n"
      },
      {
        "name": "faq-answers.md",
        "node_type": "file",
        "content": "## Instructions\nYou are an assistant for answering questions that are being asked across the company. Every week, there are lots of questions that get asked across the company, and your goal is to try to summarize what those questions are. We want our company to be well-informed and on the same page, so your job is to produce a set of frequently asked questions that our employees are asking and attempt to answer them. Your singular job is to do two things:\n\n- Find questions that are big sources of confusion for lots of employees at the company, generally about things that affect a large portion of the employee base\n- Attempt to give a nice summarized answer to that question in order to minimize confusion.\n\nSome examples of areas that may be interesting to folks: recent corporate events (fundraising, new executives, etc.), upcoming launches, hiring progress, changes to vision or focus, etc.\n\n\n## Tools Available\nYou should use the company's available tools, where communication and work happens. For most companies, it looks something like this:\n- Slack: questions being asked across the company - it could be questions in response to posts with lots of responses, questions being asked with lots of reactions or thumbs up to show support, or anything else to show that a large number of employees want to ask the same things\n- Email: emails with FAQs written directly in them can be a good source as well\n- Documents: docs in places like Google Drive, linked on calendar events, etc. can also be a good source of FAQs, either directly added or inferred based on the contents of the doc\n\n## Formatting\nThe formatting should be pretty basic:\n\n- *Question*: [insert question - 1 sentence]\n- *Answer*: [insert answer - 1-2 sentence]\n\n## Guidance\nMake sure you're being holistic in your questions. Don't focus too much on just the user in question or the team they are a part of, but try to capture the entire company. Try to be as holistic as you can in reading all the tools available, producing responses that are relevant to all at the company.\n\n## Answer Guidelines\n- Base answers on official company communications when possible\n- If information is uncertain, indicate that clearly\n- Link to authoritative sources (docs, announcements, emails)\n- Keep tone professional but approachable\n- Flag if a question requires executive input or official response"
      },
      {
        "name": "general-comms.md",
        "node_type": "file",
        "content": "  ## Instructions\n  You are being asked to write internal company communication that doesn't fit into the standard formats (3P\n  updates, newsletters, or FAQs).\n\n  Before proceeding:\n  1. Ask the user about their target audience\n  2. Understand the communication's purpose\n  3. Clarify the desired tone (formal, casual, urgent, informational)\n  4. Confirm any specific formatting requirements\n\n  Use these general principles:\n  - Be clear and concise\n  - Use active voice\n  - Put the most important information first\n  - Include relevant links and references\n  - Match the company's communication style"
      }
    ]
  }
]

export default children
