/**
 * Sandbox File Types
 *
 * Types for sandbox file API - file listing and download operations.
 * These files are generated by agent during test runs and may be cleared later.
 */

/**
 * Sandbox file node from API (flat format)
 * Returned by GET /apps/{app_id}/sandbox/files
 */
export type SandboxFileNode = {
  /** Relative path (POSIX format), e.g. "folder/file.txt" */
  path: string
  /** Whether this is a directory */
  is_dir: boolean
  /** File size in bytes (null for directories) */
  size: number | null
  /** Modification timestamp in seconds (null for some directories) */
  mtime: number | null
  /** File extension (null for directories) */
  extension: string | null
}

/**
 * Download ticket returned by POST /apps/{app_id}/sandbox/files/download
 */
export type SandboxFileDownloadTicket = {
  /** Signed download URL */
  download_url: string
  /** Expiration time in seconds */
  expires_in: number
  /** Export ID (16-char hex) */
  export_id: string
}

/**
 * Tree node for frontend rendering (converted from flat list)
 */
export type SandboxFileTreeNode = {
  /** Unique ID (uses path as ID) */
  id: string
  /** File/folder name extracted from path */
  name: string
  /** Full relative path */
  path: string
  /** Node type for compatibility with existing tree components */
  node_type: 'file' | 'folder'
  /** File size in bytes (null for directories) */
  size: number | null
  /** Modification timestamp */
  mtime: number | null
  /** File extension (null for directories) */
  extension: string | null
  /** Child nodes (for folders) */
  children: SandboxFileTreeNode[]
}

/**
 * Request payload for listing files
 */
export type SandboxFileListQuery = {
  /** Workspace-relative path, defaults to "." */
  path?: string
  /** Whether to list recursively */
  recursive?: boolean
}

/**
 * Request payload for downloading a file
 */
export type SandboxFileDownloadRequest = {
  /** Workspace-relative file path */
  path: string
}
