/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.exceptions.AndrolibException;
import brut.common.BrutException;
import brut.util.Jar;
import brut.util.OS;
import brut.util.OSDetection;
import java.io.File;

public abstract class AaptManager {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getBinaryFile() {
        StringBuilder stringBuilder;
        if (!OSDetection.is64Bit()) throw new AndrolibException("aapt2 binaries are not available for 32-bit platforms.");
        Comparable<StringBuilder> comparable = stringBuilder;
        stringBuilder = new StringBuilder("/prebuilt/");
        String string = OSDetection.OS;
        if (!(string.contains("nix") || string.contains("nux") || string.contains("aix") || string.contains("sunos"))) {
            if (string.contains("mac")) {
                ((StringBuilder)comparable).append("macosx");
            } else {
                if (!string.contains("win")) throw new AndrolibException("Could not identify platform: ".concat(string));
                ((StringBuilder)comparable).append("windows");
            }
        } else {
            ((StringBuilder)comparable).append("linux");
        }
        ((StringBuilder)comparable).append("/aapt2");
        if (string.contains("win")) {
            ((StringBuilder)comparable).append(".exe");
        }
        try {
            comparable = Jar.getResourceAsFile(((StringBuilder)comparable).toString());
            if (!((File)comparable).isFile() || !((File)comparable).canRead()) throw new AndrolibException("Could not read aapt binary: " + ((File)comparable).getPath());
            if (!((File)comparable).setExecutable(true)) throw new AndrolibException("Could not set aapt binary as executable: " + ((File)comparable).getPath());
            return comparable;
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }

    public static int getBinaryVersion(File file) {
        if (file.isFile() && file.canRead()) {
            if (file.setExecutable(true)) {
                String string = file.getPath();
                if ((string = OS.execAndReturn(new String[]{string, "version"})) != null) {
                    if (string.startsWith("Android Asset Packaging Tool (aapt) 2:")) {
                        return 2;
                    }
                    if (string.startsWith("Android Asset Packaging Tool (aapt) 2.")) {
                        return 2;
                    }
                    if (string.startsWith("Android Asset Packaging Tool, v0.")) {
                        return 1;
                    }
                    throw new AndrolibException("Could not identify aapt binary version: ".concat(string));
                }
                throw new AndrolibException("Could not execute aapt binary at location: " + file.getPath());
            }
            throw new AndrolibException("Could not set aapt binary as executable: " + file.getPath());
        }
        throw new AndrolibException("Could not read aapt binary: " + file.getPath());
    }
}

