/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResChunkHeader;
import brut.androlib.res.data.ResStringPool;
import brut.androlib.res.decoder.ResChunkPullParser;
import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResOverlayable;
import brut.androlib.res.table.ResOverlayable$Policy;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.ResPackageGroup;
import brut.androlib.res.table.ResTable;
import brut.androlib.res.table.ResType;
import brut.androlib.res.table.ResTypeSpec;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResBag$RawItem;
import brut.androlib.res.table.value.ResCustom;
import brut.androlib.res.table.value.ResFileReference;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResString;
import brut.androlib.res.table.value.ResValue;
import brut.common.Log;
import brut.util.BinaryDataInputStream;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.io.BaseEncoding$Alphabet;
import com.google.common.io.BaseEncoding$Base16Encoding;
import com.google.common.io.ByteStreams;
import com.google.common.math.IntMath;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.apache.commons.lang3.tuple.Pair;

public final class BinaryResourceParser {
    public static final String TAG;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final ResTable mTable;
    public final boolean mKeepBrokenResources;
    public final boolean mAllowDummyEntrySpecs;
    public final HashSet mMissingEntrySpecs;
    public final HashSet mInvalidConfigs;
    public BinaryDataInputStream mIn;
    public ResStringPool mValueStringPool;
    public int mPackageCount;
    public ResPackage mPackage;
    public int mTypeIdOffset;
    public ResStringPool mTypeStringPool;
    public ResStringPool mKeyStringPool;
    public boolean mSparseEntries;
    public boolean mCompactEntries;
    public ArrayList mEntrySpecFlagsOffsets;

    public BinaryResourceParser(ResTable resTable, boolean bl, boolean bl2) {
        HashSet hashSet;
        HashSet hashSet2;
        ((BinaryResourceParser)object).mTable = resTable;
        ((BinaryResourceParser)object).mKeepBrokenResources = bl;
        ((BinaryResourceParser)object).mAllowDummyEntrySpecs = bl2;
        Object object = hashSet2;
        hashSet2 = new HashSet();
        v1.mMissingEntrySpecs = object;
        object = hashSet;
        hashSet = new HashSet();
        v1.mInvalidConfigs = object;
    }

    static {
        $assertionsDisabled = BinaryResourceParser.class.desiredAssertionStatus() ^ true;
        TAG = BinaryResourceParser.class.getName();
    }

    public static boolean nextChunk(ResChunkPullParser object) {
        Object[] objectArray;
        Object object2;
        Object object3;
        int n;
        if (((ResChunkPullParser)object).mChunkHeader != null && (n = ((ResChunkPullParser)object).skipChunk()) > 0) {
            String string = TAG;
            object3 = n;
            object2 = ((ResChunkPullParser)object).chunkName();
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = object3;
            objectArray2[1] = object2;
            Log.log(Level.FINE, string, "Skipped unknown %s bytes at end of %s chunk.", objectArray);
        }
        while (((ResChunkPullParser)object).next()) {
            if (((ResChunkPullParser)object).chunkType() == 0) {
                ResChunkPullParser resChunkPullParser = object;
                String string = TAG;
                object3 = resChunkPullParser.chunkName();
                object2 = resChunkPullParser.chunkSize();
                objectArray = resChunkPullParser.chunkStart();
                Object[] objectArray3 = new Object[3];
                Object[] objectArray4 = objectArray3;
                objectArray3[0] = object3;
                objectArray3[1] = object2;
                objectArray3[2] = objectArray;
                Log.log(Level.FINE, string, "Skipping unknown chunk (%s) of %s bytes at 0x%08x.", objectArray4);
                resChunkPullParser.skipChunk();
                continue;
            }
            ResChunkPullParser resChunkPullParser = object;
            object = TAG;
            Long l = resChunkPullParser.chunkStart();
            object3 = resChunkPullParser.chunkName();
            object2 = resChunkPullParser.chunkSize();
            Object[] objectArray5 = new Object[3];
            objectArray = objectArray5;
            objectArray5[0] = l;
            objectArray5[1] = object3;
            objectArray5[2] = object2;
            Log.log(Level.FINE, (String)object, "Chunk at 0x%08x: %s (%s bytes)", objectArray);
            return true;
        }
        return false;
    }

    public static String unpackLanguageOrRegion(byte[] byArray, char c) {
        if (!$assertionsDisabled && byArray.length != 2) {
            throw new AssertionError();
        }
        byte by = byArray[0];
        if (by == 0) {
            return "";
        }
        if ((by & 0x80) != 0) {
            byte[] byArray2 = new byte[3];
            byte[] byArray3 = byArray2;
            char c2 = c;
            int n = byArray[1];
            byArray3[0] = (byte)(c + (n & 0x1F));
            n = c + ((n & 0xE0) >>> 5);
            c = byArray[0];
            byArray3[1] = (byte)(n + ((c & 3) << 3));
            byArray2[2] = (byte)(c2 + ((c & 0x7C) >>> 2));
            byArray = byArray3;
        }
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    public static void skipUnexpectedChunk(ResChunkPullParser object) {
        ResChunkPullParser resChunkPullParser = object;
        object = TAG;
        String string = resChunkPullParser.chunkName();
        Integer n = resChunkPullParser.chunkSize();
        Long l = resChunkPullParser.chunkStart();
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        objectArray[1] = n;
        objectArray[2] = l;
        Log.log(Level.WARNING, (String)object, "Skipping unexpected %s chunk of %s bytes at 0x%08x.", objectArray2);
        resChunkPullParser.skipChunk();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void parse(InputStream var1_2) {
        v0 = this;
        var2_3 = "Unexpected chunk: ";
        v0.mIn = null;
        v0.mMissingEntrySpecs.clear();
        v0.mInvalidConfigs.clear();
        v0.mValueStringPool = null;
        v0.mPackageCount = 0;
        v0.mPackage = null;
        v0.mTypeIdOffset = 0;
        v0.mTypeStringPool = null;
        v0.mKeyStringPool = null;
        v0.mSparseEntries = false;
        v0.mCompactEntries = false;
        var3_4 = v0.mEntrySpecFlagsOffsets;
        if (var3_4 != null) {
            var3_4.clear();
        }
        var3_4 = v1;
        this.mIn = new BinaryDataInputStream((InputStream)var1_2, ByteOrder.LITTLE_ENDIAN, 0x7FFFFFFFFFFFFFFFL);
        var1_2 = v2;
        try {
            if (BinaryResourceParser.nextChunk(new ResChunkPullParser((BinaryDataInputStream)var3_4, 0x7FFFFFFF)) == false) throw new AndrolibException("Input file is empty.");
            if (var1_2.chunkType() == 2) {
                v3 = this;
                v4 = v3;
                v3.parseTable((ResChunkPullParser)var1_2);
                var1_2 = BinaryResourceParser.TAG;
                var2_3 = "End of chunks at 0x%08x";
                var3_4 = v3.mIn.mPosition;
                v5 = new Object[1];
            }
            ** GOTO lbl-1000
        }
        catch (IOException var0_1) {
            throw new AndrolibException("Could not decode arsc file.", var0_1);
        }
        var4_5 = v5;
        {
            v5[0] = var3_4;
        }
        {
            var3_4 = Level.FINE;
        }
        {
            Log.log((Level)var3_4, (String)var1_2, (String)var2_3, var4_5);
            if (v4.mIn.available() <= 0) return;
            v6 = var3_4;
            v7 = var1_2;
            v8 = this;
            this = "Ignoring trailing data at 0x%08x.";
            var1_2 = v8.mIn.mPosition;
            v9 = new Object[1];
        }
        var2_3 = v9;
        v9[0] = var1_2;
        Log.log((Level)v6, (String)v7, this, var2_3);
        return;
lbl-1000:
        // 1 sources

        {
            v10((String)var2_3 + var1_2.chunkName() + " (expected: RES_TABLE_TYPE)");
            throw v10;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void parseTable(ResChunkPullParser var1_3) {
        v0 = var1_3;
        var2_5 = this.mIn.readInt();
        this.skipUnreadHeader((ResChunkPullParser)var1_3);
        var3_9 = this.mIn;
        var4_13 = v0.mChunkHeader;
        if (var4_13 == null) {
            throw new IllegalStateException();
        }
        var1_3 = new ResChunkPullParser((BinaryDataInputStream)var3_9, var4_13.size - var4_13.headerSize);
        while (BinaryResourceParser.nextChunk((ResChunkPullParser)var1_3)) {
            block115: {
                block112: {
                    var3_10 = var1_3.chunkType();
                    if (var3_10 == 1) break block115;
                    if (var3_10 != 512) {
                        BinaryResourceParser.skipUnexpectedChunk((ResChunkPullParser)var1_3);
                        continue;
                    }
                    var3_10 = this.mIn.readInt();
                    var4_13 = this.mIn.readUtf16(128);
                    this.mIn.readInt();
                    this.mIn.readInt();
                    this.mIn.readInt();
                    this.mIn.readInt();
                    var5_19 = var1_3.mChunkHeader;
                    if (var5_19 == null) {
                        throw new IllegalStateException();
                    }
                    if (var5_19.headerSize >= 288) {
                        this.mTypeIdOffset = this.mIn.readInt();
                        if (this.mTypeIdOffset > 0) {
                            Log.log(Level.WARNING, BinaryResourceParser.TAG, "Please report this app here: https://github.com/iBotPeaches/Apktool/issues/1728");
                        }
                    } else {
                        this.mTypeIdOffset = 0;
                    }
                    this.skipUnreadHeader((ResChunkPullParser)var1_3);
                    var5_19 = this.mTable.getPackageGroup(var3_10);
                    {
                        catch (Throwable var1_4) {
                            break block112;
                        }
                        catch (UndefinedResObjectException v1) {}
                        {
                            this.mPackage = (ResPackage)this.mTable.addPackageGroup((int)var3_10, (String)var4_13).mPackages.get(0);
                            ** GOTO lbl50
                        }
                    }
                    var6_29 = v2;
                    {
                        v3 = var5_19;
                        v2 = new ResPackage((ResPackageGroup)v3, v3.mPackages.size());
                        var5_19.mPackages.add(var6_29);
                    }
                    {
                        this.mPackage = var6_29;
lbl50:
                        // 2 sources

                        ++this.mPackageCount;
                    }
                    var4_13 = this.mIn;
                    var5_19 = var1_3.mChunkHeader;
                    if (var5_19 == null) {
                        throw new IllegalStateException();
                    }
                    var3_11 = new ResChunkPullParser((BinaryDataInputStream)var4_13, var5_19.size - var5_19.headerSize);
                    block30: while (BinaryResourceParser.nextChunk((ResChunkPullParser)var3_11)) {
                        block116: {
                            block117: {
                                block113: {
                                    block119: {
                                        block118: {
                                            var4_14 = var3_11.chunkType();
                                            if (var4_14 == 1) break block116;
                                            if (var4_14 == 518) break block117;
                                            switch (var4_14) {
                                                default: {
                                                    BinaryResourceParser.skipUnexpectedChunk((ResChunkPullParser)var3_11);
                                                    continue block30;
                                                }
                                                case 516: {
                                                    var4_15 = this.mIn.readUtf16(256);
                                                    var5_20 = this.mIn.readUtf16(256);
                                                    this.skipUnreadHeader((ResChunkPullParser)var3_11);
                                                    if (var4_15.isEmpty()) continue block30;
                                                    try {
                                                        var6_30 = this.mPackage;
                                                    }
                                                    catch (UndefinedResObjectException v4) {
                                                        var6_30 = this.mPackage;
                                                        if ((ResOverlayable)var6_30.mOverlayables.get(var4_15) != null) ** GOTO lbl107
                                                        var7_41 = v5;
                                                        v5 = new ResOverlayable((ResPackage)var6_30, (String)var4_15, (String)var5_20);
                                                        var6_30.mOverlayables.put(var4_15, var7_41);
                                                        ** GOTO lbl84
                                                    }
                                                    {
                                                        var7_41 = (ResOverlayable)var6_30.mOverlayables.get(var4_15);
                                                        if (var7_41 != null) ** GOTO lbl84
                                                    }
                                                    {
                                                        var6_30 = var6_30.mGroup.mId;
                                                        throw new UndefinedResObjectException(String.format("overlayable: pkgId=0x%02x, name=%s", new Object[]{var6_30, var4_15}));
                                                    }
lbl84:
                                                    // 2 sources

                                                    var5_20 = this.mIn;
                                                    var6_30 = var3_11.mChunkHeader;
                                                    if (var6_30 == null) {
                                                        throw new IllegalStateException();
                                                    }
                                                    var4_15 = new ResChunkPullParser((BinaryDataInputStream)var5_20, var6_30.size - var6_30.headerSize);
                                                    while (BinaryResourceParser.nextChunk((ResChunkPullParser)var4_15)) {
                                                        if (var4_15.chunkType() != 517) {
                                                            BinaryResourceParser.skipUnexpectedChunk((ResChunkPullParser)var4_15);
                                                            continue;
                                                        }
                                                        var5_21 = this.mIn.readInt();
                                                        var6_31 = this.mIn.readInt();
                                                        this.skipUnreadHeader((ResChunkPullParser)var4_15);
                                                        var8_45 = new ResId[var6_31];
                                                        var9_51 = 0;
                                                        for (var10_54 = 0; var10_54 < var6_31; ++var10_54) {
                                                            var8_45[var9_51++] = ResId.of(this.mIn.readInt());
                                                        }
                                                        if (var9_51 < var6_31) {
                                                            var8_45 = (ResId[])Arrays.copyOf(var8_45, var9_51);
                                                        }
                                                        var7_41.mPolicies.add(new ResOverlayable$Policy(var5_21, (ResId[])var8_45));
                                                    }
                                                    continue block30;
lbl107:
                                                    // 1 sources

                                                    this = var6_30.mGroup.mId;
                                                    v6 = new Object[2];
                                                    var1_3 = v6;
                                                    v6[0] = this;
                                                    v6[1] = var4_15;
                                                    throw new AndrolibException(String.format("Repeated overlayable: pkgId=0x%02x, name=%s", var1_3));
                                                }
                                                case 515: {
                                                    var4_14 = this.mIn.readInt();
                                                    this.skipUnreadHeader((ResChunkPullParser)var3_11);
                                                    block33: for (var5_22 = 0; var5_22 < var4_14; ++var5_22) {
                                                        var6_32 = this.mIn.readInt();
                                                        var7_41 = this.mIn.readUtf16(128);
                                                        if (var6_32 == 0 || var7_41.isEmpty()) continue;
                                                        var8_45 = this.mTable;
                                                        var9_52 /* !! */  = (String)var8_45.mDynamicRefTable.get(var6_32);
                                                        if (var9_52 /* !! */  != null) {
                                                            if (var9_52 /* !! */ .equals(var7_41)) continue;
                                                            var6_33 = ResTable.TAG;
                                                            var7_41 = var6_32;
                                                            v7 = new Object[2];
                                                            var8_45 = v7;
                                                            v7[0] = var7_41;
                                                            v7[1] = var9_52 /* !! */ ;
                                                            Log.log(Level.WARNING, var6_33, "Repeated dynamic ref package ID: %s (assigned to name: %s)", var8_45);
                                                            continue;
                                                        }
                                                        var9_52 /* !! */  = var8_45.mDynamicRefTable.entrySet().iterator();
                                                        while (var9_52 /* !! */ .hasNext()) {
                                                            var10_55 = (Map.Entry)var9_52 /* !! */ .next();
                                                            if (!var7_41.equals(var10_55.getValue())) continue;
                                                            var6_34 = ResTable.TAG;
                                                            var8_45 = var10_55.getKey();
                                                            v8 = new Object[2];
                                                            var9_52 /* !! */  = v8;
                                                            v8[0] = var7_41;
                                                            v8[1] = var8_45;
                                                            Log.log(Level.WARNING, var6_34, "Repeated dynamic ref package name: %s (assigned to ID: %s)", var9_52 /* !! */ );
                                                            continue block33;
                                                        }
                                                        var8_45.mDynamicRefTable.put(var6_32, var7_41);
                                                    }
                                                    continue block30;
                                                }
                                                case 514: {
                                                    if (this.mTypeStringPool == null) {
                                                        throw new AndrolibException("Missing type string pool.");
                                                    }
                                                    var4_14 = this.mIn.readUnsignedByte();
                                                    this.mIn.readUnsignedByte();
                                                    this.mIn.readUnsignedShort();
                                                    var5_23 = this.mIn.readInt();
                                                    this.skipUnreadHeader((ResChunkPullParser)var3_11);
                                                    var6_35 = this.mEntrySpecFlagsOffsets;
                                                    if (var6_35 != null) {
                                                        var6_35.add(Pair.of(this.mIn.mPosition, var5_23));
                                                    }
                                                    this.mIn.skip(var5_23 * 4);
                                                    var5_24 = this.mPackage;
                                                    var6_35 = this.mTypeStringPool.getString(var4_14 - 1);
                                                    if ((ResTypeSpec)var5_24.mTypeSpecs.get(var4_14) != null) {
                                                        this = var5_24.mGroup.mId;
                                                        var1_3 = var4_14;
                                                        v9 = new Object[3];
                                                        var2_6 = v9;
                                                        v9[0] = this;
                                                        v9[1] = var1_3;
                                                        v9[2] = var6_35;
                                                        throw new AndrolibException(String.format("Repeated type spec: pkgId=0x%02x, typeId=0x%02x, typeName=%s", var2_6));
                                                    }
                                                    var7_41 = v10;
                                                    v10 = new ResTypeSpec(var5_24, var4_14, (String)var6_35);
                                                    var5_24.mTypeSpecs.put(var4_14, var7_41);
                                                    continue block30;
                                                }
                                                case 513: 
                                            }
                                            if (this.mTypeStringPool == null) {
                                                throw new AndrolibException("Missing type string pool.");
                                            }
                                            if (this.mKeyStringPool == null) {
                                                throw new AndrolibException("Missing key string pool");
                                            }
                                            var4_14 = this.mIn.readUnsignedByte() - this.mTypeIdOffset;
                                            var5_25 = this.mIn.readUnsignedByte();
                                            this.mIn.readUnsignedShort();
                                            var6_36 = this.mIn.readInt();
                                            var7_42 = this.mIn.readInt();
                                            v11 = this.mIn;
                                            var8_46 = v11.mPosition;
                                            var10_56 = v11.readInt();
                                            if (var10_56 < 8) {
                                                throw new AndrolibException("Config size < 8");
                                            }
                                            var11_68 = this.mIn.readUnsignedShort();
                                            var12_73 = this.mIn.readUnsignedShort();
                                            var13_74 = "";
                                            var14_80 = "";
                                            if (var10_56 >= 12) {
                                                var13_74 = this.mIn;
                                                var13_74.getClass();
                                                v12 = new byte[2];
                                                ByteStreams.readFully((InputStream)var13_74, v12, 0, 2);
                                                var13_74 = BinaryResourceParser.unpackLanguageOrRegion(v12, 'a');
                                                var14_80 = this.mIn;
                                                var14_80.getClass();
                                                v13 = new byte[2];
                                                ByteStreams.readFully((InputStream)var14_80, v13, 0, 2);
                                                var14_80 = BinaryResourceParser.unpackLanguageOrRegion(v13, '0');
                                            }
                                            var15_85 = 0;
                                            var16_90 = 0;
                                            if (var10_56 >= 14) {
                                                var15_85 = this.mIn.readUnsignedByte();
                                                var16_90 = this.mIn.readUnsignedByte();
                                            }
                                            var17_94 = 0;
                                            if (var10_56 >= 16) {
                                                var17_94 = this.mIn.readUnsignedShort();
                                            }
                                            var18_97 = 0;
                                            var19_98 = 0;
                                            var20_101 = 0;
                                            var21_102 = 0;
                                            if (var10_56 >= 20) {
                                                var18_97 = this.mIn.readUnsignedByte();
                                                var19_98 = this.mIn.readUnsignedByte();
                                                var20_101 = this.mIn.readUnsignedByte();
                                                var21_102 = this.mIn.readUnsignedByte();
                                            }
                                            var22_105 = 0;
                                            var23_106 = 0;
                                            var24_107 = 0;
                                            if (var10_56 >= 28) {
                                                var22_105 = this.mIn.readUnsignedShort();
                                                var23_106 = this.mIn.readUnsignedShort();
                                                var24_107 = this.mIn.readUnsignedShort();
                                                this.mIn.readUnsignedShort();
                                            }
                                            var25_108 = 0;
                                            var26_109 = 0;
                                            var27_110 = 0;
                                            if (var10_56 >= 32) {
                                                var25_108 = this.mIn.readUnsignedByte();
                                                var26_109 = this.mIn.readUnsignedByte();
                                                var27_110 = this.mIn.readUnsignedShort();
                                            }
                                            var28_111 = 0;
                                            var29_112 = 0;
                                            if (var10_56 >= 36) {
                                                var28_111 = this.mIn.readUnsignedShort();
                                                var29_112 = this.mIn.readUnsignedShort();
                                            }
                                            var30_113 = "";
                                            var31_114 = "";
                                            if (var10_56 >= 48) {
                                                var30_113 = this.mIn;
                                                var31_115 = 4;
                                                var30_113.getClass();
                                                var32_117 = new char[4];
                                                var33_118 = 0;
                                                while (true) {
                                                    v14 = var31_115;
                                                    var31_115 = v14 + -1;
                                                    if (v14 <= 0 || (var34_121 = (int)var30_113.readUnsignedByte()) == 0) break;
                                                    var35_122 = var33_118 + 1;
                                                    var32_117[var33_118] = var34_121;
                                                    var33_118 = var35_122;
                                                }
                                                if (var31_115 > 0) {
                                                    var30_113.skip(var31_115);
                                                }
                                                var30_113 = v15;
                                                v15 = new String(var32_117, 0, var33_118);
                                                var31_114 = this.mIn;
                                                var32_116 = 8;
                                                var31_114.getClass();
                                                var33_119 = new char[8];
                                                var34_121 = 0;
                                                while (true) {
                                                    v16 = var32_116;
                                                    var32_116 = v16 + -1;
                                                    if (v16 <= 0) break;
                                                    v17 = (char)var31_114.readUnsignedByte();
                                                    var35_122 = v17;
                                                    if (v17 == '\u0000') break;
                                                    var36_123 = var34_121 + '\u0001';
                                                    var33_119[var34_121] = var35_122;
                                                    var34_121 = var36_123;
                                                }
                                                if (var32_116 > 0) {
                                                    var31_114.skip(var32_116);
                                                }
                                                var31_114 = v18;
                                                v18 = new String(var33_119, 0, var34_121);
                                            }
                                            var32_116 = 0;
                                            var33_118 = 0;
                                            if (var10_56 >= 52) {
                                                var32_116 = this.mIn.readUnsignedByte();
                                                var33_118 = this.mIn.readUnsignedByte();
                                                this.mIn.readUnsignedShort();
                                            }
                                            var8_47 = (int)(this.mIn.mPosition - var8_46);
                                            var8_48 = this.readExceedingBytes("Config", var10_56, var8_47);
                                            var9_53 = v19;
                                            if (new ResConfig((int)var11_68, (int)var12_73, (String)var13_74, (String)var14_80, (int)var15_85, (int)var16_90, (int)var17_94, (int)var18_97, (int)var19_98, (int)var20_101, (int)var21_102, (int)var22_105, (int)var23_106, (int)var24_107, (int)var25_108, (int)var26_109, (int)var27_110, (int)var28_111, (int)var29_112, (String)var30_113, (String)var31_114, (int)var32_116, (int)var33_118, (byte[])var8_48).mIsInvalid) {
                                                this.mInvalidConfigs.add(var9_53);
                                            }
                                            this.skipUnreadHeader((ResChunkPullParser)var3_11);
                                            try {
                                                var8_48 = this.mPackage.getTypeSpec(var4_14);
                                            }
                                            catch (UndefinedResObjectException v20) {
                                                v21 = this.mPackage;
                                                var8_48 = v21;
                                                var10_57 = this.mTypeStringPool.getString(var4_14 - 1);
                                                if ((ResTypeSpec)v21.mTypeSpecs.get(var4_14) != null) break block113;
                                                var11_69 = v22;
                                                v22 = new ResTypeSpec((ResPackage)var8_48, var4_14, var10_57);
                                                var8_48.mTypeSpecs.put(var4_14, var11_69);
                                                var8_48 = var11_69;
                                            }
                                            var8_48 = var8_48.mName;
                                            if (!this.mInvalidConfigs.contains(var9_53)) break block118;
                                            if (this.mKeepBrokenResources) {
                                                v23 = new Object[2];
                                                var10_58 = v23;
                                                v23[0] = var8_48;
                                                v23[1] = var9_53;
                                                Log.log(Level.WARNING, BinaryResourceParser.TAG, "Invalid resource config detected: %s %s", (Object[])var10_58);
                                                var10_58 = this.mPackage;
                                                var11_70 = Pair.of(var4_14, var9_53);
                                                var12_72 = (ResType)var10_58.mTypes.get(var11_70);
                                                if (var12_72 == null) {
                                                    v24 = var10_58;
                                                    var10_58 = v24.getTypeSpec(var4_14);
                                                    var12_72 = v25;
                                                    v25 = new ResType((ResTypeSpec)var10_58, var9_53);
                                                    v24.mTypes.put(var11_70, var12_72);
                                                }
                                                break block119;
                                            } else {
                                                v26 = new Object[2];
                                                var10_58 = v26;
                                                v26[0] = var8_48;
                                                v26[1] = var9_53;
                                                Log.log(Level.WARNING, BinaryResourceParser.TAG, "Invalid resource config detected. Dropping resources: %s %s", (Object[])var10_58);
                                                var12_72 = null;
                                            }
                                            break block119;
                                        }
                                        var10_58 = this.mPackage;
                                        var11_71 = Pair.of(var4_14, var9_53);
                                        var12_72 = (ResType)this.mPackage.mTypes.get(var11_71);
                                        if (var12_72 == null) {
                                            var10_58 = var10_58.getTypeSpec(var4_14);
                                            var12_72 = v27;
                                            v27 = new ResType((ResTypeSpec)var10_58, var9_53);
                                            var10_58.mTypes.put(var11_71, var12_72);
                                        }
                                    }
                                    var10_59 = (var5_25 & 2) != 0;
                                    var5_25 = (var5_25 & 1) != 0 ? 1 : 0;
                                    if (var5_25 != 0) {
                                        this.mSparseEntries = true;
                                    }
                                    var11_67 = v28;
                                    v28 = new TreeMap<Integer, List>();
                                    for (var13_75 = 0; var13_75 < var6_36; ++var13_75) {
                                        var14_81 = this.mIn;
                                        if (var5_25 != 0) {
                                            var14_82 = var14_81.readUnsignedShort();
                                            var15_85 = this.mIn.readUnsignedShort() * 4;
                                        } else if (var10_59) {
                                            var14_82 = var14_81.readUnsignedShort();
                                            var15_85 = var14_82 == 65535 ? (var14_82 = -1) : (var14_82 *= 4);
                                            var14_82 = var13_75;
                                        } else {
                                            var15_85 = var14_81.readInt();
                                            var14_82 = var13_75;
                                        }
                                        var16_91 = (List)var11_67.get(var15_85);
                                        if (var16_91 == null) {
                                            var16_91 = v29;
                                            v29 = new ArrayList<E>();
                                            var11_67.put(var15_85, var16_91);
                                        }
                                        var16_91.add(var14_82);
                                    }
                                    var5_26 = (List)var11_67.get(-1);
                                    if (var5_26 != null) {
                                        if (var12_72 != null) {
                                            var10_60 = var5_26.iterator();
                                            while (var10_60.hasNext()) {
                                                var13_75 = (Integer)var10_60.next();
                                                if (this.mPackage.hasEntrySpec(var4_14, var13_75)) continue;
                                                this.mMissingEntrySpecs.add(ResId.of(this.mPackage.mGroup.mId, var4_14, var13_75));
                                            }
                                        }
                                        var11_67.remove(-1);
                                        var6_36 -= var5_26.size();
                                    }
                                    var5_26 = var11_67.entrySet().iterator();
                                    while (var5_26.hasNext()) {
                                        block121: {
                                            block114: {
                                                block123: {
                                                    block122: {
                                                        block120: {
                                                            v30 = var3_11;
                                                            v31 = (Map.Entry)var5_26.next();
                                                            var10_61 = (Integer)v31.getKey();
                                                            var11_67 = (List)v31.getValue();
                                                            var13_76 = v30.chunkStart() + (long)var7_42 + (long)var10_61;
                                                            var10_62 = v30.mChunkHeader;
                                                            if (var10_62 == null) {
                                                                throw new IllegalStateException();
                                                            }
                                                            if (var13_76 >= var3_11.mChunkOffset + (long)var10_62.size) {
                                                                var4_16 = BinaryResourceParser.TAG;
                                                                var5_26 = var6_36;
                                                                v32 = new Object[2];
                                                                var6_37 = v32;
                                                                v32[0] = var5_26;
                                                                v32[1] = var8_48;
                                                                Log.log(Level.WARNING, var4_16, "End of chunk hit. Skipping remaining %s entries in type: %s", var6_37);
                                                                continue block30;
                                                            }
                                                            this.mIn.jumpTo(var13_76);
                                                            var10_63 = this.mIn.readUnsignedShort();
                                                            var13_77 = this.mIn.readUnsignedShort();
                                                            var14_83 = this.mIn.readInt();
                                                            var15_86 = (var13_77 & 1) != 0 ? 1 : 0;
                                                            var16_92 = (var13_77 & 8) != 0 ? 1 : 0;
                                                            if (var14_83 != -1 != 0 || var16_92 != 0) break block120;
                                                            var10_64 = null;
                                                            break block121;
                                                        }
                                                        if (var16_92 != 0) {
                                                            this.mCompactEntries = true;
                                                        }
                                                        if (var15_86 != 0 && var16_92 == 0) {
                                                            var10_63 = this.mIn.readInt();
                                                            var13_77 = this.mIn.readInt();
                                                            if (var8_48.equals("id")) {
                                                                var10_65 /* !! */  = ResCustom.ID;
                                                            } else {
                                                                var15_87 = v33;
                                                                var10_65 /* !! */  = this.mPackage;
                                                                v33 = new ResReference((ResPackage)var10_65 /* !! */ , ResId.of((int)var10_63), false);
                                                                var10_65 /* !! */  = new ResBag$RawItem[var13_77];
                                                                var16_92 = 0;
                                                                for (var17_95 = 0; var17_95 < var13_77; ++var17_95) {
                                                                    var18_97 = this.mIn.readInt();
                                                                    var19_99 = true;
                                                                    if (this.mIn.readUnsignedShort() < 8) {
                                                                        v34 = null;
                                                                    } else {
                                                                        this.mIn.readUnsignedByte();
                                                                        var20_101 = this.mIn.readUnsignedByte();
                                                                        var21_103 = this.mIn.readInt();
                                                                        v34 = this.parseItem((String)var8_48, var19_99, var20_101, var21_103);
                                                                    }
                                                                    var19_100 = (ResItem)v34;
                                                                    if (var19_100 == null) continue;
                                                                    var20_101 = var16_92 + 1;
                                                                    var21_104 = v35;
                                                                    v35 = new ResBag$RawItem(var18_97, var19_100);
                                                                    var10_65 /* !! */ [var16_92] = var21_104;
                                                                    var16_92 = var20_101;
                                                                }
                                                                if (var16_92 < var13_77) {
                                                                    var10_65 /* !! */  = Arrays.copyOf(var10_65 /* !! */ , var16_92);
                                                                }
                                                                var10_65 /* !! */  = ResBag.parse((String)var8_48, var15_87, var10_65 /* !! */ );
                                                            }
lbl469:
                                                            // 4 sources

                                                            while (true) {
                                                                var13_78 = var10_65 /* !! */ ;
                                                                var10_63 = var14_83;
                                                                break block114;
                                                                break;
                                                            }
                                                        }
                                                        if (var16_92 == 0) break block122;
                                                        var13_77 = var13_77 >>> 8 & 255;
                                                        var13_78 = this.parseItem((String)var8_48, false, var13_77, (int)var14_83);
                                                        break block114;
                                                    }
                                                    var10_63 = false;
                                                    if (this.mIn.readUnsignedShort() >= 8) break block123;
                                                    var10_65 /* !! */  = null;
                                                    ** GOTO lbl469
                                                }
                                                this.mIn.readUnsignedByte();
                                                var13_77 = this.mIn.readUnsignedByte();
                                                var15_86 = this.mIn.readInt();
                                                var10_65 /* !! */  = this.parseItem((String)var8_48, var10_63, var13_77, var15_86);
                                                ** continue;
                                            }
                                            var10_64 = Pair.of((int)var10_63, var13_78);
                                        }
                                        v36 = var10_64;
                                        var10_66 = (Integer)v36.left;
                                        var13_79 = (ResValue)v36.right;
                                        if (var12_72 != null) {
                                            var14_84 = var11_67.iterator();
                                            while (var14_84.hasNext()) {
                                                var15_88 = (Integer)var14_84.next();
                                                var16_93 = ResId.of(this.mPackage.mGroup.mId, var4_14, var15_88);
                                                var17_96 = this.mPackage;
                                                if (var13_79 == null) {
                                                    if (var17_96.hasEntrySpec(var4_14, var15_88)) continue;
                                                    this.mMissingEntrySpecs.add(var16_93);
                                                    continue;
                                                }
                                                if (var17_96.hasEntry(var4_14, var15_88, var9_53)) {
                                                    v37 = new Object[2];
                                                    var15_89 = v37;
                                                    v37[0] = var16_93;
                                                    v37[1] = var9_53;
                                                    Log.log(Level.WARNING, BinaryResourceParser.TAG, "Ignoring repeated entry: id=%s, config=%s", var15_89);
                                                    continue;
                                                }
                                                if (!this.mPackage.hasEntrySpec(var4_14, var15_88)) {
                                                    this.mPackage.addEntrySpec(this.mKeyStringPool.getString(var10_66), var4_14, var15_88);
                                                    this.mMissingEntrySpecs.remove(var16_93);
                                                }
                                                this.mPackage.addEntry(var4_14, var15_88, var9_53, var13_79);
                                            }
                                        }
                                        var6_36 -= var11_67.size();
                                    }
                                    continue;
                                }
                                this = var8_48.mGroup.mId;
                                var1_3 = var4_14;
                                v38 = new Object[3];
                                var2_7 = v38;
                                v38[0] = this;
                                v38[1] = var1_3;
                                v38[2] = var10_57;
                                throw new AndrolibException(String.format("Repeated type spec: pkgId=0x%02x, typeId=0x%02x, typeName=%s", var2_7));
                            }
                            var4_14 = this.mIn.readInt();
                            this.skipUnreadHeader((ResChunkPullParser)var3_11);
                            for (var5_27 = 0; var5_27 < var4_14; ++var5_27) {
                                var6_38 = this.mIn.readInt();
                                var7_43 = this.mIn.readInt();
                                if (var6_38 == 0 || var7_43 == 0) continue;
                                var6_39 = this.mPackage;
                                var7_44 = ResId.of(var6_38);
                                var8_45 = ResId.of(var7_43);
                                if (var6_39.mAliases.containsKey(var7_44)) {
                                    this = var6_39.mGroup.mId;
                                    v39 = new Object[2];
                                    var1_3 = v39;
                                    v39[0] = this;
                                    v39[1] = var7_44;
                                    throw new AndrolibException(String.format("Repeated alias: pkgId=0x%02x, aliasId=%s", var1_3));
                                }
                                var6_39.mAliases.put(var7_44, var8_45);
                            }
                            continue;
                        }
                        var4_17 = ResStringPool.parse((ResChunkPullParser)var3_11);
                        if (this.mValueStringPool == null) {
                            this.mValueStringPool = var4_17;
                            continue;
                        }
                        if (this.mTypeStringPool == null) {
                            this.mTypeStringPool = var4_17;
                            continue;
                        }
                        if (this.mKeyStringPool == null) {
                            this.mKeyStringPool = var4_17;
                            continue;
                        }
                        BinaryResourceParser.skipUnexpectedChunk((ResChunkPullParser)var3_11);
                    }
                    if (this.mAllowDummyEntrySpecs) {
                        var3_11 = v40;
                        v40 = new ResReference(this.mPackage, ResId.NULL, false);
                        var4_18 = new ResBag$RawItem[]{};
                        for (ResId var6_40 : this.mMissingEntrySpecs) {
                            var7_41 = this.mPackage.getTypeSpec(var6_40.typeId());
                            var8_49 = var7_41.mName;
                            if (var8_49.equals("id")) {
                                var7_41 = ResCustom.ID;
                            } else if (var8_49.equals("string")) {
                                var7_41 = ResString.EMPTY;
                            } else {
                                var7_41 = var7_41.mName;
                                var7_41.getClass();
                                var9_51 = -1;
                                switch (var7_41.hashCode()) {
                                    default: {
                                        break;
                                    }
                                    case 109780401: {
                                        if (!var7_41.equals("style")) break;
                                        var9_51 = 4;
                                        break;
                                    }
                                    case 93090393: {
                                        if (!var7_41.equals("array")) break;
                                        var9_51 = 3;
                                        break;
                                    }
                                    case 3004913: {
                                        if (!var7_41.equals("attr")) break;
                                        var9_51 = 2;
                                        break;
                                    }
                                    case -475309713: {
                                        if (!var7_41.equals("plurals")) break;
                                        var9_51 = 1;
                                        break;
                                    }
                                    case -576469755: {
                                        if (!var7_41.equals("^attr-private")) break;
                                        var9_51 = 0;
                                    }
                                }
                                switch (var9_51) {
                                    default: {
                                        var7_41 = ResPrimitive.NULL;
                                        break;
                                    }
                                    case 0: 
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        var7_41 = ResBag.parse(var8_49, (ResReference)var3_11, var4_18);
                                    }
                                }
                            }
                            v41 = var6_40;
                            var8_50 = v41.typeId();
                            var9_51 = v41.mId & 65535;
                            this.mPackage.addEntrySpec("APKTOOL_DUMMY_" + var6_40, var8_50, var9_51);
                            this.mPackage.addEntry(var6_40.typeId(), var6_40.mId & 65535, ResConfig.DEFAULT, (ResValue)var7_41);
                        }
                    }
                    this.mMissingEntrySpecs.clear();
                    this.mInvalidConfigs.clear();
                    this.mPackage = null;
                    this.mTypeIdOffset = 0;
                    this.mTypeStringPool = null;
                    this.mKeyStringPool = null;
                    continue;
                }
                ++this.mPackageCount;
                throw var1_4;
            }
            var3_12 = ResStringPool.parse((ResChunkPullParser)var1_3);
            if (this.mValueStringPool == null) {
                this.mValueStringPool = var3_12;
                continue;
            }
            if (this.mTypeStringPool == null) {
                this.mTypeStringPool = var3_12;
                continue;
            }
            if (this.mKeyStringPool == null) {
                this.mKeyStringPool = var3_12;
                continue;
            }
            BinaryResourceParser.skipUnexpectedChunk((ResChunkPullParser)var1_3);
        }
        var0_1 = this.mPackageCount;
        if (var0_1 != var2_5) {
            var0_2 = BinaryResourceParser.TAG;
            var1_3 = var0_1;
            var2_8 = var2_5;
            v42 = new Object[2];
            var3_9 = v42;
            v42[0] = var1_3;
            v42[1] = var2_8;
            Log.log(Level.WARNING, var0_2, "Unexpected package count: %s (expected: %s)", var3_9);
        }
    }

    public final ResValue parseItem(String string, boolean bl, int n, int n2) {
        if (string.equals("id") && (n2 == 0 || n != 1 && n != 7)) {
            return ResCustom.ID;
        }
        if (n == 3) {
            Object object = ((BinaryResourceParser)object).mValueStringPool;
            if (object != null) {
                String string2;
                if ((object = ((ResStringPool)object).getText(n2)) instanceof String && (string2 = (String)object).length() > 0 && !bl && !string.equals("string")) {
                    return new ResFileReference(string2);
                }
                return new ResString((CharSequence)object);
            }
            throw new AndrolibException("Missing value string pool.");
        }
        return ResItem.parse(((BinaryResourceParser)object).mPackage, n, n2);
    }

    public final void skipUnreadHeader(ResChunkPullParser resChunkPullParser) {
        int n = (int)(this.mIn.mPosition - resChunkPullParser.chunkStart());
        String string = "Chunk header";
        ResChunkHeader resChunkHeader = resChunkPullParser.mChunkHeader;
        if (resChunkHeader != null) {
            this.readExceedingBytes(string, resChunkHeader.headerSize, n);
            return;
        }
        throw new IllegalStateException();
    }

    public final byte[] readExceedingBytes(String string, int n, int n2) {
        int n3 = n - n2;
        if (n3 > 0) {
            BinaryDataInputStream binaryDataInputStream = ((BinaryResourceParser)object).mIn;
            binaryDataInputStream.getClass();
            byte[] byArray = new byte[n3];
            Object object = byArray;
            ByteStreams.readFully(binaryDataInputStream, byArray, 0, n3);
            for (int i = 0; i < n3; ++i) {
                String string2;
                StringBuilder stringBuilder;
                if (object[i] == false) continue;
                String string3 = TAG;
                String string4 = "%s size: %s bytes, read: %s bytes. Exceeding bytes: %s";
                Integer n4 = n;
                Integer n5 = n2;
                BaseEncoding$Base16Encoding baseEncoding$Base16Encoding = BaseEncoding.BASE16;
                baseEncoding$Base16Encoding.getClass();
                int n6 = n3;
                Preconditions.checkPositionIndexes(0, n6, n6);
                StringBuilder stringBuilder2 = stringBuilder;
                BaseEncoding$Alphabet baseEncoding$Alphabet = baseEncoding$Base16Encoding.alphabet;
                int n7 = baseEncoding$Alphabet.charsPerChunk;
                stringBuilder2(IntMath.divide(n3, baseEncoding$Alphabet.bytesPerChunk) * n7);
                try {
                    baseEncoding$Base16Encoding.encodeTo(stringBuilder2, (byte[])object, n3);
                    string2 = stringBuilder.toString();
                }
                catch (IOException iOException) {
                    throw new AssertionError((Object)iOException);
                }
                Object[] objectArray = new Object[4];
                Object[] objectArray2 = objectArray;
                objectArray[0] = string;
                objectArray[1] = n4;
                objectArray[2] = n5;
                objectArray[3] = string2;
                Log.log(Level.WARNING, string3, string4, objectArray2);
                return object;
            }
        }
        return null;
    }
}

