/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.res.table.ResEntry;
import brut.androlib.res.table.value.ResAttribute$Symbol;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResString;
import brut.androlib.res.xml.ResStringEncoder;
import brut.androlib.res.xml.ResXmlSerializer;
import java.util.Objects;

public class ResAttribute
extends ResBag {
    public static final int[] ATTR_TYPE_MASKS = new int[]{2, 4, 8, 16, 32, 64, 128, 1};
    public static final String[] ATTR_TYPE_NAMES = new String[]{"string", "integer", "boolean", "color", "float", "dimension", "fraction", "reference"};
    public static final ResAttribute DEFAULT = new ResAttribute(null, 65535, Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
    public int mType;
    public final int mMin;
    public final int mMax;
    public final int mL10n;

    public ResAttribute(ResReference resReference, int n, int n2, int n3, int n4) {
        super(resReference);
        this.mType = n;
        this.mMin = n2;
        this.mMax = n3;
        this.mL10n = n4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void addValueType(int n) {
        int n2 = this.mType;
        if ((n2 & 0xFFFF) == 65535) return;
        if (n != 18) {
            switch (n) {
                default: {
                    if (n >= 28 && n <= 31) {
                        this.mType = n2 | 0x10;
                        return;
                    }
                    if (n < 16 || n > 31) return;
                    this.mType = n2 | 4;
                    return;
                }
                case 6: {
                    this.mType = n2 | 0x80;
                    return;
                }
                case 5: {
                    this.mType = n2 | 0x40;
                    return;
                }
                case 4: {
                    this.mType = n2 | 0x20;
                    return;
                }
                case 3: {
                    this.mType = n2 | 2;
                    return;
                }
                case 0: 
                case 1: 
                case 2: 
                case 7: 
                case 8: 
            }
            this.mType = n2 | 1;
            return;
        }
        this.mType = n2 | 8;
    }

    public ResAttribute$Symbol[] getSymbolsForValue(ResItem resItem) {
        return null;
    }

    public String formatValueFromSymbols(ResItem resItem) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void serializeToValuesXml(ResXmlSerializer var1_1, ResEntry var2_2) {
        v0 = var2_2;
        var2_2 = "attr";
        var1_1.startTag(null, (String)var2_2);
        var3_3 = v0.mSpec.mName;
        var1_1.attribute(null, "name", (String)var3_3);
        if ((this.mType & 65535) == 65535) {
            while (true) {
                var3_3 = null;
                break;
            }
        } else {
            var3_3 = v1;
            v1 = new StringBuilder();
            var4_8 = 0;
            while (true) {
                var5_9 = ResAttribute.ATTR_TYPE_MASKS;
                if (var4_8 >= 8) break;
                if ((this.mType & var5_9[var4_8]) != 0) {
                    if (var3_3.length() > 0) {
                        var3_3.append('|');
                    }
                    var3_3.append(ResAttribute.ATTR_TYPE_NAMES[var4_8]);
                }
                ++var4_8;
            }
            if (var3_3.length() == 0) ** continue;
            var3_3 = var3_3.toString();
        }
        if (var3_3 != null) {
            var1_1.attribute(null, "format", (String)var3_3);
        }
        if ((var3_4 = this.mMin) != -2147483648) {
            var3_5 = Integer.toString(var3_4);
            var1_1.attribute(null, "min", var3_5);
        }
        if ((var3_6 = this.mMax) != 0x7FFFFFFF) {
            var3_7 = Integer.toString(var3_6);
            var1_1.attribute(null, "max", var3_7);
        }
        if (this.mL10n == 1) {
            var1_1.attribute(null, "localization", "suggested");
        }
        this.serializeSymbolsToValuesXml(var1_1);
        var1_1.endTag(null, (String)var2_2);
    }

    public void serializeSymbolsToValuesXml(ResXmlSerializer resXmlSerializer) {
    }

    public String toString() {
        ResAttribute resAttribute = n;
        Integer n = resAttribute.mType;
        Integer n2 = resAttribute.mMin;
        Integer n3 = resAttribute.mMax;
        Integer n4 = resAttribute.mL10n;
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        objectArray[1] = n2;
        objectArray[2] = n3;
        objectArray[3] = n4;
        return String.format("ResAttribute{type=0x%04x, min=%s, max=%s, l10n=%s}", objectArray2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ResAttribute) {
            object = (ResAttribute)object;
            return this.mType == ((ResAttribute)object).mType && this.mMin == ((ResAttribute)object).mMin && this.mMax == ((ResAttribute)object).mMax && this.mL10n == ((ResAttribute)object).mL10n;
        }
        return false;
    }

    public int hashCode() {
        ResAttribute resAttribute = n;
        Integer n = resAttribute.mType;
        Integer n2 = resAttribute.mMin;
        Integer n3 = resAttribute.mMax;
        Integer n4 = resAttribute.mL10n;
        return Objects.hash(n, n2, n3, n4);
    }

    public final String formatValue(ResItem resItem, boolean bl) {
        String string = ((ResAttribute)((Object)charSequence)).formatValueFromSymbols(resItem);
        if (string != null) {
            return string;
        }
        if (bl && resItem instanceof ResString) {
            ResAttribute resAttribute = charSequence;
            CharSequence charSequence = ((ResString)resItem).mValue;
            return ResStringEncoder.encodeRawString(resAttribute.mType, charSequence.toString());
        }
        if (bl) {
            return resItem.toXmlAttributeValue();
        }
        return resItem.toXmlTextValue();
    }
}

