/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResAttribute$Symbol;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResCustom;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResValue;
import brut.androlib.res.xml.ResXmlSerializer;
import brut.common.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Level;

public final class ResEnum
extends ResAttribute {
    public static final String TAG = ResEnum.class.getName();
    public final ResAttribute$Symbol[] mSymbols;
    public HashMap mSymbolsCache;
    public HashMap mFormatsCache;

    public ResEnum(ResReference resReference, int n, int n2, int n3, int n4, ResAttribute$Symbol[] resAttribute$SymbolArray) {
        super(resReference, n, n2, n3, n4);
        this.mSymbols = resAttribute$SymbolArray;
    }

    @Override
    public final void resolveKeys() {
        ResPackage resPackage = resAttribute$SymbolArray.mParent.mPackage;
        boolean bl = resPackage.mGroup.mTable.mConfig.mDecodeResolve == 3;
        ResAttribute$Symbol[] resAttribute$SymbolArray = resAttribute$SymbolArray.mSymbols;
        int n = resAttribute$SymbolArray.mSymbols.length;
        for (int i = 0; i < n; ++i) {
            Object object = resAttribute$SymbolArray[i];
            ResReference resReference = ((ResAttribute$Symbol)object).mKey;
            if (resReference.resolve() != null) continue;
            Object object2 = resReference.mResId;
            if (!bl && ((ResId)object2).pkgId() == resPackage.mGroup.mId) {
                Object object3 = object2;
                int n2 = ((ResId)object3).typeId();
                int n3 = ((ResId)object3).mId & 0xFFFF;
                resPackage.addEntrySpec("APKTOOL_DUMMY_" + object2, n2, n3);
                resPackage.addEntry(((ResId)object2).typeId(), ((ResId)object2).mId & 0xFFFF, ResConfig.DEFAULT, ResCustom.ID);
                continue;
            }
            ResAttribute$Symbol resAttribute$Symbol = object;
            object = TAG;
            object2 = resAttribute$Symbol.mValue;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = resReference;
            objectArray[1] = object2;
            Log.log(Level.WARNING, (String)object, "Unresolved enum reference: key=%s, value=%s", objectArray2);
        }
    }

    @Override
    public final ResAttribute$Symbol[] getSymbolsForValue(ResItem resItem) {
        int n;
        if (!(resItem instanceof ResPrimitive) || (n = resItem.mType) != 16 && n != 17) {
            return null;
        }
        return this.getSymbols(((ResPrimitive)resItem).mData);
    }

    @Override
    public final String formatValueFromSymbols(ResItem resItem) {
        int n;
        if (!(resItem instanceof ResPrimitive) || (n = resItem.mType) != 16 && n != 17) {
            return null;
        }
        int n2 = ((ResPrimitive)resItem).mData;
        ResAttribute$Symbol[] resAttribute$SymbolArray = this.mFormatsCache;
        if (this.mFormatsCache == null) {
            HashMap hashMap;
            resAttribute$SymbolArray = hashMap;
            hashMap = new HashMap();
            this.mFormatsCache = resAttribute$SymbolArray;
        } else if (resAttribute$SymbolArray.containsKey(n2)) {
            return (String)this.mFormatsCache.get(n2);
        }
        resAttribute$SymbolArray = this.getSymbols(n2);
        String string = null;
        if (resAttribute$SymbolArray != null) {
            int n3 = resAttribute$SymbolArray.length;
            for (int i = 0; i < n3; ++i) {
                ResEntrySpec resEntrySpec = resAttribute$SymbolArray[i].mKey.resolve();
                if (resEntrySpec == null) continue;
                string = resEntrySpec.mName;
                if (n2 != -1 || !string.equals("fill_parent")) break;
            }
        }
        this.mFormatsCache.put(n2, string);
        return string;
    }

    @Override
    public final void serializeSymbolsToValuesXml(ResXmlSerializer resXmlSerializer) {
        ResAttribute$Symbol[] resAttribute$SymbolArray = resAttribute$SymbolArray.mSymbols;
        int n = resAttribute$SymbolArray.mSymbols.length;
        for (int i = 0; i < n; ++i) {
            Object object = resAttribute$SymbolArray[i];
            ResEntrySpec resEntrySpec = ((ResAttribute$Symbol)object).mKey.resolve();
            if (resEntrySpec == null) continue;
            ResXmlSerializer resXmlSerializer2 = resXmlSerializer;
            ResAttribute$Symbol resAttribute$Symbol = object;
            resXmlSerializer.startTag(null, "enum");
            object = resEntrySpec.mName;
            resXmlSerializer.attribute(null, "name", (String)object);
            object = resAttribute$Symbol.mValue.toXmlTextValue();
            resXmlSerializer2.attribute(null, "value", (String)object);
            resXmlSerializer2.endTag(null, "enum");
        }
    }

    @Override
    public final String toString() {
        ResEnum resEnum = resValue;
        ResValue resValue = resEnum.mParent;
        Integer n = resEnum.mType;
        Integer n2 = resEnum.mMin;
        Integer n3 = resEnum.mMax;
        Integer n4 = resEnum.mL10n;
        String string = Arrays.toString(resEnum.mSymbols);
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = objectArray;
        objectArray[0] = resValue;
        objectArray[1] = n;
        objectArray[2] = n2;
        objectArray[3] = n3;
        objectArray[4] = n4;
        objectArray[5] = string;
        return String.format("ResEnum{parent=%s, type=0x%04x, min=%s, max=%s, l10n=%s, symbols=%s}", objectArray2);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ResEnum) {
            object = (ResEnum)object;
            return this.mParent.equals(((ResBag)object).mParent) && this.mType == ((ResAttribute)object).mType && this.mMin == ((ResAttribute)object).mMin && this.mMax == ((ResAttribute)object).mMax && this.mL10n == ((ResAttribute)object).mL10n && Arrays.equals(this.mSymbols, ((ResEnum)object).mSymbols);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        ResEnum resEnum = resValue;
        ResValue resValue = resEnum.mParent;
        Integer n = resEnum.mType;
        Integer n2 = resEnum.mMin;
        Integer n3 = resEnum.mMax;
        Integer n4 = resEnum.mL10n;
        Integer n5 = Arrays.hashCode(resEnum.mSymbols);
        return Objects.hash(resValue, n, n2, n3, n4, n5);
    }

    public final ResAttribute$Symbol[] getSymbols(int n) {
        ResAttribute$Symbol[] resAttribute$SymbolArray = this.mSymbolsCache;
        if (this.mSymbolsCache == null) {
            HashMap hashMap;
            resAttribute$SymbolArray = hashMap;
            hashMap = new HashMap();
            this.mSymbolsCache = resAttribute$SymbolArray;
        } else if (resAttribute$SymbolArray.containsKey(n)) {
            return (ResAttribute$Symbol[])this.mSymbolsCache.get(n);
        }
        resAttribute$SymbolArray = this.mSymbols;
        int n2 = resAttribute$SymbolArray.length;
        ResAttribute$Symbol[] resAttribute$SymbolArray2 = new ResAttribute$Symbol[n2];
        int n3 = 0;
        int n4 = this.mSymbols.length;
        for (int i = 0; i < n4; ++i) {
            ResAttribute$Symbol resAttribute$Symbol = resAttribute$SymbolArray[i];
            if (resAttribute$Symbol.mValue.mData != n) continue;
            int n5 = n3 + 1;
            resAttribute$SymbolArray2[n3] = resAttribute$Symbol;
            n3 = n5;
        }
        if (n3 == 0) {
            resAttribute$SymbolArray2 = null;
        } else if (n3 < n2) {
            resAttribute$SymbolArray2 = Arrays.copyOf(resAttribute$SymbolArray2, n3);
        }
        this.mSymbolsCache.put(n, resAttribute$SymbolArray2);
        return resAttribute$SymbolArray2;
    }
}

