/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.table.value;

import brut.androlib.res.table.ResConfig;
import brut.androlib.res.table.ResEntrySpec;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResPackage;
import brut.androlib.res.table.value.ResAttribute;
import brut.androlib.res.table.value.ResAttribute$Symbol;
import brut.androlib.res.table.value.ResBag;
import brut.androlib.res.table.value.ResCustom;
import brut.androlib.res.table.value.ResItem;
import brut.androlib.res.table.value.ResPrimitive;
import brut.androlib.res.table.value.ResReference;
import brut.androlib.res.table.value.ResValue;
import brut.androlib.res.xml.ResXmlSerializer;
import brut.common.Log;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Level;

public final class ResFlags
extends ResAttribute {
    public static final String TAG = ResFlags.class.getName();
    public final ResAttribute$Symbol[] mSymbols;
    public HashMap mSymbolsCache;
    public HashMap mFormatsCache;
    public ResAttribute$Symbol[] mSortedSymbols;

    public ResFlags(ResReference resReference, int n, int n2, int n3, int n4, ResAttribute$Symbol[] resAttribute$SymbolArray) {
        super(resReference, n, n2, n3, n4);
        this.mSymbols = resAttribute$SymbolArray;
    }

    public static int lambda$getSymbols$1(ResAttribute$Symbol resAttribute$Symbol) {
        return resAttribute$Symbol.mValue.mData;
    }

    public static int lambda$getSymbols$0(ResAttribute$Symbol resAttribute$Symbol) {
        return Integer.bitCount(resAttribute$Symbol.mValue.mData);
    }

    @Override
    public final void resolveKeys() {
        ResPackage resPackage = resAttribute$SymbolArray.mParent.mPackage;
        boolean bl = resPackage.mGroup.mTable.mConfig.mDecodeResolve == 3;
        ResAttribute$Symbol[] resAttribute$SymbolArray = resAttribute$SymbolArray.mSymbols;
        int n = resAttribute$SymbolArray.mSymbols.length;
        for (int i = 0; i < n; ++i) {
            Object object = resAttribute$SymbolArray[i];
            ResReference resReference = ((ResAttribute$Symbol)object).mKey;
            if (resReference.resolve() != null) continue;
            Object object2 = resReference.mResId;
            if (!bl && ((ResId)object2).pkgId() == resPackage.mGroup.mId) {
                Object object3 = object2;
                int n2 = ((ResId)object3).typeId();
                int n3 = ((ResId)object3).mId & 0xFFFF;
                resPackage.addEntrySpec("APKTOOL_DUMMY_" + object2, n2, n3);
                resPackage.addEntry(((ResId)object2).typeId(), ((ResId)object2).mId & 0xFFFF, ResConfig.DEFAULT, ResCustom.ID);
                continue;
            }
            ResAttribute$Symbol resAttribute$Symbol = object;
            object = TAG;
            object2 = resAttribute$Symbol.mValue;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = resReference;
            objectArray[1] = object2;
            Log.log(Level.WARNING, (String)object, "Unresolved flag reference: key=%s, value=%s", objectArray2);
        }
    }

    @Override
    public final ResAttribute$Symbol[] getSymbolsForValue(ResItem resItem) {
        int n;
        if (!(resItem instanceof ResPrimitive) || (n = resItem.mType) != 16 && n != 17) {
            return null;
        }
        return this.getSymbols$1(((ResPrimitive)resItem).mData);
    }

    @Override
    public final String formatValueFromSymbols(ResItem resItem) {
        int n;
        if (!(resItem instanceof ResPrimitive) || (n = resItem.mType) != 16 && n != 17) {
            return null;
        }
        int n2 = ((ResPrimitive)resItem).mData;
        ResAttribute$Symbol[] resAttribute$SymbolArray = this.mFormatsCache;
        if (this.mFormatsCache == null) {
            HashMap hashMap;
            resAttribute$SymbolArray = hashMap;
            hashMap = new HashMap();
            this.mFormatsCache = resAttribute$SymbolArray;
        } else if (resAttribute$SymbolArray.containsKey(n2)) {
            return (String)this.mFormatsCache.get(n2);
        }
        resAttribute$SymbolArray = this.getSymbols$1(n2);
        CharSequence charSequence = null;
        if (resAttribute$SymbolArray != null) {
            StringBuilder stringBuilder;
            charSequence = stringBuilder;
            stringBuilder = new StringBuilder();
            int n3 = resAttribute$SymbolArray.length;
            for (int i = 0; i < n3; ++i) {
                ResEntrySpec resEntrySpec = resAttribute$SymbolArray[i].mKey.resolve();
                if (resEntrySpec == null) continue;
                if (((StringBuilder)charSequence).length() > 0) {
                    ((StringBuilder)charSequence).append('|');
                }
                ((StringBuilder)charSequence).append(resEntrySpec.mName);
            }
            charSequence = ((StringBuilder)charSequence).toString();
        }
        this.mFormatsCache.put(n2, charSequence);
        return charSequence;
    }

    @Override
    public final void serializeSymbolsToValuesXml(ResXmlSerializer resXmlSerializer) {
        ResAttribute$Symbol[] resAttribute$SymbolArray = resAttribute$SymbolArray.mSymbols;
        int n = resAttribute$SymbolArray.mSymbols.length;
        for (int i = 0; i < n; ++i) {
            Object object = resAttribute$SymbolArray[i];
            ResEntrySpec resEntrySpec = ((ResAttribute$Symbol)object).mKey.resolve();
            if (resEntrySpec == null) continue;
            ResXmlSerializer resXmlSerializer2 = resXmlSerializer;
            ResAttribute$Symbol resAttribute$Symbol = object;
            resXmlSerializer.startTag(null, "flag");
            object = resEntrySpec.mName;
            resXmlSerializer.attribute(null, "name", (String)object);
            object = resAttribute$Symbol.mValue.toXmlTextValue();
            resXmlSerializer2.attribute(null, "value", (String)object);
            resXmlSerializer2.endTag(null, "flag");
        }
    }

    @Override
    public final String toString() {
        ResFlags resFlags = resValue;
        ResValue resValue = resFlags.mParent;
        Integer n = resFlags.mType;
        Integer n2 = resFlags.mMin;
        Integer n3 = resFlags.mMax;
        Integer n4 = resFlags.mL10n;
        String string = Arrays.toString(resFlags.mSymbols);
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = objectArray;
        objectArray[0] = resValue;
        objectArray[1] = n;
        objectArray[2] = n2;
        objectArray[3] = n3;
        objectArray[4] = n4;
        objectArray[5] = string;
        return String.format("ResFlags{parent=%s, type=0x%04x, min=%s, max=%s, l10n=%s, symbols=%s}", objectArray2);
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ResFlags) {
            object = (ResFlags)object;
            return this.mParent.equals(((ResBag)object).mParent) && this.mType == ((ResAttribute)object).mType && this.mMin == ((ResAttribute)object).mMin && this.mMax == ((ResAttribute)object).mMax && this.mL10n == ((ResAttribute)object).mL10n && Arrays.equals(this.mSymbols, ((ResFlags)object).mSymbols);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        ResFlags resFlags = resValue;
        ResValue resValue = resFlags.mParent;
        Integer n = resFlags.mType;
        Integer n2 = resFlags.mMin;
        Integer n3 = resFlags.mMax;
        Integer n4 = resFlags.mL10n;
        Integer n5 = Arrays.hashCode(resFlags.mSymbols);
        return Objects.hash(resValue, n, n2, n3, n4, n5);
    }

    public final ResAttribute$Symbol[] getSymbols$1(int n) {
        Object object;
        Object object2 = this.mSymbolsCache;
        if (this.mSymbolsCache == null) {
            HashMap hashMap;
            object2 = hashMap;
            hashMap = new HashMap();
            this.mSymbolsCache = object2;
        } else if (((HashMap)object2).containsKey(n)) {
            return (ResAttribute$Symbol[])this.mSymbolsCache.get(n);
        }
        if (this.mSortedSymbols == null) {
            ResFlags resFlags = this;
            resFlags.mSortedSymbols = (ResAttribute$Symbol[])resFlags.mSymbols.clone();
            object2 = Comparator.comparingInt(ResFlags::lambda$getSymbols$0);
            object = Comparator.comparingInt(ResFlags::lambda$getSymbols$1);
            Arrays.sort(resFlags.mSortedSymbols, object2.reversed().thenComparing(object));
        }
        object2 = this.mSortedSymbols;
        object = new ResAttribute$Symbol[this.mSortedSymbols.length];
        int n2 = 0;
        if (n == 0) {
            for (Object object3 : object2) {
                if (((ResAttribute$Symbol)object3).mValue.mData != 0) continue;
                int n3 = n2 + 1;
                object[n2] = object3;
                n2 = n3;
            }
        } else {
            int n4;
            int n5 = 0;
            for (Object object4 : object2) {
                n4 = ((ResAttribute$Symbol)object4).mValue.mData;
                if ((n & n4) != n4 || (n5 & n4) == n4) continue;
                int n6 = n5;
                n5 = n2 + 1;
                object[n2] = object4;
                n2 = n6 | n4;
                if (n2 == n) {
                    n2 = n5;
                    break;
                }
                int n7 = n2;
                n2 = n5;
                n5 = n7;
            }
            if (n2 > 2) {
                object2 = new ResAttribute$Symbol[n2];
                n5 = 0;
                for (int i = 0; i < n2; ++i) {
                    ResAttribute$Symbol resAttribute$Symbol = object[i];
                    int n8 = 0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        ResAttribute$Symbol resAttribute$Symbol2 = object[n4];
                        if (n4 == i) continue;
                        n8 |= resAttribute$Symbol2.mValue.mData;
                    }
                    if ((resAttribute$Symbol.mValue.mData & ~n8) == 0) continue;
                    n8 = n5 + 1;
                    object2[n5] = resAttribute$Symbol;
                    n5 = n8;
                }
                object = object2;
                n2 = n5;
            }
        }
        if (n2 == 0) {
            object = null;
        } else if (n2 < ((ResAttribute$Symbol[])object).length) {
            object = Arrays.copyOf(object, n2);
        }
        this.mSymbolsCache.put(n, object);
        return object;
    }
}

