/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.common.Log;
import brut.directory.Directory$ParsedPath;
import brut.directory.Directory$SubPath;
import brut.directory.DirectoryException;
import brut.directory.PathAlreadyExists;
import brut.directory.PathNotExist;
import brut.util.BrutIO;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;

public abstract class Directory
implements AutoCloseable {
    public LinkedHashSet mFiles;
    public LinkedHashSet mFilesRecursive;
    public LinkedHashMap mDirs;

    public final Directory$SubPath getSubPath(String string) {
        Object object;
        int n = string.indexOf(47);
        if (n == -1) {
            Directory$ParsedPath directory$ParsedPath;
            object = directory$ParsedPath;
            directory$ParsedPath = new Directory$ParsedPath(null, string);
        } else {
            Directory$ParsedPath directory$ParsedPath;
            Directory$ParsedPath directory$ParsedPath2 = directory$ParsedPath;
            object = string.substring(0, n);
            directory$ParsedPath = new Directory$ParsedPath((String)object, string.substring(n + 1));
            object = directory$ParsedPath2;
        }
        if (((Directory$ParsedPath)object).dir == null) {
            return new Directory$SubPath(null, ((Directory$ParsedPath)object).subpath);
        }
        if (directory.getDirs(false).containsKey(((Directory$ParsedPath)object).dir)) {
            Directory directory = (Directory)directory.getDirs(false).get(((Directory$ParsedPath)object).dir);
            return new Directory$SubPath(directory, ((Directory$ParsedPath)object).subpath);
        }
        throw new PathNotExist(string);
    }

    public abstract void load();

    public abstract InputStream getFileInputImpl(String var1);

    public OutputStream getFileOutputImpl(String string) {
        throw new UnsupportedOperationException();
    }

    public void removeFileImpl(String string) {
        throw new UnsupportedOperationException();
    }

    public Directory createDirImpl(String string) {
        throw new UnsupportedOperationException();
    }

    public abstract long getSize(String var1);

    public abstract int getCompressionLevel(String var1);

    @Override
    public void close() {
    }

    public final Set getFiles(boolean bl) {
        if (this.mFiles == null) {
            this.load();
        }
        if (!bl) {
            return this.mFiles;
        }
        if (this.mFilesRecursive == null) {
            this.mFilesRecursive = new LinkedHashSet(this.mFiles);
            for (Map.Entry entry : this.getDirs(false).entrySet()) {
                for (String string : ((Directory)entry.getValue()).getFiles(true)) {
                    this.mFilesRecursive.add((String)entry.getKey() + "/" + string);
                }
            }
        }
        return this.mFilesRecursive;
    }

    public final boolean containsFile(String object) {
        try {
            object = this.getSubPath((String)object);
            Directory directory = ((Directory$SubPath)object).dir;
            if (directory != null) {
                return directory.containsFile(((Directory$SubPath)object).path);
            }
            return this.getFiles(false).contains(((Directory$SubPath)object).path);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
    }

    public final boolean containsDir(String object) {
        try {
            object = this.getSubPath((String)object);
            Directory directory = ((Directory$SubPath)object).dir;
            if (directory != null) {
                return directory.containsDir(((Directory$SubPath)object).path);
            }
            return this.getDirs(false).containsKey(((Directory$SubPath)object).path);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
    }

    public final InputStream getFileInput(String string) {
        Directory$SubPath directory$SubPath = this.getSubPath(string);
        Directory directory = directory$SubPath.dir;
        if (directory != null) {
            return directory.getFileInput(directory$SubPath.path);
        }
        if (this.getFiles(false).contains(directory$SubPath.path)) {
            return this.getFileInputImpl(directory$SubPath.path);
        }
        throw new PathNotExist(string);
    }

    public final OutputStream getFileOutput(String string) {
        Directory directory;
        Directory$ParsedPath directory$ParsedPath;
        int n = string.indexOf(47);
        if (n == -1) {
            Directory$ParsedPath directory$ParsedPath2;
            directory$ParsedPath = directory$ParsedPath2;
            directory$ParsedPath2 = new Directory$ParsedPath(null, string);
        } else {
            Directory$ParsedPath directory$ParsedPath3;
            Directory$ParsedPath directory$ParsedPath4 = directory$ParsedPath3;
            String string2 = string;
            string = string.substring(0, n);
            directory$ParsedPath3 = new Directory$ParsedPath(string, string2.substring(n + 1));
            directory$ParsedPath = directory$ParsedPath4;
        }
        string = directory$ParsedPath.dir;
        if (string == null) {
            directory.getFiles(false).add(directory$ParsedPath.subpath);
            return directory.getFileOutputImpl(directory$ParsedPath.subpath);
        }
        try {
            directory = directory.createDir(string);
        }
        catch (PathAlreadyExists pathAlreadyExists) {
            directory = (Directory)directory.getDirs(false).get(directory$ParsedPath.dir);
        }
        return directory.getFileOutput(directory$ParsedPath.subpath);
    }

    public final boolean removeFile(String object) {
        try {
            object = this.getSubPath((String)object);
            Directory directory = ((Directory$SubPath)object).dir;
            if (directory != null) {
                return directory.removeFile(((Directory$SubPath)object).path);
            }
            if (!this.getFiles(false).contains(((Directory$SubPath)object).path)) {
                return false;
            }
            Directory directory2 = this;
            directory2.removeFileImpl(((Directory$SubPath)object).path);
            directory2.getFiles(false).remove(((Directory$SubPath)object).path);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
        return true;
    }

    public final Directory getDir(String string) {
        Directory$SubPath directory$SubPath = this.getSubPath(string);
        Directory directory = directory$SubPath.dir;
        if (directory != null) {
            return directory.getDir(directory$SubPath.path);
        }
        if (this.getDirs(false).containsKey(directory$SubPath.path)) {
            return (Directory)this.getDirs(false).get(directory$SubPath.path);
        }
        throw new PathNotExist(string);
    }

    public final Directory createDir(String object) {
        Directory directory;
        Object object2;
        int n = ((String)object).indexOf(47);
        if (n == -1) {
            Directory$ParsedPath directory$ParsedPath;
            object2 = directory$ParsedPath;
            directory$ParsedPath = new Directory$ParsedPath(null, (String)object);
        } else {
            Directory$ParsedPath directory$ParsedPath;
            Directory$ParsedPath directory$ParsedPath2 = directory$ParsedPath;
            object2 = ((String)object).substring(0, n);
            directory$ParsedPath = new Directory$ParsedPath((String)object2, ((String)object).substring(n + 1));
            object2 = directory$ParsedPath2;
        }
        if (((Directory$ParsedPath)object2).dir == null) {
            if (!directory.getDirs(false).containsKey(((Directory$ParsedPath)object2).subpath)) {
                object = directory.createDirImpl(((Directory$ParsedPath)object2).subpath);
                directory.getDirs(false).put(((Directory$ParsedPath)object2).subpath, object);
                return object;
            }
            throw new PathAlreadyExists((String)object);
        }
        if (directory.getDirs(false).containsKey(((Directory$ParsedPath)object2).dir)) {
            directory = (Directory)directory.getDirs(false).get(((Directory$ParsedPath)object2).dir);
        } else {
            Directory directory2 = directory;
            directory = directory2.createDirImpl(((Directory$ParsedPath)object2).dir);
            directory2.getDirs(false).put(((Directory$ParsedPath)object2).dir, directory);
        }
        return directory.createDir(((Directory$ParsedPath)object2).subpath);
    }

    public final LinkedHashMap getDirs(boolean bl) {
        LinkedHashMap<String, Directory> linkedHashMap;
        if (((Directory)this).mDirs == null) {
            ((Directory)this).load();
        }
        if (!bl) {
            return ((Directory)this).mDirs;
        }
        LinkedHashMap<String, Directory> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, Directory>(((Directory)this).mDirs);
        for (Map.Entry entry : ((Directory)this).mDirs.entrySet()) {
            for (Map.Entry entry2 : ((Directory)entry.getValue()).getDirs(true).entrySet()) {
                linkedHashMap2.put((String)entry.getKey() + "/" + (String)entry2.getKey(), (Directory)entry2.getValue());
            }
        }
        return linkedHashMap2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void copyToDir(File var1_4, String var2_5, String var3_6) {
        block15: {
            block14: {
                block13: {
                    if (!this.containsDir(var2_5)) break block13;
                    v0 = this;
                    v1 = var2_5;
                    this = v2;
                    v2 = new File((File)var1_4, (String)var3_6);
                    var1_4 = v0.getDir(v1);
                    try {
                        var3_6 = var1_4.getFiles(true).iterator();
                        while (var3_6.hasNext() != false) {
                            v3 = (String)var3_6.next();
                            var1_4.copyToDir((File)this, v3, v3);
                        }
                        return;
                    }
                    catch (IOException var0_1) {
                        throw new DirectoryException("Error copying file: " + var2_5, var0_1);
                    }
                    catch (InvalidPathException var0_2) {}
                    break block15;
                }
                if (this.containsFile(var2_5) == false) return;
                var3_6 = BrutIO.sanitizePath((File)var1_4, (String)var3_6);
                {
                    if (!var3_6.isEmpty()) break block14;
                    return;
                }
            }
            var4_7 = v4;
            {
                if (!new File((File)var1_4, (String)var3_6).exists()) ** GOTO lbl-1000
                v5 = var4_7.delete();
            }
            ** GOTO lbl33
lbl-1000:
            // 1 sources

            {
                var1_4 = var4_7.getParentFile();
                if (var1_4 == null) ** GOTO lbl33
            }
            {
                v5 = var1_4.mkdirs();
lbl33:
                // 3 sources

                this = this.getFileInput(var2_5);
                var1_4 = Files.newOutputStream(var4_7.toPath(), new OpenOption[0]);
            }
            v6 = this;
            v7 = v6;
            IOUtils.copy((InputStream)v6, (OutputStream)var1_4);
            {
                catch (Throwable v8) {
                    IOUtils.closeQ((Closeable)this);
                    IOUtils.closeQ((Closeable)var1_4);
                    throw v8;
                }
                IOUtils.closeQ((Closeable)v7);
                IOUtils.closeQ((Closeable)var1_4);
                return;
            }
        }
        var0_3 = var0_2.getMessage();
        v9 = new Object[2];
        var1_4 = v9;
        v9[0] = var2_5;
        v9[1] = var0_3;
        Log.log(Level.WARNING, "", "Skipping file %s (%s)", (Object[])var1_4);
    }
}

