/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.Directory;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public final class FileDirectory
extends Directory {
    public final File mDir;

    public FileDirectory(File file) {
        if (file.isDirectory()) {
            this.mDir = file;
            return;
        }
        throw new DirectoryException("file must be a directory: " + file);
    }

    @Override
    public final void load() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        File[] fileArray = this.mDir.listFiles();
        Arrays.sort(fileArray, Comparator.comparing(File::getName));
        for (File file : fileArray) {
            if (file.isFile()) {
                this.mFiles.add(file.getName());
                continue;
            }
            try {
                this.mDirs.put(file.getName(), new FileDirectory(file));
            }
            catch (DirectoryException directoryException) {}
        }
    }

    @Override
    public final InputStream getFileInputImpl(String string) {
        File file;
        File file2;
        try {
            File file3;
            file2 = file3;
            file = file3;
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
        file2(this.mDir.getPath() + "/" + string);
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    @Override
    public final OutputStream getFileOutputImpl(String string) {
        File file;
        File file2;
        try {
            File file3;
            file2 = file3;
            file = file3;
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
        file2(this.mDir.getPath() + "/" + string);
        return Files.newOutputStream(file.toPath(), new OpenOption[0]);
    }

    @Override
    public final void removeFileImpl(String string) {
        new File(this.mDir.getPath() + "/" + string).delete();
    }

    @Override
    public final Directory createDirImpl(String string) {
        File file;
        File file2 = file;
        new File(this.mDir.getPath() + "/" + string).mkdirs();
        return new FileDirectory(file2);
    }

    @Override
    public final long getSize(String string) {
        File file;
        File file2 = file;
        if (new File(this.mDir.getPath() + "/" + string).isFile()) {
            return file2.length();
        }
        throw new DirectoryException("file must be a file: " + file2);
    }

    @Override
    public final int getCompressionLevel(String string) {
        return 0;
    }
}

